/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.visitor;

import java.util.HashMap;
import java.util.Map;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Length;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotools.styling.visitor.Measure;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;

enum RescalingMode {
    KeepUnits{
        final Map<Unit, String> UNIT_SYMBOLS = new HashMap<Unit, String>(){
            {
                this.put(NonSI.PIXEL, "px");
                this.put(NonSI.FOOT, "ft");
                this.put(SI.METER, "m");
            }
        };

        @Override
        public String rescaleToStringInternal(double scaleFactor, Measure measure) {
            double rescaled = measure.value * scaleFactor;
            String rescaledString = rescaled == (double)((int)rescaled) ? String.valueOf((int)rescaled) : String.valueOf(rescaled);
            if (measure.isPixelInPixelDefault()) {
                return rescaledString;
            }
            return rescaledString + this.UNIT_SYMBOLS.get(measure.uom);
        }
    }
    ,
    Pixels{

        @Override
        public String rescaleToStringInternal(double scaleFactor, Measure measure) {
            if (measure.isRealWorldUnit()) {
                return String.valueOf(measure.value);
            }
            return String.valueOf(measure.value * scaleFactor);
        }

        @Override
        public Expression rescaleToExpression(Expression scaleFactor, Measure measure) {
            if (measure.isRealWorldUnit()) {
                return measure.expression;
            }
            return super.rescaleToExpression(scaleFactor, measure);
        }
    }
    ,
    RealWorld{

        @Override
        public String rescaleToStringInternal(double scaleFactor, Measure measure) {
            return String.valueOf(measure.value * this.computeRescaleMultiplier(scaleFactor, measure.uom));
        }

        double computeRescaleMultiplier(double mapScale, Unit<Length> uom) {
            if (uom == null || uom.equals((Object)NonSI.PIXEL)) {
                return 1.0;
            }
            if (uom == SI.METER) {
                return mapScale;
            }
            UnitConverter converter = uom.getConverterTo(SI.METER);
            return converter.convert(mapScale);
        }
    };


    public abstract String rescaleToStringInternal(double var1, Measure var3);

    public String rescaleToString(double scaleFactor, Measure measure) {
        if (measure.value == null) {
            throw new IllegalStateException("Cannot rescale to literal, the value is a generic expression, not a static value: " + measure.expression);
        }
        return this.rescaleToStringInternal(scaleFactor, measure);
    }

    public Expression rescaleToExpression(Expression scaleFactor, Measure measure) {
        if (measure.value != null && scaleFactor instanceof Literal) {
            Double scale = (Double)scaleFactor.evaluate(null, Double.class);
            return Measure.ff.literal((Object)this.rescaleToStringInternal(scale, measure));
        }
        return Measure.ff.function("rescaleToPixels", new Expression[]{measure.expression, Measure.ff.literal(measure.uom), scaleFactor, Measure.ff.literal((Object)this)});
    }
}

