/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.boon.json.implementation;

import io.advantageous.boon.core.TypeType;
import io.advantageous.boon.core.Value;
import io.advantageous.boon.core.reflection.fields.FieldAccessMode;
import io.advantageous.boon.core.reflection.fields.FieldsAccessor;
import io.advantageous.boon.core.value.CharSequenceValue;
import io.advantageous.boon.core.value.LazyValueMap;
import io.advantageous.boon.core.value.MapItemValue;
import io.advantageous.boon.core.value.NumberValue;
import io.advantageous.boon.core.value.ValueContainer;
import io.advantageous.boon.core.value.ValueList;
import io.advantageous.boon.core.value.ValueMapImpl;
import io.advantageous.boon.json.JsonException;
import io.advantageous.boon.json.JsonParserEvents;
import io.advantageous.boon.json.implementation.JsonFastParser;
import io.advantageous.boon.primitive.CharScanner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class JsonParserLax
extends JsonFastParser {
    private static ValueContainer EMPTY_LIST = new ValueContainer(Collections.emptyList());
    private final JsonParserEvents events;
    Object root;

    public JsonParserLax() {
        this(FieldAccessMode.FIELD);
    }

    public JsonParserLax(FieldAccessMode mode) {
        this(mode, true);
    }

    public JsonParserLax(FieldAccessMode mode, boolean useAnnotations) {
        this(FieldAccessMode.create((FieldAccessMode)mode, (boolean)useAnnotations));
    }

    public JsonParserLax(FieldsAccessor fieldsAccessor) {
        this(false);
    }

    public JsonParserLax(boolean useValues) {
        this(useValues, false);
    }

    public JsonParserLax(boolean useValues, boolean chop) {
        this(useValues, chop, !chop);
    }

    public JsonParserLax(boolean useValues, boolean chop, boolean lazyChop) {
        this(useValues, chop, lazyChop, true);
    }

    public JsonParserLax(boolean useValues, boolean chop, boolean lazyChop, boolean defaultCheckDates) {
        this(useValues, chop, lazyChop, defaultCheckDates, null);
    }

    public JsonParserLax(boolean useValues, boolean chop, boolean lazyChop, boolean defaultCheckDates, JsonParserEvents events) {
        super(useValues, chop, lazyChop, defaultCheckDates);
        this.events = events;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Value decodeJsonObjectLax(boolean isRoot) {
        ValueMapImpl map;
        if (this.__currentChar == '{') {
            this.nextChar();
        }
        Object object = map = this.useValues ? new ValueMapImpl() : new LazyValueMap(this.lazyChop);
        if (this.events != null) {
            if (isRoot) {
                this.root = map;
            }
            if (!this.events.objectStart(this.__index)) {
                this.stop();
            }
        }
        ValueContainer value = new ValueContainer((Map)map);
        this.skipWhiteSpaceIfNeeded();
        int startIndexOfKey = this.__index;
        block8: while (this.__index < this.charArray.length) {
            this.skipWhiteSpaceIfNeeded();
            switch (this.__currentChar) {
                case '/': {
                    this.handleComment();
                    startIndexOfKey = this.__index;
                    break;
                }
                case '#': {
                    this.handleBashComment();
                    startIndexOfKey = this.__index;
                    break;
                }
                case ':': {
                    char startChar = this.charArray[startIndexOfKey];
                    if (startChar == ',') {
                        ++startIndexOfKey;
                    }
                    Value key = this.extractLaxString(startIndexOfKey, this.__index - 1, false, false);
                    if (this.events != null && !this.events.objectFieldName(this.__index, (Map<String, Object>)map, (CharSequence)((CharSequenceValue)key))) {
                        this.stop();
                    }
                    ++this.__index;
                    Value item = this.decodeValueInternal();
                    if (this.events != null && !this.events.objectField(this.__index, (Map<String, Object>)map, (CharSequence)((CharSequenceValue)key), item)) {
                        this.stop();
                    }
                    this.skipWhiteSpaceIfNeeded();
                    MapItemValue miv = new MapItemValue(key, item);
                    map.add(miv);
                    startIndexOfKey = this.__index++;
                    if (this.__currentChar != '}') break;
                    break block8;
                }
                case '\'': {
                    Value key = this.decodeStringSingle();
                    if (this.events != null && !this.events.objectFieldName(this.__index, (Map<String, Object>)map, (CharSequence)((CharSequenceValue)key))) {
                        this.stop();
                    }
                    this.skipWhiteSpaceIfNeeded();
                    if (this.__currentChar != ':') {
                        this.complain("expecting current character to be ':' but got " + this.charDescription(this.__currentChar) + "\n");
                    }
                    ++this.__index;
                    Value item = this.decodeValueInternal();
                    if (this.events != null && !this.events.objectField(this.__index, (Map<String, Object>)map, (CharSequence)((CharSequenceValue)key), item)) {
                        this.stop();
                    }
                    this.skipWhiteSpaceIfNeeded();
                    MapItemValue miv = new MapItemValue(key, item);
                    map.add(miv);
                    startIndexOfKey = this.__index++;
                    if (this.__currentChar != '}') break;
                    break block8;
                }
                case '\"': {
                    Value key = this.decodeStringDouble();
                    if (this.events != null) {
                        this.events.objectFieldName(this.__index, (Map<String, Object>)map, (CharSequence)((CharSequenceValue)key));
                    }
                    this.skipWhiteSpaceIfNeeded();
                    if (this.__currentChar != ':') {
                        this.complain("expecting current character to be ':' but got " + this.charDescription(this.__currentChar) + "\n");
                    }
                    ++this.__index;
                    Value item = this.decodeValueInternal();
                    if (this.events != null && !this.events.objectField(this.__index, (Map<String, Object>)map, (CharSequence)((CharSequenceValue)key), item)) {
                        this.stop();
                    }
                    this.skipWhiteSpaceIfNeeded();
                    MapItemValue miv = new MapItemValue(key, item);
                    map.add(miv);
                    startIndexOfKey = this.__index++;
                    if (this.__currentChar != '}') break;
                    break block8;
                }
                case '}': {
                    ++this.__index;
                    break block8;
                }
            }
            ++this.__index;
        }
        if (this.events != null && !this.events.objectEnd(this.__index, (Map<String, Object>)map)) {
            this.stop();
        }
        return value;
    }

    private Value extractLaxString(int startIndexOfKey, int end, boolean encoded, boolean checkDate) {
        int endIndex;
        block8: while (startIndexOfKey < this.__index && startIndexOfKey < this.charArray.length) {
            char startChar = this.charArray[startIndexOfKey];
            switch (startChar) {
                case '\t': 
                case '\n': 
                case ' ': {
                    break;
                }
                default: {
                    break block8;
                }
            }
            ++startIndexOfKey;
        }
        int n = endIndex = end >= this.charArray.length ? this.charArray.length - 1 : end;
        block9: while (endIndex >= startIndexOfKey + 1 && endIndex >= 0) {
            char endChar = this.charArray[endIndex];
            switch (endChar) {
                case '\t': 
                case '\n': 
                case ' ': 
                case '}': {
                    break;
                }
                case ',': 
                case ';': {
                    break;
                }
                case ']': {
                    break;
                }
                default: {
                    break block9;
                }
            }
            --endIndex;
        }
        CharSequenceValue value = new CharSequenceValue(this.chop, TypeType.STRING, startIndexOfKey, endIndex + 1, this.charArray, encoded, checkDate);
        if (this.events != null && !this.events.string(startIndexOfKey, endIndex + 1, (CharSequence)value)) {
            this.stop();
        }
        return value;
    }

    @Override
    public Object parse(char[] chars) {
        this.lastIndex = chars.length - 1;
        try {
            this.__index = 0;
            this.charArray = chars;
            Value value = this.decodeValueInternal(true);
            if (value.isContainer()) {
                return value.toValue();
            }
            return value;
        }
        catch (StopException stop) {
            return this.root;
        }
    }

    protected final Value decodeValueInternal() {
        return this.decodeValueInternal(false);
    }

    protected final Value decodeValueInternal(boolean isRoot) {
        Value value = null;
        while (this.__index < this.charArray.length) {
            this.skipWhiteSpaceIfNeeded();
            switch (this.__currentChar) {
                case '\n': {
                    break;
                }
                case '\r': {
                    break;
                }
                case ' ': {
                    break;
                }
                case '\t': {
                    break;
                }
                case '\b': {
                    break;
                }
                case '\f': {
                    break;
                }
                case '/': {
                    this.handleComment();
                    break;
                }
                case '#': {
                    this.handleBashComment();
                    break;
                }
                case '\"': {
                    value = this.decodeStringDouble();
                    break;
                }
                case '\'': {
                    value = this.decodeStringSingle();
                    break;
                }
                case 't': {
                    if (this.isTrue()) {
                        return this.decodeTrueWithEvents() ? ValueContainer.TRUE : ValueContainer.FALSE;
                    }
                    value = this.decodeStringLax();
                    break;
                }
                case 'f': {
                    if (this.isFalse()) {
                        return !this.decodeFalseWithEvents() ? ValueContainer.FALSE : ValueContainer.TRUE;
                    }
                    value = this.decodeStringLax();
                    break;
                }
                case 'n': {
                    if (this.isNull()) {
                        return this.decodeNullWithEvents() == null ? ValueContainer.NULL : ValueContainer.NULL;
                    }
                    value = this.decodeStringLax();
                    break;
                }
                case '[': {
                    value = this.decodeJsonArrayLax(isRoot);
                    break;
                }
                case '{': {
                    value = this.decodeJsonObjectLax(isRoot);
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return this.decodeNumberLax(false);
                }
                case '-': {
                    return this.decodeNumberLax(true);
                }
                default: {
                    value = this.decodeStringLax();
                }
            }
            if (value != null) {
                return value;
            }
            ++this.__index;
        }
        return null;
    }

    private void handleBashComment() {
        while (this.__index < this.charArray.length) {
            this.__currentChar = this.charArray[this.__index];
            if (this.__currentChar == '\n') {
                ++this.__index;
                return;
            }
            ++this.__index;
        }
    }

    private void handleComment() {
        if (this.hasMore()) {
            ++this.__index;
            this.__currentChar = this.charArray[this.__index];
            switch (this.__currentChar) {
                case '*': {
                    while (this.__index < this.charArray.length) {
                        this.__currentChar = this.charArray[this.__index];
                        if (this.__currentChar == '*') {
                            if (this.hasMore()) {
                                ++this.__index;
                                this.__currentChar = this.charArray[this.__index];
                                if (this.__currentChar == '/' && this.hasMore()) {
                                    ++this.__index;
                                    return;
                                }
                            } else {
                                this.complain("missing close of comment");
                            }
                        }
                        ++this.__index;
                    }
                }
                case '/': {
                    while (this.__index < this.charArray.length) {
                        this.__currentChar = this.charArray[this.__index];
                        if (this.__currentChar == '\n') {
                            if (this.hasMore()) {
                                ++this.__index;
                                return;
                            }
                            return;
                        }
                        ++this.__index;
                    }
                    break;
                }
            }
        }
    }

    protected final Value decodeNumberLax(boolean minus) {
        char currentChar;
        char[] array = this.charArray;
        int startIndex = this.__index;
        int index = this.__index;
        boolean doubleFloat = false;
        if (minus && index + 1 < array.length) {
            ++index;
        }
        do {
            if (CharScanner.isNumberDigit((int)(currentChar = array[index]))) continue;
            if (currentChar <= ' ' || CharScanner.isDelimiter((int)currentChar)) break;
            if (!CharScanner.isDecimalChar((int)currentChar)) continue;
            doubleFloat = true;
        } while (++index < array.length);
        this.__index = index;
        this.__currentChar = currentChar;
        TypeType type = doubleFloat ? TypeType.DOUBLE : TypeType.INT;
        NumberValue value = new NumberValue(this.chop, type, startIndex, this.__index, this.charArray);
        if (this.events != null && !this.events.number(startIndex, this.__index, (Number)value)) {
            this.stop();
        }
        return value;
    }

    private boolean isNull() {
        return this.__index + NULL.length <= this.charArray.length && this.charArray[this.__index] == 'n' && this.charArray[this.__index + 1] == 'u' && this.charArray[this.__index + 2] == 'l' && this.charArray[this.__index + 3] == 'l';
    }

    private boolean isTrue() {
        return this.__index + TRUE.length <= this.charArray.length && this.charArray[this.__index] == 't' && this.charArray[this.__index + 1] == 'r' && this.charArray[this.__index + 2] == 'u' && this.charArray[this.__index + 3] == 'e';
    }

    private boolean isFalse() {
        return this.__index + FALSE.length <= this.charArray.length && this.charArray[this.__index] == 'f' && this.charArray[this.__index + 1] == 'a' && this.charArray[this.__index + 2] == 'l' && this.charArray[this.__index + 3] == 's' && this.charArray[this.__index + 4] == 'e';
    }

    private Value decodeStringLax() {
        char currentChar;
        int index;
        int startIndex = this.__index;
        boolean encoded = false;
        char[] charArray = this.charArray;
        for (index = this.__index; index < charArray.length && !CharScanner.isDelimiter((int)(currentChar = charArray[index])) && currentChar != '\\'; ++index) {
        }
        Value value = this.extractLaxString(startIndex, index, encoded, this.checkDates);
        this.__index = index;
        return value;
    }

    private Value decodeStringDouble() {
        this.__currentChar = this.charArray[this.__index];
        if (this.__index < this.charArray.length && this.__currentChar == '\"') {
            ++this.__index;
        }
        int startIndex = this.__index;
        boolean escape = false;
        boolean encoded = false;
        block4: while (this.__index < this.charArray.length) {
            this.__currentChar = this.charArray[this.__index];
            switch (this.__currentChar) {
                case '\"': {
                    if (!escape) break block4;
                    escape = false;
                    break;
                }
                case '\\': {
                    escape = !escape;
                    encoded = true;
                    break;
                }
                default: {
                    escape = false;
                }
            }
            ++this.__index;
        }
        CharSequenceValue value = new CharSequenceValue(this.chop, TypeType.STRING, startIndex, this.__index, this.charArray, encoded, this.checkDates);
        if (this.__index < this.charArray.length) {
            ++this.__index;
        }
        if (this.events != null && !this.events.string(startIndex, this.__index, (CharSequence)value)) {
            this.stop();
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Value decodeStringSingle() {
        this.__currentChar = this.charArray[this.__index];
        if (this.__index < this.charArray.length && this.__currentChar == '\'') {
            ++this.__index;
        }
        int startIndex = this.__index;
        boolean escape = false;
        boolean encoded = false;
        int minusCount = 0;
        int colonCount = 0;
        block6: while (this.__index < this.charArray.length) {
            block10: {
                this.__currentChar = this.charArray[this.__index];
                switch (this.__currentChar) {
                    case '\'': {
                        if (!escape) break block6;
                        escape = false;
                        break block10;
                    }
                    case '\\': {
                        encoded = true;
                        escape = true;
                        break block10;
                    }
                    case '-': {
                        ++minusCount;
                        break;
                    }
                    case ':': {
                        ++colonCount;
                    }
                }
                escape = false;
            }
            ++this.__index;
        }
        boolean checkDates = this.checkDates && !encoded && minusCount >= 2 && colonCount >= 2;
        CharSequenceValue value = new CharSequenceValue(this.chop, TypeType.STRING, startIndex, this.__index, this.charArray, encoded, checkDates);
        if (this.__index < this.charArray.length) {
            ++this.__index;
        }
        if (this.events != null && !this.events.string(startIndex, this.__index, (CharSequence)value)) {
            this.stop();
        }
        return value;
    }

    private Value decodeJsonArrayLax(boolean isRoot) {
        if (this.events != null && !this.events.arrayStart(this.__index)) {
            this.stop();
        }
        if (this.__currentChar == '[') {
            ++this.__index;
        }
        this.skipWhiteSpaceIfNeeded();
        if (this.__currentChar == ']') {
            ++this.__index;
            return EMPTY_LIST;
        }
        ValueList list = this.useValues ? new ArrayList() : new ValueList(this.lazyChop);
        if (this.events != null && isRoot) {
            this.root = list;
        }
        ValueContainer value = new ValueContainer((List)list);
        do {
            this.skipWhiteSpaceIfNeeded();
            Value arrayItem = this.decodeValueInternal();
            list.add(arrayItem);
            if (this.events != null && !this.events.arrayItem(this.__index, (List<Object>)list, arrayItem)) {
                this.stop();
            }
            this.skipWhiteSpaceIfNeeded();
            char c = this.__currentChar;
            if (c == ',') {
                ++this.__index;
                continue;
            }
            if (c == ']') {
                ++this.__index;
                break;
            }
            String charString = this.charDescription(c);
            this.complain(String.format("expecting a ',' or a ']',  but got \nthe current character of  %s  on array index of %s \n", charString, list.size()));
        } while (this.hasMore());
        if (this.events != null && !this.events.arrayEnd(this.__index, (List<Object>)list)) {
            this.stop();
        }
        return value;
    }

    private void stop() {
        throw new StopException("STOPPED BY EVENT HANDLER at index " + this.__index);
    }

    protected final boolean decodeTrueWithEvents() {
        if (this.__index + TRUE.length <= this.charArray.length && this.charArray[this.__index] == 't' && this.charArray[++this.__index] == 'r' && this.charArray[++this.__index] == 'u' && this.charArray[++this.__index] == 'e') {
            if (this.events != null && !this.events.bool(this.__index, true)) {
                this.stop();
            }
            ++this.__index;
            return true;
        }
        throw new JsonException(this.exceptionDetails("true not parsed properly"));
    }

    protected final boolean decodeFalseWithEvents() {
        if (this.__index + FALSE.length <= this.charArray.length && this.charArray[this.__index] == 'f' && this.charArray[++this.__index] == 'a' && this.charArray[++this.__index] == 'l' && this.charArray[++this.__index] == 's' && this.charArray[++this.__index] == 'e') {
            if (this.events != null && !this.events.bool(this.__index, false)) {
                this.stop();
            }
            ++this.__index;
            return false;
        }
        throw new JsonException(this.exceptionDetails("false not parsed properly"));
    }

    protected final Object decodeNullWithEvents() {
        if (this.__index + NULL.length <= this.charArray.length && this.charArray[this.__index] == 'n' && this.charArray[++this.__index] == 'u' && this.charArray[++this.__index] == 'l' && this.charArray[++this.__index] == 'l') {
            ++this.__index;
            if (this.events != null && !this.events.nullValue(this.__index)) {
                this.stop();
            }
            return null;
        }
        throw new JsonException(this.exceptionDetails("null not parse properly"));
    }

    public static class StopException
    extends JsonException {
        public StopException(String message) {
            super(message);
        }
    }
}

