/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.boon.json.serializers.impl;

import io.advantageous.boon.core.Dates;
import io.advantageous.boon.core.reflection.FastStringUtils;
import io.advantageous.boon.json.serializers.DateSerializer;
import io.advantageous.boon.json.serializers.JsonSerializerInternal;
import io.advantageous.boon.primitive.CharBuf;
import io.advantageous.boon.primitive.SimpleLRUCache;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class JsonDateSerializer
implements DateSerializer {
    private final Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    private final SimpleLRUCache<Object, String> dateCache = new SimpleLRUCache(200);

    @Override
    public final void serializeDate(JsonSerializerInternal jsonSerializer, Date date, CharBuf builder) {
        String string = (String)this.dateCache.get((Object)date);
        if (string == null) {
            CharBuf buf = CharBuf.create((int)Dates.JSON_TIME_LENGTH);
            Dates.jsonDateChars((Calendar)this.calendar, (Date)date, (CharBuf)buf);
            string = buf.toString();
            this.dateCache.put((Object)date, (Object)string);
        }
        builder.addChars(FastStringUtils.toCharArray((String)string));
    }
}

