/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.boon.json.serializers.impl;

import io.advantageous.boon.core.reflection.FastStringUtils;
import io.advantageous.boon.json.serializers.JsonSerializerInternal;
import io.advantageous.boon.json.serializers.MapSerializer;
import io.advantageous.boon.primitive.CharBuf;
import java.util.Map;
import java.util.Set;

public class MapSerializerImpl
implements MapSerializer {
    private static final char[] EMPTY_MAP_CHARS = new char[]{'{', '}'};
    private final boolean includeNulls;

    public MapSerializerImpl(boolean includeNulls) {
        this.includeNulls = includeNulls;
    }

    private void serializeFieldName(String name, CharBuf builder) {
        builder.addJsonFieldName(FastStringUtils.toCharArray((String)name));
    }

    @Override
    public final void serializeMap(JsonSerializerInternal serializer, Map<Object, Object> map, CharBuf builder) {
        if (map.size() == 0) {
            builder.addChars(EMPTY_MAP_CHARS);
            return;
        }
        builder.addChar('{');
        Set<Map.Entry<Object, Object>> entrySet = map.entrySet();
        int index = 0;
        if (!this.includeNulls) {
            for (Map.Entry<Object, Object> entry : entrySet) {
                if (entry.getValue() == null) continue;
                this.serializeFieldName(entry.getKey().toString(), builder);
                serializer.serializeObject(entry.getValue(), builder);
                builder.addChar(',');
                ++index;
            }
        } else {
            for (Map.Entry<Object, Object> entry : entrySet) {
                this.serializeFieldName(entry.getKey().toString(), builder);
                serializer.serializeObject(entry.getValue(), builder);
                builder.addChar(',');
                ++index;
            }
        }
        if (index > 0) {
            builder.removeLastChar();
        }
        builder.addChar('}');
    }
}

