/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.boon.json.serializers.impl;

import io.advantageous.boon.core.TypeType;
import io.advantageous.boon.core.reflection.ClassMeta;
import io.advantageous.boon.json.serializers.CustomObjectSerializer;
import io.advantageous.boon.json.serializers.JsonSerializerInternal;
import io.advantageous.boon.primitive.CharBuf;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class SerializeUtils {
    public static void handleInstance(JsonSerializerInternal jsonSerializer, Object obj, CharBuf builder, Map<Class, CustomObjectSerializer> overrideMap, Set<Class> noHandle, boolean typeInfo, TypeType type) {
        Class cls;
        if (overrideMap != null && (cls = ClassMeta.cls((Object)obj)) != null && !cls.isPrimitive() && !noHandle.contains(cls)) {
            Class<?>[] interfaces;
            CustomObjectSerializer customObjectSerializer = overrideMap.get(cls);
            if (customObjectSerializer != null) {
                customObjectSerializer.serializeObject(jsonSerializer, obj, builder);
                return;
            }
            customObjectSerializer = overrideMap.get(cls.getSuperclass());
            if (customObjectSerializer != null) {
                overrideMap.put(cls.getSuperclass(), customObjectSerializer);
                customObjectSerializer.serializeObject(jsonSerializer, obj, builder);
                return;
            }
            for (Class<?> interf : interfaces = cls.getInterfaces()) {
                customObjectSerializer = overrideMap.get(interf);
                if (customObjectSerializer == null) continue;
                overrideMap.put(interf, customObjectSerializer);
                customObjectSerializer.serializeObject(jsonSerializer, obj, builder);
                return;
            }
            noHandle.add(cls);
        }
        switch (type) {
            case MAP: {
                jsonSerializer.serializeMap((Map)obj, builder);
                return;
            }
            case COLLECTION: 
            case LIST: 
            case SET: {
                jsonSerializer.serializeCollection((Collection)obj, builder);
                return;
            }
            case INSTANCE: {
                jsonSerializer.serializeInstance(obj, builder, typeInfo);
                return;
            }
            case INTERFACE: 
            case ABSTRACT: {
                jsonSerializer.serializeSubtypeInstance(obj, builder);
                return;
            }
        }
        jsonSerializer.serializeUnknown(obj, builder);
    }
}

