/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.json;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.OMNamespaceImpl;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.json.JSONDataSource;
import org.apache.axis2.transport.http.util.URIEncoderDecoder;

public class JSONOMBuilder
implements Builder {
    public OMElement processDocument(InputStream inputStream, String contentType, MessageContext messageContext) throws AxisFault {
        String localName = "";
        String prefix = "";
        OMNamespaceImpl ns = new OMNamespaceImpl("", "");
        OMFactory factory = OMAbstractFactory.getOMFactory();
        if (inputStream == null) {
            String requestURL;
            EndpointReference endpointReference = messageContext.getTo();
            if (endpointReference == null) {
                throw new AxisFault("Cannot create DocumentElement without destination EPR");
            }
            try {
                requestURL = URIEncoderDecoder.decode((String)endpointReference.getAddress());
            }
            catch (UnsupportedEncodingException e) {
                throw AxisFault.makeFault((Throwable)e);
            }
            int index = requestURL.indexOf("=");
            if (index > 0) {
                String jsonString = requestURL.substring(index + 1);
                inputStream = new ByteArrayInputStream(jsonString.getBytes());
            } else {
                throw new AxisFault("No JSON message received through HTTP GET or POST");
            }
        }
        try {
            char temp = (char)inputStream.read();
            while (temp != ':') {
                if (temp != ' ' && temp != '{') {
                    localName = localName + temp;
                }
                temp = (char)inputStream.read();
            }
            if (localName.charAt(0) == '\"') {
                if (localName.charAt(localName.length() - 1) == '\"') {
                    localName = localName.substring(1, localName.length() - 1);
                } else {
                    prefix = localName.substring(1, localName.length()) + ":";
                    localName = "";
                    temp = (char)inputStream.read();
                    while (temp != ':') {
                        if (temp != ' ') {
                            localName = localName + temp;
                        }
                        temp = (char)inputStream.read();
                    }
                    localName = localName.substring(0, localName.length() - 1);
                }
            }
        }
        catch (IOException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        JSONDataSource jsonDataSource = this.getDataSource(inputStream, prefix, localName);
        return new OMSourcedElementImpl(localName, (OMNamespace)ns, factory, (OMDataSource)jsonDataSource);
    }

    protected JSONDataSource getDataSource(InputStream jsonInputStream, String prefix, String localName) {
        return new JSONDataSource(jsonInputStream, "\"" + prefix + localName + "\"");
    }
}

