/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Optional;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.help.HelpBrowser;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class HelpAction
extends JosmAction {
    public HelpAction() {
        this(true);
    }

    private HelpAction(boolean shortcut) {
        super(I18n.tr("Help", new Object[0]), "help", null, shortcut ? Shortcut.registerShortcut("system:help", I18n.tr("Help", new Object[0]), 112, 5003) : null, true);
        this.setEnabled(!Main.isOffline(OnlineResource.JOSM_WEBSITE));
    }

    public static HelpAction createWithoutShortcut() {
        return new HelpAction(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == null) {
            String topic;
            if (e.getSource() instanceof Component) {
                Component c = SwingUtilities.getRoot((Component)e.getSource());
                Point mouse = c.getMousePosition();
                if (mouse != null) {
                    c = SwingUtilities.getDeepestComponentAt(c, mouse.x, mouse.y);
                    topic = HelpUtil.getContextSpecificHelpTopic(c);
                } else {
                    topic = null;
                }
            } else {
                Point mouse = Main.parent.getMousePosition();
                topic = HelpUtil.getContextSpecificHelpTopic(SwingUtilities.getDeepestComponentAt(Main.parent, mouse.x, mouse.y));
            }
            HelpBrowser.setUrlForHelpTopic(Optional.ofNullable(topic).orElse("/"));
        } else {
            HelpBrowser.setUrlForHelpTopic("/");
        }
    }
}

