/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.date.DateUtils;

public class ChangesetCellRenderer
extends JLabel
implements ListCellRenderer<Changeset> {
    private final ImageIcon icon = ImageProvider.get("data", "changeset");

    public ChangesetCellRenderer() {
        this.setOpaque(true);
    }

    protected String buildToolTipText(Changeset cs) {
        String comment;
        StringBuilder sb = new StringBuilder(64);
        sb.append("<html><strong>").append(I18n.tr("Changeset id:", new Object[0])).append("</strong>").append(cs.getId()).append("<br>");
        Date createdDate = cs.getCreatedAt();
        if (createdDate != null) {
            sb.append("<strong>").append(I18n.tr("Created at:", new Object[0])).append("</strong>").append(DateUtils.formatDateTime(createdDate, 3, 3)).append("<br>");
        }
        if (!(comment = cs.getComment()).isEmpty()) {
            sb.append("<strong>").append(I18n.tr("Changeset comment:", new Object[0])).append("</strong>").append(Utils.escapeReservedCharactersHTML(comment)).append("<br>");
        }
        return sb.toString();
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends Changeset> list, Changeset cs, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            this.setForeground(UIManager.getColor("List.selectionForeground"));
            this.setBackground(UIManager.getColor("List.selectionBackground"));
        } else {
            this.setForeground(UIManager.getColor("List.foreground"));
            this.setBackground(UIManager.getColor("List.background"));
        }
        if (cs != null) {
            this.setIcon(this.icon);
            StringBuilder sb = new StringBuilder();
            String comment = cs.getComment();
            if (!comment.isEmpty()) {
                sb.append(cs.getId()).append(" - ").append(comment);
            } else if (cs.get("name") != null) {
                sb.append(cs.getId()).append(" - ").append(cs.get("name"));
            } else {
                sb.append(I18n.tr("Changeset {0}", cs.getId()));
            }
            this.setText(sb.toString());
            this.setToolTipText(this.buildToolTipText(cs));
        } else {
            this.setText(I18n.tr("No open changeset", new Object[0]));
        }
        return this;
    }
}

