/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.client;

import java.net.URL;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import ru.infor.client.ExtEntity2Entity_Converter;
import ru.infor.client.json.JSONConnection;
import ru.infor.client.soap.SOAPConnection;
import ru.infor.common.SysProperties;
import ru.infor.ws.business.ApplicationException;

public abstract class ServicesConnection {
    public static final long SERVICES_DEFAULT_TIMEOUT = 180000L;
    protected static final QName GET_VERSION_QNAME = new QName("http://ws.infor.ru/business/core/metainf/xsd", "getServicesVersion");
    protected static final QName GET_JDBC_PROPS_QNAME = new QName("http://ws.infor.ru/business/core/metainf/xsd", "getJDBCProperties");
    protected static final QName LOCATE_QNAME = new QName("http://ws.infor.ru/business/core/meta/locator/xsd/", "locate");
    private String appName;
    private URL baseURL;

    protected ServicesConnection(String appName) {
        this.appName = appName == null ? "unknown" : appName.toLowerCase();
        try {
            this.getURL();
        }
        catch (Exception exception) {}
    }

    protected ServicesConnection(URL url) {
        this.appName = "unknown";
        this.baseURL = url;
    }

    public String getVersion() {
        Object[] res = this.invoke(new QName("http://ws.infor.ru/business/core/metainf/", "MetainfWS"), GET_VERSION_QNAME, new Object[0], String.class, 180000L);
        return res[0].toString();
    }

    public String getJDBCProperties() {
        Object[] res = this.invoke(new QName("http://ws.infor.ru/business/core/metainf/", "MetainfWS"), GET_JDBC_PROPS_QNAME, new Object[0], String.class, 180000L);
        if (res == null || res.length == 0) {
            return null;
        }
        return res[0] == null ? null : res[0].toString();
    }

    public Object[] invoke(QName serviceName, QName operationName, Object[] args, Class<?> resultType) {
        return this.invoke(serviceName, operationName, args, resultType, 180000L);
    }

    @Deprecated
    public void invokeVoid(QName serviceName, QName operationName, Object[] args) {
        this.invokeVoid(serviceName, operationName, args, null);
    }

    public abstract Object[] invoke(QName var1, QName var2, Object[] var3, Class<?> var4, long var5);

    public abstract OMElement invokeWithXMLResult(QName var1, QName var2, Object[] var3, long var4) throws AxisFault;

    public abstract void invokeVoid(QName var1, QName var2, Object[] var3, Long var4);

    protected URL getURL() throws Exception {
        if (this.baseURL != null) {
            return this.baseURL;
        }
        StringBuilder propName = new StringBuilder();
        propName.append(this.appName).append(".").append(this.getProtocol()).append(".services.url");
        String prop = propName.toString().toLowerCase();
        String url = SysProperties.getProperty(prop, null);
        if (url == null) {
            propName = new StringBuilder();
            propName.append(this.getProtocol()).append(".services.url");
            url = SysProperties.getProperty(propName.toString(), null);
            if (url == null) {
                throw new ApplicationException("please define prop: " + prop);
            }
        }
        this.baseURL = new URL(url);
        return this.baseURL;
    }

    protected abstract String getProtocol();

    public static final ServicesConnection getConnection(String appName, String protocol) {
        if ("json".equalsIgnoreCase(protocol)) {
            return new JSONConnection(appName);
        }
        if ("soap".equalsIgnoreCase(protocol)) {
            return new SOAPConnection(appName);
        }
        return null;
    }

    public static final ServicesConnection getConnection(String appName) {
        String protocol = SysProperties.getProperty(String.valueOf(appName.toLowerCase()) + ".services.connection.protocol", "soap");
        return ServicesConnection.getConnection(appName, protocol);
    }

    public static Object[] convertToServicesObjects(Object[] args) {
        ArrayList<Object> res = new ArrayList<Object>();
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            res.add(ServicesConnection._convert(obj));
            ++n2;
        }
        return res.toArray();
    }

    private static Object _convert(Object obj) {
        if (obj == null) {
            return null;
        }
        return ExtEntity2Entity_Converter._convert(obj);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.appName == null ? 0 : this.appName.hashCode());
        result = 31 * result + (this.baseURL == null ? 0 : this.baseURL.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServicesConnection other = (ServicesConnection)obj;
        if (this.appName == null ? other.appName != null : !this.appName.equals(other.appName)) {
            return false;
        }
        return !(this.baseURL == null ? other.baseURL != null : !this.baseURL.equals(other.baseURL));
    }
}

