/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.client.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.log4j.Logger;
import ru.infor.client.ServicesConnection;
import ru.infor.client.json.JSONUtils;
import ru.infor.client.soap.SOAPException;
import ru.infor.common.FileUtils;
import ru.infor.common.SysProperties;

public class JSONConnection
extends ServicesConnection {
    private static Logger logger = Logger.getLogger(JSONConnection.class);
    static Proxy proxy;
    private Gson gsonReq;
    private Gson gsonResp;

    static {
        JSONConnection.getProxy();
    }

    public JSONConnection(String appName) {
        super(appName);
        this.init();
    }

    public JSONConnection(URL url) {
        super(url);
        this.init();
    }

    private void init() {
        this.gsonReq = JSONUtils.getGson_req();
        this.gsonResp = JSONUtils.getGson_resp();
    }

    private static Proxy getProxy() {
        if (proxy == null) {
            int port = 0;
            try {
                port = Integer.valueOf(SysProperties.getProperty("external.proxy.port", null));
            }
            catch (Exception exception) {
                return null;
            }
            String st = SysProperties.getProperty("external.proxy.name", null);
            if (st == null) {
                return null;
            }
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(st, port));
            final String user = SysProperties.getProperty("external.user.name", null);
            final String psw = SysProperties.getProperty("external.user.password", null);
            if (user != null && psw != null) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(user, psw.toCharArray());
                    }

                    @Override
                    protected URL getRequestingURL() {
                        return super.getRequestingURL();
                    }

                    @Override
                    protected Authenticator.RequestorType getRequestorType() {
                        return super.getRequestorType();
                    }
                });
            }
        }
        return proxy;
    }

    protected String getURLInt(QName serviceName, QName method) throws Exception {
        StringBuilder url = new StringBuilder(this.getURL().toString());
        if (!url.toString().endsWith("/")) {
            url.append("/");
        }
        url.append(serviceName.getLocalPart()).append("/");
        url.append(method.getLocalPart());
        logger.debug((Object)("url: " + url));
        return url.toString();
    }

    @Override
    public OMElement invokeWithXMLResult(QName serviceName, QName operationName, Object[] args, long timeout) throws AxisFault {
        throw new AxisFault("method invokeWithXMLResult is not supported in JSON connection");
    }

    @Override
    public Object[] invoke(QName serviceName, QName operationName, Object[] args, Class<?> resultType, long timeout) throws SOAPException {
        long time = System.currentTimeMillis();
        try {
            args = JSONConnection.convertToServicesObjects(args);
            logger.debug((Object)("convering takes " + (System.currentTimeMillis() - time) + "ms"));
            URL url = new URL(this.getURLInt(serviceName, operationName));
            time = System.currentTimeMillis();
            String req = this.gsonReq.toJson((Object)args);
            byte[] resp = this.send(url, req, timeout);
            if (resp == null || resp.length == 0 || resultType == null) {
                return null;
            }
            long deserTime = System.currentTimeMillis();
            Object result = this.gsonResp.fromJson(new String(resp, "UTF-8"), resultType);
            logger.debug((Object)("deserialization time: " + String.valueOf(System.currentTimeMillis() - deserTime)));
            Object[] objectArray = new Object[]{result};
            return objectArray;
        }
        catch (SOAPException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception af) {
            logger.error((Object)af.getMessage(), (Throwable)af);
            throw new SOAPException(af.getMessage(), null, af.getCause());
        }
        finally {
            time = System.currentTimeMillis() - time;
            logger.debug((Object)(String.valueOf(operationName.toString()) + " invocation time: " + String.valueOf(time) + "ms"));
        }
    }

    private byte[] send(URL url, String req, long timeout) throws IOException, ProtocolException, UnsupportedEncodingException {
        HttpURLConnection c = (HttpURLConnection)url.openConnection();
        c.setConnectTimeout((int)timeout);
        c.setReadTimeout((int)timeout);
        c.setRequestMethod("POST");
        c.setDoInput(true);
        c.setDoOutput(true);
        c.connect();
        OutputStream out = c.getOutputStream();
        out.write(req.getBytes("UTF-8"));
        out.flush();
        out.close();
        InputStream in = c.getResponseCode() == 200 ? c.getInputStream() : c.getErrorStream();
        byte[] resp = new byte[]{};
        if (in != null) {
            resp = FileUtils.readFileToBytes(in);
        }
        if (c.getResponseCode() != 200) {
            SOAPException ex = null;
            if (c.getResponseCode() == 500) {
                try {
                    ex = (SOAPException)new GsonBuilder().create().fromJson(new String(resp, "UTF-8"), SOAPException.class);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            } else {
                ex = new SOAPException(new String(resp, "UTF-8"), null, null);
            }
            if (ex != null) {
                throw ex;
            }
        }
        return resp;
    }

    @Override
    public void invokeVoid(QName serviceName, QName operationName, Object[] args, Long timeout) {
        this.invoke(serviceName, operationName, args, null, timeout == null ? 180000L : timeout);
    }

    @Override
    protected String getProtocol() {
        return "json";
    }
}

