/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.client.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.apache.log4j.Logger;
import ru.infor.client.json.ExclusionStrategy;
import ru.infor.client.soap.ClientSideObjectSupplier;
import ru.infor.ws.objects.core.entities.DisablingUsers;
import ru.infor.ws.objects.core.entities.RightsOwner2Disable;
import ru.infor.ws.objects.core.entities.User;

public class JSONUtils {
    private static final Logger logger = Logger.getLogger(JSONUtils.class);
    private static final String CLASSNAME_FIELD = "_$c$_";

    private static TypeAdapterFactory getDefaultTypeFactory() {
        return new TypeAdapterFactory(){

            public <T> TypeAdapter<T> create(final Gson gson, final TypeToken<T> arg1) {
                Class clazz = arg1.getRawType();
                String className = clazz.getName();
                if (!className.startsWith("ru.infor.ws.objects.")) {
                    return gson.getDelegateAdapter((TypeAdapterFactory)this, arg1);
                }
                final 1 factory = this;
                logger.debug(arg1);
                return new TypeAdapter<T>(){

                    public T read(JsonReader reader) throws IOException {
                        JsonElement elem = Streams.parse((JsonReader)reader);
                        Class<?> clazz = arg1.getRawType();
                        try {
                            JsonElement clsEl = elem.getAsJsonObject().get(JSONUtils.CLASSNAME_FIELD);
                            if (clsEl != null && clsEl.getAsString() != null) {
                                clazz = Class.forName(clsEl.getAsString());
                            }
                        }
                        catch (Exception e) {
                            logger.debug((Object)e.getMessage(), (Throwable)e);
                        }
                        return gson.getDelegateAdapter(factory, TypeToken.get((Class)clazz)).fromJsonTree(elem);
                    }

                    public void write(JsonWriter jsonWriter, T arg12) throws IOException {
                        if (arg12 == null) {
                            jsonWriter.nullValue();
                            return;
                        }
                        JsonElement elem = gson.getDelegateAdapter(factory, TypeToken.get(arg12.getClass())).toJsonTree(arg12);
                        elem.getAsJsonObject().addProperty(JSONUtils.CLASSNAME_FIELD, arg12.getClass().getName());
                        Streams.write((JsonElement)elem, (JsonWriter)jsonWriter);
                    }
                };
            }
        };
    }

    public static Gson getGson_req() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapterFactory(JSONUtils.getDefaultTypeFactory());
        return builder.create();
    }

    public static Gson getGson_resp() {
        GsonBuilder builder = new GsonBuilder().addDeserializationExclusionStrategy((com.google.gson.ExclusionStrategy)new ExclusionStrategy()).registerTypeAdapterFactory(new TypeAdapterFactory(){

            public <T> TypeAdapter<T> create(Gson arg0, TypeToken<T> arg1) {
                String extClassName;
                Class<?> clazz = arg1.getRawType();
                if (!clazz.isArray() && (extClassName = ClientSideObjectSupplier.getExtClassName(clazz)).contains(".ext.")) {
                    try {
                        clazz = Class.forName(extClassName);
                        arg1 = TypeToken.get(clazz);
                    }
                    catch (Exception exception) {}
                }
                return arg0.getDelegateAdapter((TypeAdapterFactory)this, arg1);
            }
        });
        builder.registerTypeAdapterFactory(JSONUtils.getDefaultTypeFactory());
        return builder.create();
    }

    public static void main(String[] args) throws Exception {
        RightsOwner2Disable obj = new RightsOwner2Disable();
        obj.setDisable(new DisablingUsers());
        obj.getDisable().setId(1234345L);
        obj.setOwner(new User());
        obj.getOwner().setId(44444L);
        obj.getOwner().setName("test");
        String json = JSONUtils.getGson_req().toJson((Object)new RightsOwner2Disable[]{obj});
        logger.info((Object)json);
        Object tmp = JSONUtils.getGson_resp().fromJson(json, RightsOwner2Disable[].class);
        logger.info(tmp);
    }
}

