/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.client.soap;

import java.io.File;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.databinding.utils.BeanUtil;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisError;
import org.apache.axis2.engine.ObjectSupplier;
import org.apache.axis2.rpc.client.RPCServiceClient;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.log4j.Logger;
import ru.infor.client.ServicesConnection;
import ru.infor.client.soap.ClientSideObjectSupplier;
import ru.infor.client.soap.SOAPException;
import ru.infor.common.FileUtils;
import ru.infor.common.SysProperties;

public class SOAPConnection
extends ServicesConnection {
    private static Logger logger = Logger.getLogger(SOAPConnection.class);
    private static final Object LOCK = new Object();
    private HttpTransportProperties.ProxyProperties proxyProperties = null;
    private Map<QName, Callable<AxisService>> servicesMap;
    private static MultiThreadedHttpConnectionManager manager = new MultiThreadedHttpConnectionManager();

    static {
        if (manager.getParams() == null) {
            manager.setParams(new HttpConnectionManagerParams());
        }
        manager.getParams().setMaxTotalConnections(50);
    }

    public SOAPConnection(String appName) {
        super(appName);
        this.init();
    }

    public SOAPConnection(URL url) {
        super(url);
        this.init();
    }

    private void init() {
        this.servicesMap = new HashMap<QName, Callable<AxisService>>();
        final HttpTransportProperties.ProxyProperties pp = this.initProxySetup();
        logger.debug((Object)("Proxy sessings were loaded: " + pp));
        if (pp != null) {
            logger.info((Object)("Proxy host: " + pp.getProxyHostName()));
            logger.info((Object)("Proxy port: " + pp.getProxyPort()));
            logger.info((Object)("Proxy user: " + pp.getUserName()));
            logger.info((Object)("Proxy psw: " + (pp.getPassWord() == null ? "NULL" : "...")));
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(pp.getUserName(), pp.getPassWord().toCharArray());
                }
            });
        }
    }

    private HttpTransportProperties.ProxyProperties initProxySetup() {
        HttpTransportProperties.ProxyProperties pp = new HttpTransportProperties.ProxyProperties();
        try {
            pp.setProxyPort(Integer.valueOf(SysProperties.getProperty("external.proxy.port", null)).intValue());
        }
        catch (Exception exception) {
            return null;
        }
        String st = SysProperties.getProperty("external.proxy.name", null);
        if (st == null) {
            return null;
        }
        pp.setProxyName(st);
        st = SysProperties.getProperty("external.user.name", null);
        if (st == null) {
            return null;
        }
        pp.setUserName(st);
        st = SysProperties.getProperty("external.user.password", null);
        if (st == null) {
            return null;
        }
        pp.setPassWord(st);
        this.proxyProperties = pp;
        return pp;
    }

    private HttpTransportProperties.ProxyProperties getProxySetup() {
        return this.proxyProperties;
    }

    private AxisService newServiceByWSDL(QName serviceName, String url) throws Exception {
        AxisService axisService;
        block15: {
            File wsdlFile = null;
            try {
                AxisService service;
                try {
                    URL wsdlURL = new URL(String.valueOf(url) + "?wsdl");
                    try (InputStream in = null;){
                        HttpTransportProperties.ProxyProperties pp = this.getProxySetup();
                        in = pp == null ? wsdlURL.openStream() : wsdlURL.openConnection(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(pp.getProxyHostName(), pp.getProxyPort()))).getInputStream();
                        wsdlFile = File.createTempFile(String.valueOf(System.currentTimeMillis()), ".wsdl");
                        FileUtils.copy(in, wsdlFile);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                if (wsdlFile == null) {
                    throw new AxisError("can't cache WSDL by URL: " + url);
                }
                logger.debug((Object)("WSDL cached successfully: " + url + " --> " + wsdlFile.getAbsolutePath()));
                axisService = service = AxisService.createClientSideAxisService((URL)wsdlFile.toURI().toURL(), (QName)serviceName, (String)(String.valueOf(serviceName.getLocalPart()) + "HttpSoap11Endpoint"), (Options)new Options());
                if (wsdlFile == null || !wsdlFile.isFile()) break block15;
            }
            catch (Throwable throwable) {
                if (wsdlFile != null && wsdlFile.isFile()) {
                    try {
                        wsdlFile.delete();
                        logger.debug((Object)(wsdlFile + " deleted"));
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            try {
                wsdlFile.delete();
                logger.debug((Object)(wsdlFile + " deleted"));
            }
            catch (Exception exception) {}
        }
        return axisService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AxisService getService(final QName serviceName, final String url) throws AxisFault {
        try {
            Callable<AxisService> service = null;
            Map<QName, Callable<AxisService>> map = this.servicesMap;
            synchronized (map) {
                service = this.servicesMap.get(serviceName);
                if (service == null) {
                    service = new Callable<AxisService>(){
                        final Object lock = new Object();
                        AxisService service;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public AxisService call() throws Exception {
                            Object object = this.lock;
                            synchronized (object) {
                                if (this.service == null) {
                                    this.service = SOAPConnection.this.newServiceByWSDL(serviceName, url);
                                }
                                return this.service;
                            }
                        }
                    };
                    this.servicesMap.put(serviceName, service);
                }
            }
            return service.call();
        }
        catch (AxisFault af) {
            throw af;
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    protected String getURLInt(QName serviceName) throws Exception {
        String url = this.getURL().toExternalForm();
        if (!url.endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        url = String.valueOf(url) + serviceName.getLocalPart();
        logger.debug((Object)("url: " + url));
        return url;
    }

    protected EndpointReference getReference(QName serviceName) throws Exception {
        EndpointReference ref = new EndpointReference(this.getURLInt(serviceName));
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OMElement invokeWithXMLResult(QName serviceName, QName operationName, Object[] args, long timeout) throws AxisFault {
        OMElement oMElement;
        RPCServiceClient client;
        block11: {
            client = null;
            try {
                client = this.getClient(serviceName);
                client.getOptions().setTimeOutInMilliSeconds(timeout);
                if (args == null) {
                    args = new Object[]{};
                }
                long time = System.currentTimeMillis();
                args = SOAPConnection.convertToServicesObjects(args);
                logger.debug((Object)("convering takes " + (System.currentTimeMillis() - time) + "ms"));
                time = System.currentTimeMillis();
                OMElement resultXML = null;
                AxisService axisService = client.getAxisService();
                synchronized (axisService) {
                    resultXML = client.invokeBlocking(operationName, args);
                }
                logger.debug((Object)("RPCServiceClient.invokeBlocking takes " + (System.currentTimeMillis() - time) + "ms"));
                oMElement = resultXML;
                if (client == null) break block11;
            }
            catch (Throwable throwable) {
                if (client != null) {
                    try {
                        client.cleanupTransport();
                    }
                    catch (Exception exception) {}
                }
                client = null;
                throw throwable;
            }
            try {
                client.cleanupTransport();
            }
            catch (Exception exception) {}
        }
        client = null;
        return oMElement;
    }

    private void configureServiceClient(RPCServiceClient client, EndpointReference reference) {
        client.getOptions().setProperty("__HTTP_PROTOCOL_VERSION__", (Object)"HTTP/1.0");
        client.getOptions().setProperty("__CHUNKED__", (Object)"false");
        client.getOptions().setProperty("PROXY", (Object)this.getProxySetup());
        client.getOptions().setCallTransportCleanup(true);
        client.getOptions().setProperty("REUSE_HTTP_CLIENT", (Object)Boolean.FALSE);
        client.getOptions().setProperty("MULTITHREAD_HTTP_CONNECTION_MANAGER", (Object)manager);
        client.getOptions().setTo(reference);
        logger.debug((Object)("Properties: " + client.getOptions().getProperties() + ", for service: " + client));
    }

    private RPCServiceClient getClient(QName serviceName) throws AxisFault {
        try {
            ConfigurationContext cc = ConfigurationContextFactory.createDefaultConfigurationContext();
            RPCServiceClient client = new RPCServiceClient(cc, this.getService(serviceName, this.getURLInt(serviceName)));
            this.configureServiceClient(client, this.getReference(serviceName));
            return client;
        }
        catch (AxisFault af) {
            throw af;
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] invoke(QName serviceName, QName operationName, Object[] args, Class<?> resultType, long timeout) {
        try {
            long time = System.currentTimeMillis();
            OMElement resultXML = this.invokeWithXMLResult(serviceName, operationName, args, timeout);
            long deserTime = System.currentTimeMillis();
            Object[] result = null;
            Object object = LOCK;
            synchronized (object) {
                result = BeanUtil.deserialize((OMElement)resultXML, (Object[])new Class[]{resultType}, (ObjectSupplier)new ClientSideObjectSupplier(resultType));
            }
            logger.debug((Object)("deserialization time: " + String.valueOf(System.currentTimeMillis() - deserTime)));
            time = System.currentTimeMillis() - time;
            logger.debug((Object)(String.valueOf(operationName.toString()) + " invocation time: " + String.valueOf(time) + "ms"));
            return result;
        }
        catch (AxisFault af) {
            logger.error((Object)af);
            throw new SOAPException(af.getMessage(), af.getFaultCode() != null ? af.getFaultCode().getLocalPart() : null, af.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeVoid(QName serviceName, QName operationName, Object[] args, Long timeout) {
        RPCServiceClient client = null;
        try {
            try {
                client = this.getClient(serviceName);
                client.getOptions().setTimeOutInMilliSeconds(timeout == null || timeout <= 0L ? 180000L : timeout);
                if (args == null) {
                    args = new Object[]{};
                }
                long time = System.currentTimeMillis();
                AxisService axisService = client.getAxisService();
                synchronized (axisService) {
                    client.invokeRobust(operationName, args);
                }
                time = System.currentTimeMillis() - time;
                logger.debug((Object)("invocation time: " + String.valueOf(time) + "ms"));
            }
            catch (AxisFault af) {
                logger.error((Object)af);
                throw new SOAPException(af.getMessage(), af.getFaultCode().getLocalPart(), af.getCause());
            }
        }
        catch (Throwable throwable) {
            if (client != null) {
                try {
                    client.cleanupTransport();
                }
                catch (Exception exception) {}
            }
            client = null;
            throw throwable;
        }
        if (client != null) {
            try {
                client.cleanupTransport();
            }
            catch (Exception exception) {}
        }
        client = null;
    }

    @Override
    protected String getProtocol() {
        return "soap";
    }
}

