/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.common;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Member;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.asm.ClassVisitor;
import net.sf.cglib.asm.Type;
import net.sf.cglib.core.AbstractClassGenerator;
import net.sf.cglib.core.ClassEmitter;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.Constants;
import net.sf.cglib.core.EmitUtils;
import net.sf.cglib.core.Local;
import net.sf.cglib.core.MethodInfo;
import net.sf.cglib.core.ReflectUtils;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.TypeUtils;
import ru.infor.common.BeanCopier;
import ru.infor.common.BeanCopierId;
import ru.infor.common.BeanCopierKey;

public class BeanCopierGenerator
extends AbstractClassGenerator {
    private static final Type CONVERTER = TypeUtils.parseType((String)"net.sf.cglib.core.Converter");
    private static final Type BEAN_COPIER = TypeUtils.parseType((String)BeanCopier.class.getName());
    private static final Signature COPY = new Signature("copy", Type.VOID_TYPE, new Type[]{Constants.TYPE_OBJECT, Constants.TYPE_OBJECT, CONVERTER});
    private static final Signature CONVERT = TypeUtils.parseSignature((String)"Object convert(Object, Class, Object)");
    private static Map<BeanCopierId, BeanCopier> copiers = new HashMap<BeanCopierId, BeanCopier>();
    private Class<?> source;
    private Class<?> target;
    private boolean useConverter = true;

    protected BeanCopierGenerator(Class<?> source, Class<?> target, boolean useConverter) {
        super(new AbstractClassGenerator.Source(BeanCopier.class.getName()));
        this.source = source;
        this.target = target;
        this.useConverter = useConverter;
    }

    protected BeanCopier create() {
        BeanCopierKey key = new BeanCopierKey(this.source, this.target, this.useConverter);
        return (BeanCopier)super.create((Object)key);
    }

    protected Object firstInstance(Class type) throws Exception {
        return ReflectUtils.newInstance((Class)type);
    }

    protected ClassLoader getDefaultClassLoader() {
        return this.source.getClassLoader();
    }

    protected Object nextInstance(Object arg0) throws Exception {
        return arg0;
    }

    public void generateClass(ClassVisitor v) throws Exception {
        Type sourceType = Type.getType(this.source);
        Type targetType = Type.getType(this.target);
        ClassEmitter ce = new ClassEmitter(v);
        ce.begin_class(46, 1, this.getClassName(), BEAN_COPIER, null, "<generated>");
        EmitUtils.null_constructor((ClassEmitter)ce);
        CodeEmitter e = ce.begin_method(1, COPY, null, null);
        PropertyDescriptor[] getters = ReflectUtils.getBeanGetters(this.source);
        PropertyDescriptor[] setters = ReflectUtils.getBeanSetters(this.target);
        HashMap<String, PropertyDescriptor> names = new HashMap<String, PropertyDescriptor>();
        int i = 0;
        while (i < getters.length) {
            names.put(getters[i].getName(), getters[i]);
            ++i;
        }
        Local targetLocal = e.make_local();
        Local sourceLocal = e.make_local();
        if (this.useConverter) {
            e.load_arg(1);
            e.checkcast(targetType);
            e.store_local(targetLocal);
            e.load_arg(0);
            e.checkcast(sourceType);
            e.store_local(sourceLocal);
        } else {
            e.load_arg(1);
            e.checkcast(targetType);
            e.load_arg(0);
            e.checkcast(sourceType);
        }
        int i2 = 0;
        while (i2 < setters.length) {
            PropertyDescriptor setter = setters[i2];
            PropertyDescriptor getter = (PropertyDescriptor)names.get(setter.getName());
            if (getter != null) {
                MethodInfo read = ReflectUtils.getMethodInfo((Member)getter.getReadMethod());
                MethodInfo write = ReflectUtils.getMethodInfo((Member)setter.getWriteMethod());
                if (this.useConverter) {
                    Type setterType = write.getSignature().getArgumentTypes()[0];
                    e.load_local(targetLocal);
                    e.load_arg(2);
                    e.load_local(sourceLocal);
                    e.invoke(read);
                    e.box(read.getSignature().getReturnType());
                    EmitUtils.load_class((CodeEmitter)e, (Type)setterType);
                    e.push(write.getSignature().getName());
                    e.invoke_interface(CONVERTER, CONVERT);
                    e.unbox_or_zero(setterType);
                    e.invoke(write);
                } else if (BeanCopierGenerator.compatible(getter, setter)) {
                    e.dup2();
                    e.invoke(read);
                    e.invoke(write);
                }
            }
            ++i2;
        }
        e.return_value();
        e.end_method();
        ce.end_class();
    }

    private static boolean compatible(PropertyDescriptor getter, PropertyDescriptor setter) {
        return setter.getPropertyType().isAssignableFrom(getter.getPropertyType());
    }

    public Class<?> getSource() {
        return this.source;
    }

    public void setSource(Class<?> source) {
        this.source = source;
    }

    public Class<?> getTarget() {
        return this.target;
    }

    public void setTarget(Class<?> target) {
        this.target = target;
    }

    public boolean isUseConverter() {
        return this.useConverter;
    }

    public void setUseConverter(boolean useConverter) {
        this.useConverter = useConverter;
    }

    public static BeanCopier getInstance(Class<?> clazz, boolean useConverter) {
        return BeanCopierGenerator.getInstance(clazz, clazz, useConverter);
    }

    public static synchronized BeanCopier getInstance(Class<?> source, Class<?> target, boolean useConverter) {
        BeanCopierId copierID = new BeanCopierId(source, target, useConverter);
        BeanCopier copier = copiers.get(copierID);
        if (copier != null) {
            return copier;
        }
        copier = new BeanCopierGenerator(source, target, useConverter).create();
        copiers.put(copierID, copier);
        return copier;
    }
}

