/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.common;

import org.apache.log4j.Logger;

public final class ClassNameUtils {
    private static final Logger logger = Logger.getLogger(ClassNameUtils.class);

    public static String getServerClassName(String name) {
        int index = name.lastIndexOf(".");
        String clsName = name.substring(index + 1);
        clsName = clsName.substring(0, clsName.length() - 3);
        String packageName = name.substring(0, index - "ext".length());
        return String.valueOf(packageName) + clsName;
    }

    public static boolean isExtClass(String name) {
        return name.contains(".ext.") && name.endsWith("Ext");
    }

    public static boolean isProjectClass(String name) {
        return name.startsWith("ru.infor.ws.objects.");
    }

    public static Class<?> classForName(String className) throws ClassNotFoundException {
        if (ClassNameUtils.isExtClass(className)) {
            String tmp = ClassNameUtils.getServerClassName(className);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(String.valueOf(className) + " --> " + tmp));
            }
            className = tmp;
        }
        return Class.forName(className);
    }
}

