/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.common;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import ru.infor.common.SysProperties;

public class FileUtils {
    static Logger logger = Logger.getLogger(FileUtils.class);

    public static String translit(String name) {
        char[] chArr;
        String alpha = new String("\u0420\u00b0\u0420\u00b1\u0420\u0406\u0420\u0456\u0420\u0491\u0420\u00b5\u0421\u2018\u0420\u00b6\u0420\u00b7\u0420\u0451\u0421\u2039\u0420\u2116\u0420\u0454\u0420\u00bb\u0420\u0458\u0420\u0405\u0420\u0455\u0420\u0457\u0421\u0402\u0421\u0403\u0421\u201a\u0421\u0453\u0421\u201e\u0421\u2026\u0421\u2020\u0421\u2021\u0421\u20ac\u0421\u2030\u0421\u040c\u0421\u040b\u0421\u040f1234567890");
        String[] _alpha = new String[]{"a", "b", "v", "g", "d", "e", "yo", "g", "z", "i", "y", "i", "k", "l", "m", "n", "o", "p", "r", "s", "t", "u", "f", "h", "tz", "ch", "sh", "sh", "e", "yu", "ya", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0"};
        if (name == null || name.isEmpty()) {
            return "no_name";
        }
        name = name.toLowerCase();
        StringBuilder res = new StringBuilder(name.length() * 2);
        char[] cArray = chArr = name.toCharArray();
        int n = chArr.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            int index = alpha.indexOf(c);
            if (index < 0) {
                res.append("_");
            } else {
                res.append(_alpha[index]);
            }
            ++n2;
        }
        return res.toString();
    }

    public static void copy(File source, File dest) {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            try {
                in = new FileInputStream(source);
                out = new FileOutputStream(dest);
                FileUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void copy(InputStream in, File dest) {
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(dest);
                FileUtils.copy(in, (OutputStream)out);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int len = 0;
        byte[] data = new byte[8192];
        while ((len = in.read(data)) > 0) {
            out.write(data, 0, len);
        }
        out.flush();
    }

    public static void copy(File source, OutputStream dest) {
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(source);
                FileUtils.copy((InputStream)in, dest);
            }
            finally {
                if (in != null) {
                    in.close();
                }
                dest.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void copy(String sourceName, OutputStream dest) {
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(sourceName);
                FileUtils.copy((InputStream)in, dest);
            }
            finally {
                if (in != null) {
                    in.close();
                }
                dest.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void writeStrToFile(String str, File dest) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes("UTF-8"));
        try (FileOutputStream out = null;){
            out = new FileOutputStream(dest);
            FileUtils.copy((InputStream)in, (OutputStream)out);
        }
    }

    public static String readFileToString(String fileName) {
        try {
            return FileUtils.readFileToString(new File(fileName));
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static String readFileToString(File source) throws IOException {
        return FileUtils.readFileToString(source, "UTF-8");
    }

    public static String readFileToString(File source, String charsetName) throws IOException {
        try (FileInputStream in = null;){
            in = new FileInputStream(source);
            ByteArrayOutputStream out = new ByteArrayOutputStream(16384);
            FileUtils.copy((InputStream)in, (OutputStream)out);
            String string = out.toString(charsetName);
            return string;
        }
    }

    public static void saveToFile(String fileName, String message) {
        FileUtils.saveToFile(new File(fileName), message);
    }

    public static void saveToFile(File outputFile, String message) {
        try {
            FileWriter out = new FileWriter(outputFile);
            out.write(message);
            out.close();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Deprecated
    public static void viewHtmlFile(String fileName) {
        if (fileName == null) {
            logger.error((Object)"File name is null!");
        } else {
            String osName = System.getProperty("os.name");
            if (osName.equalsIgnoreCase("Windows XP")) {
                try {
                    Runtime.getRuntime().exec("rundll32 SHELL32.DLL,ShellExec_RunDLL " + fileName);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean writeToFile(String fileName, String dataLine, boolean isAppendMode, boolean isNewLine) {
        return FileUtils.writeToFile(fileName, dataLine, isAppendMode, isNewLine, true);
    }

    public static boolean writeToFile(String fileName, String dataLine, boolean isAppendMode, boolean isNewLine, boolean isDos) {
        if (isNewLine) {
            dataLine = "\n" + dataLine;
        }
        try {
            File outFile = new File(fileName);
            FileOutputStream os = isAppendMode ? new FileOutputStream(fileName, true) : new FileOutputStream(outFile);
            if (isDos) {
                ((OutputStream)os).write(dataLine.getBytes("CP1251"));
            } else {
                ((OutputStream)os).write(dataLine.getBytes("CP866"));
            }
            ((OutputStream)os).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public static String zipFiles(String[] fileS) {
        return FileUtils.zipFiles(fileS, null);
    }

    public static String zipFiles(String[] fileS, String zipFilename) {
        if (fileS == null || fileS.length == 0) {
            return null;
        }
        String fileName = "xxx";
        if (zipFilename == null || zipFilename.trim().equals("")) {
            File file0 = new File(fileS[0]);
            fileName = file0.getParent().concat(File.separator).concat(file0.getName());
        } else {
            fileName = zipFilename.trim();
        }
        if (!fileName.endsWith("zip")) {
            fileName = fileName.concat(".zip");
        }
        logger.debug((Object)("zip file name=" + fileName));
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(fileName));
            int i = 0;
            while (i < fileS.length) {
                File file = new File(fileS[i]);
                FileUtils.doZip(file, out);
                ++i;
            }
            out.close();
            return fileName;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static void doZip(File dir, ZipOutputStream out) throws IOException {
        logger.debug((Object)("zip file=" + dir.getPath()));
        if (dir.isDirectory()) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                FileUtils.doZip(f, out);
                ++n2;
            }
        } else {
            out.putNextEntry(new ZipEntry(dir.getName()));
            FileUtils.write2Archive(new FileInputStream(dir), out);
        }
    }

    private static void write2Archive(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
    }

    public static String[] unzipFile(String fileS) {
        return FileUtils.unzipFile(fileS, null);
    }

    public static String[] unzipFile(String fileS, String outputDir) {
        File outputDirFile;
        File file = new File(fileS);
        if (!file.exists() || !file.canRead()) {
            logger.error((Object)("File cannot be read:" + fileS));
            return null;
        }
        if (outputDir == null || outputDir.trim().equals("")) {
            outputDir = file.getParent();
        }
        if (!(outputDirFile = new File(outputDir)).exists() && !outputDirFile.mkdirs()) {
            logger.error((Object)("invalid value: path for unzip =" + outputDirFile + " - not exist or unaccessable"));
            return null;
        }
        ArrayList<String> rez = new ArrayList<String>();
        try {
            ZipFile zip = new ZipFile(fileS);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    new File(outputDir, entry.getName()).mkdirs();
                    continue;
                }
                FileUtils.writeFromArchive(zip.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(new File(outputDir, entry.getName()))));
                String re = new File(outputDir) + File.separator + entry.getName();
                rez.add(re);
                logger.debug((Object)("unzip file=" + re));
            }
            zip.close();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return rez.toArray(new String[rez.size()]);
    }

    private static void writeFromArchive(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        out.close();
        in.close();
    }

    public static void loadFileFromInternet(String pathTempFile, String url) {
        logger.debug((Object)("loadFileFromInternet url=" + url));
        FilterInputStream in = null;
        OutputStream fOut = null;
        try {
            try {
                int data;
                URL remoteFile = new URL(url);
                URLConnection fileStream = remoteFile.openConnection();
                fOut = new FileOutputStream(pathTempFile);
                new DataOutputStream(fOut);
                in = new DataInputStream(fileStream.getInputStream());
                while ((data = in.read()) != -1) {
                    ((FileOutputStream)fOut).write(data);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                try {
                    if (in != null) {
                        in.close();
                    }
                    fOut.flush();
                    ((FileOutputStream)fOut).close();
                }
                catch (Exception e2) {
                    logger.error((Object)e2.getMessage(), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                fOut.flush();
                ((FileOutputStream)fOut).close();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static String load2StringFromInternet(String url) {
        logger.debug((Object)("load2StringFromInternet url=" + url));
        try {
            String inputLine;
            URL remoteFile = new URL(url);
            URLConnection fileStream = remoteFile.openConnection();
            BufferedReader br = new BufferedReader(new InputStreamReader(fileStream.getInputStream(), "UTF-8"));
            StringBuilder response = new StringBuilder();
            while ((inputLine = br.readLine()) != null) {
                response.append(inputLine);
            }
            br.close();
            String rez = StringEscapeUtils.unescapeJava((String)response.toString());
            logger.debug((Object)("load2StringFromInternet rez=" + rez));
            return rez;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return null;
        }
    }

    public static String[] uploadFile2ListFile(String filename) {
        String fileUrl;
        String[] fileList;
        block4: {
            fileList = null;
            String path = SysProperties.getProperty("upload.path", "c:/upload");
            if (path == null) {
                path = File.createTempFile("create", ".xml").getParent();
            }
            if ((fileUrl = String.valueOf(path) + File.separator + filename) != null && !fileUrl.trim().equals("")) break block4;
            return null;
        }
        try {
            fileList = filename.indexOf(".zip") > -1 ? FileUtils.unzipFile(fileUrl) : new String[]{fileUrl};
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return fileList;
    }

    public static byte[] readFileToBytes(InputStream in) throws IOException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(16384);
            FileUtils.copy(in, (OutputStream)out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static String toHex(String arg) {
        return String.format("%040x", new BigInteger(1, arg.getBytes()));
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        int i = 0;
        while (i < len) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
            i += 2;
        }
        return data;
    }
}

