/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.common;

import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Logger;
import ru.infor.common.SysProperties;
import ru.infor.ws.objects.InvocationContext;

public class SendEMail {
    static final Logger logger = Logger.getLogger(SendEMail.class);
    private static final SendEMail send = new SendEMail();

    public static final SendEMail getInstance() {
        return send;
    }

    private SendEMail() {
    }

    public Integer sendEMail(InvocationContext ctx, Address[] address, String subject, String mess, MimeBodyPart attachPart) {
        try {
            Properties mailProps = new Properties();
            mailProps.put("mail.smtp.host", SysProperties.getProperty("mail.smtp.host", null));
            mailProps.put("mail.smtp.port", SysProperties.getProperty("mail.smtp.port", "25"));
            mailProps.put("mail.smtp.auth", "true");
            mailProps.put("mail.smtp.starttls.enable", "true");
            Session mailSession = Session.getInstance((Properties)mailProps, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    String userName = SysProperties.getProperty("smtp.authentication.userName", null);
                    String psw = SysProperties.getProperty("smtp.authentication.password", null);
                    return new PasswordAuthentication(userName, psw);
                }
            });
            MimeMessage message = new MimeMessage(mailSession);
            InternetAddress from = null;
            String emailFrom = SysProperties.getProperty("notification.smtp.email", null);
            String person = SysProperties.getProperty("notification.smtp.userTitle", null);
            from = person == null ? new InternetAddress(emailFrom) : new InternetAddress(emailFrom, person);
            message.setFrom((Address)from);
            message.setRecipients(Message.RecipientType.TO, address);
            message.setSubject(subject, "UTF-8");
            StringBuilder msgText = new StringBuilder("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\"><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />");
            msgText.append("<title>").append(subject).append("</title>");
            msgText.append("</head><body>");
            msgText.append(mess);
            msgText.append("</body></html>");
            MimeMultipart mp = new MimeMultipart();
            MimeBodyPart mbp1 = new MimeBodyPart();
            mbp1.setHeader("Content-type", "text/html");
            mbp1.setContent((Object)msgText.toString(), "text/html;charset=\"utf-8\"");
            mp.addBodyPart((BodyPart)mbp1);
            if (attachPart != null) {
                mp.addBodyPart((BodyPart)attachPart);
            }
            message.setContent((Multipart)mp);
            message.setSentDate(new Date());
            Transport.send((Message)message);
            return 0;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return -9;
        }
    }

    public Integer sendEMailWithPicture(InvocationContext ctx, Address[] address, String subject, String mess, String imagePath) {
        try {
            Properties mailProps = new Properties();
            mailProps.put("mail.smtp.host", SysProperties.getProperty("mail.smtp.host", null));
            mailProps.put("mail.smtp.port", SysProperties.getProperty("mail.smtp.port", "25"));
            mailProps.put("mail.smtp.auth", "true");
            mailProps.put("mail.smtp.starttls.enable", "true");
            Session mailSession = Session.getInstance((Properties)mailProps, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    String userName = SysProperties.getProperty("smtp.authentication.userName", null);
                    String psw = SysProperties.getProperty("smtp.authentication.password", null);
                    return new PasswordAuthentication(userName, psw);
                }
            });
            MimeMessage message = new MimeMessage(mailSession);
            InternetAddress from = null;
            String emailFrom = SysProperties.getProperty("notification.smtp.email", null);
            String person = SysProperties.getProperty("notification.smtp.userTitle", null);
            from = person == null ? new InternetAddress(emailFrom) : new InternetAddress(emailFrom, person);
            message.setFrom((Address)from);
            message.setRecipients(Message.RecipientType.TO, address);
            message.setSubject(subject, "UTF-8");
            StringBuilder msgText = new StringBuilder("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\"><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />");
            msgText.append("<title>").append(subject).append("</title>");
            msgText.append("</head><body>");
            msgText.append(mess);
            msgText.append("<br><br><br>").append("<img src=\"").append(imagePath).append("\">");
            msgText.append("</body></html>");
            MimeMultipart mp = new MimeMultipart();
            MimeBodyPart mbp1 = new MimeBodyPart();
            mbp1.setHeader("Content-type", "text/html");
            mbp1.setContent((Object)msgText.toString(), "text/html;charset=\"utf-8\"");
            mp.addBodyPart((BodyPart)mbp1);
            message.setContent((Multipart)mp);
            message.setSentDate(new Date());
            Transport.send((Message)message);
            return 0;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return -9;
        }
    }
}

