/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.common;

import java.io.IOException;
import java.net.URLEncoder;
import org.apache.log4j.Logger;
import ru.infor.common.FileUtils;
import ru.infor.common.SysProperties;
import ru.infor.ws.objects.InvocationContext;

public class SendSMS {
    static final Logger logger = Logger.getLogger(SendSMS.class);
    private static final SendSMS send = new SendSMS();

    public static final SendSMS getInstance() {
        return send;
    }

    private SendSMS() {
    }

    public Integer sendSMS(InvocationContext context, String phone, String message) {
        try {
            logger.debug((Object)("transfer SMS to " + phone + " : " + message));
            String url = SysProperties.getProperty("send.sms.url", null);
            String username = SysProperties.getProperty("send.sms.username", null);
            String password = SysProperties.getProperty("send.sms.password", null);
            String template = SysProperties.getProperty("send.sms.template", null);
            if (url == null || username == null || password == null || url.trim().equals("") || username.trim().equals("") || password.trim().equals("") || template == null || template.trim().equals("")) {
                logger.error((Object)"Null: url or username or password or template");
                return -1;
            }
            if (phone == null || phone.trim().equals("")) {
                logger.error((Object)"No phone to send sms");
                return -2;
            }
            if (message == null || message.trim().equals("")) {
                logger.error((Object)"No message to send sms");
                return -3;
            }
            String urlStr = url.concat(String.format(template, URLEncoder.encode(username, "UTF-8"), URLEncoder.encode(password, "UTF-8"), URLEncoder.encode(phone.trim(), "UTF-8"), URLEncoder.encode(message.trim(), "UTF-8")));
            logger.debug((Object)("urlSMS = " + urlStr));
            String rez = FileUtils.load2StringFromInternet(urlStr);
            if (rez == null) {
                logger.error((Object)("answer null from " + url));
                return -4;
            }
            if (rez.toLowerCase().indexOf("fail") > -1 || rez.toLowerCase().indexOf("error") > -1) {
                logger.error((Object)("answer from " + url + " error: " + rez));
                return -5;
            }
            return 0;
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
            return -9;
        }
    }
}

