/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.common;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class SysProperties {
    static Logger logger = Logger.getLogger(SysProperties.class);
    static Properties props = new Properties();
    static String prefix;

    static {
        SysProperties.reloadProperties();
    }

    public static String getProperty(String name, String defaultValue) {
        prefix = System.getProperty("common.props.prefix", "");
        String value = props.getProperty(String.valueOf(prefix) + name);
        if (value == null) {
            value = System.getProperty(String.valueOf(prefix) + name, defaultValue);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadProperties() {
        Properties p = new Properties();
        SysProperties.loadProps(p, ".prop");
        Properties properties = props;
        synchronized (properties) {
            props = new Properties(p);
        }
    }

    public static void loadProps(Properties props, final String fileExtension) {
        String folder = System.getProperty("common.props.folder", "config");
        File file = new File(folder);
        if (!file.exists()) {
            logger.error((Object)("folder not found: " + folder));
        }
        logger.debug((Object)("use folder: " + file.getAbsolutePath()));
        if (file.isDirectory()) {
            FileFilter ff = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getAbsolutePath().endsWith(fileExtension);
                }
            };
            File[] fileArray = file.listFiles(ff);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                SysProperties.loadPropertiesFromFile(f, props);
                ++n2;
            }
        } else {
            SysProperties.loadPropertiesFromFile(file, props);
        }
    }

    private static void loadPropertiesFromFile(File file, Properties props) {
        Properties p = new Properties();
        try {
            p.load(new FileInputStream(file));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        props.putAll((Map<?, ?>)p);
    }
}

