/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.db.common;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.transform.ResultTransformer;
import ru.infor.ws.business.ApplicationException;

public class AliasToBeanResultTransformer
implements ResultTransformer {
    private static final long serialVersionUID = -5431434656896956567L;
    private static Logger logger = Logger.getLogger(AliasToBeanResultTransformer.class);
    private Class<?> clazz = null;
    private HashMap<String, PropertyDescriptor> writeMethodMap = null;

    public AliasToBeanResultTransformer(Class<?> clazz) {
        if (clazz == null) {
            new ApplicationException("Class can't be null", "validation.not.null", new Throwable());
        }
        this.clazz = clazz;
        this.fillMethodMap();
    }

    private void fillMethodMap() {
        this.writeMethodMap = new HashMap();
        try {
            PropertyDescriptor[] descriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(this.clazz);
            PropertyDescriptor[] propertyDescriptorArray = descriptors = beanInfo.getPropertyDescriptors();
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor descriptor = propertyDescriptorArray[n2];
                if (descriptor.getWriteMethod() != null) {
                    this.writeMethodMap.put(descriptor.getName().toLowerCase(), descriptor);
                }
                ++n2;
            }
        }
        catch (IntrospectionException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            new ApplicationException("Can't get Bean Info for " + this.clazz + " class.", "validation.not.null", new Throwable());
        }
    }

    public List transformList(List list) {
        return list;
    }

    public Object transformTuple(Object[] tuple, String[] aliases) {
        Object res = null;
        if (tuple != null && aliases != null && this.clazz != null) {
            try {
                res = this.clazz.newInstance();
                int i = 0;
                while (i < tuple.length) {
                    String propName = aliases[i];
                    if (propName.startsWith("_")) {
                        propName = propName.substring(1);
                    }
                    Object propValue = tuple[i];
                    this.trySetPropValue(res, propName.toLowerCase(), propValue);
                    ++i;
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return res;
    }

    private void trySetPropValue(Object res, String propName, Object propValue) {
        PropertyDescriptor pd = this.writeMethodMap.get(propName);
        if (pd != null && pd.getWriteMethod() != null) {
            try {
                if (propValue == null) {
                    pd.getWriteMethod().invoke(res, propValue);
                } else if (pd.getPropertyType().isAssignableFrom(propValue.getClass())) {
                    pd.getWriteMethod().invoke(res, propValue);
                } else if (propValue instanceof Number) {
                    Number num = (Number)propValue;
                    if (pd.getPropertyType().equals(Long.class)) {
                        propValue = new Long(num.longValue());
                    } else if (pd.getPropertyType().equals(Integer.class)) {
                        propValue = new Integer(num.intValue());
                    }
                    pd.getWriteMethod().invoke(res, propValue);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

