/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.db.common;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import ru.infor.db.common.BuildSQLCallback;
import ru.infor.db.common.CommonManagerCr;
import ru.infor.db.common.SetParametersCallback;
import ru.infor.ws.core.MessageReceiverUtils;
import ru.infor.ws.core.ValidationUtils;
import ru.infor.ws.objects.CommonSearchCriteria;
import ru.infor.ws.objects.SearchResultList;
import ru.infor.ws.objects.ServerInvocationContext;
import ru.infor.ws.objects.core.SortObject;
import ru.infor.ws.objects.core.entities.ChangerInfo;
import ru.infor.ws.objects.core.entities.ChangerInfoThin;
import ru.infor.ws.objects.core.entities.LazyRemoveable;
import ru.infor.ws.objects.core.entities.LowlevelEntity;
import ru.infor.ws.objects.core.entities.User;

public class CommonManager {
    protected Logger logger = Logger.getLogger(this.getClass());
    private ServerInvocationContext sic;
    private Session session;
    private static final String ARITHMETIC = "[\\+\\-\\*/]";

    protected CommonManager(ServerInvocationContext context) {
        this.sic = context;
    }

    protected CommonManager(Session session) {
        this.session = session;
    }

    protected ServerInvocationContext getContext() {
        return this.sic;
    }

    protected Session getSession() {
        return this.sic != null ? this.sic.getSession() : this.session;
    }

    public Object get(Class<?> entityClass, Long id) {
        return this.getSession().get(entityClass, (Serializable)id);
    }

    public Object save(Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj can't be NULL!");
        }
        this.updateChangerInfo(obj);
        return this.getSession().merge(obj);
    }

    private void updateChangerInfo(Object obj) {
        User u;
        if (!ChangerInfo.class.isAssignableFrom(obj.getClass()) && !ChangerInfoThin.class.isAssignableFrom(obj.getClass())) {
            return;
        }
        if (obj instanceof User && MessageReceiverUtils.isAdminUser((User)(u = (User)obj))) {
            return;
        }
        User currentUser = this.getContext().getUser();
        if (currentUser == null) {
            this.logger.error((Object)"[updateChangerInfo]: no User in InvocationContext", (Throwable)new Exception());
        }
        if (ChangerInfo.class.isAssignableFrom(obj.getClass())) {
            ChangerInfo info = (ChangerInfo)obj;
            if (!info.isStored()) {
                info.setCreatedBy(currentUser);
                info.setCreatedDateTime(new Date());
                info.setChangedBy(null);
                info.setChangedDateTime(null);
            } else {
                info.setChangedBy(currentUser);
                info.setChangedDateTime(new Date());
            }
        } else if (currentUser != null) {
            ChangerInfoThin info = (ChangerInfoThin)obj;
            if (!info.isStored()) {
                info.setCreatedById(currentUser.getId());
                info.setCreatedDateTime(new Date());
                info.setChangedById(null);
                info.setChangedDateTime(null);
            } else {
                info.setChangedById(currentUser.getId());
                info.setChangedDateTime(new Date());
            }
        }
    }

    public void delete(Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj can't be NULL!");
        }
        if (LazyRemoveable.class.isAssignableFrom(obj.getClass())) {
            LazyRemoveable lr = (LazyRemoveable)obj;
            lr.setIsDeleted(1);
            this.updateChangerInfo(obj);
            this.getSession().merge((Object)lr);
        } else {
            this.getSession().delete(obj);
        }
        this.getSession().flush();
    }

    public void delete(Class<?> instanceClass, Long id) {
        Object obj = this.getSession().get(instanceClass, (Serializable)id);
        if (LazyRemoveable.class.isAssignableFrom(instanceClass)) {
            this.delete(obj);
        } else {
            this.erase(instanceClass, id);
        }
    }

    public void erase(Class<?> instanceClass, Long id) {
        Object obj = this.getContext().getSession().get(instanceClass, (Serializable)id);
        this.getContext().getSession().delete(obj);
    }

    protected void appendIdListFilter_noand(StringBuilder sb, String fieldName, Long[] list) {
        sb.append(" (").append(fieldName).append(" in (");
        int i = 0;
        while (i < list.length) {
            sb.append(list[i]);
            if (i != list.length - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append(")) ");
    }

    protected void appendIdListFilter(StringBuilder sb, String fieldName, Long[] list) {
        sb.append(" and ");
        this.appendIdListFilter_noand(sb, fieldName, list);
    }

    protected void appendStringListFilter(StringBuilder sb, String fieldName, String[] list) {
        sb.append(" and (upper(").append(fieldName).append(") in (");
        int i = 0;
        while (i < list.length) {
            sb.append("upper('").append(list[i].trim()).append("')");
            if (i != list.length - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append(")) ");
    }

    protected Integer getCountInt(CommonSearchCriteria sc, StringBuilder query, SetParametersCallback parametersCallback) {
        StringBuilder sb = new StringBuilder("select count(*) ");
        sb.append((CharSequence)query);
        Query q = this.getSession().createQuery(sb.toString());
        parametersCallback._setParameters(sc, q);
        q.setMaxResults(1);
        List list = q.list();
        if (list == null || list.isEmpty()) {
            return 0;
        }
        Number n = (Number)list.get(0);
        return n == null ? 0 : n.intValue();
    }

    protected Integer getCountInt(CommonSearchCriteria sc, BuildSQLCallback buildSQLCallback, SetParametersCallback parametersCallback) {
        return this.getCountInt(sc, buildSQLCallback._buildSQLText(sc), parametersCallback);
    }

    protected SearchResultList getListInt(CommonSearchCriteria sc, Class<?> clazz, BuildSQLCallback buildSQLCallback, SetParametersCallback parametersCallback) {
        StringBuilder query = buildSQLCallback._buildSQLText(sc);
        SearchResultList<Object> resultList = new SearchResultList<Object>();
        resultList.setTotalCount(this.getCountInt(sc, query, parametersCallback));
        if (resultList.getTotalCount() == 0) {
            return resultList;
        }
        query.append(CommonManager.orderOfSorting(sc, null));
        Query q = this.getSession().createQuery(query.toString());
        parametersCallback._setParameters(sc, q);
        q.setFirstResult(sc.getBeginIndex().intValue());
        q.setMaxResults(sc.getCount().intValue());
        List list = q.list();
        resultList.setObjList(list.toArray((Object[])Array.newInstance(clazz, list.size())));
        return resultList;
    }

    protected StringBuilder buildListSQL(CommonSearchCriteria sc, Class<?> clazz) {
        StringBuilder sb = new StringBuilder("from ").append(clazz.getName());
        sb.append(" where ");
        String filter = " (1=1) ";
        if (LowlevelEntity.class.isAssignableFrom(clazz) && sc.getLoadDeletedItems() == 0) {
            filter = " (isDeleted = 0) ";
        }
        sb.append(filter);
        if (this.isFilterSet(sc.getIdList())) {
            this.appendIdListFilter(sb, "id", sc.getIdList());
        }
        return sb;
    }

    protected boolean isFilterSet(Object filter) {
        if (filter == null) {
            return false;
        }
        if (filter.getClass().isArray()) {
            Object[] list = (Object[])filter;
            return list.length > 0;
        }
        if (filter instanceof String) {
            String str = (String)filter;
            return str.trim().length() > 0;
        }
        return true;
    }

    public static String convertString2DBFilter(String source) {
        return CommonManagerCr.convertString2DBFilter(source).toUpperCase();
    }

    private boolean checkRowLocateable(ServerInvocationContext context, CommonSearchCriteria sc, Long selectedId, String sqlBody, SetParametersCallback setParametersCallback) {
        StringBuilder sb = new StringBuilder("select count(id) ");
        sb.append(sqlBody).append(" and (id = ").append(selectedId).append(")");
        Query q = context.getSession().createQuery(sb.toString());
        q = setParametersCallback._setParameters(sc, q);
        List list = q.list();
        if (list == null || list.isEmpty()) {
            return false;
        }
        Long count = (Long)list.get(0);
        return count.intValue() > 0;
    }

    protected Integer getRowIndexInt(CommonSearchCriteria sc, Long selectedId, Class<?> entityClass, SetParametersCallback setParametersCallback, BuildSQLCallback buildSQLCallback) {
        String sqlBody = buildSQLCallback._buildSQLText(sc).toString();
        if (!this.checkRowLocateable(this.getContext(), sc, selectedId, sqlBody, setParametersCallback)) {
            return -1;
        }
        Object obj = this.getContext().getSession().get(entityClass, (Serializable)selectedId);
        this.logger.debug((Object)("selected item: " + obj));
        ValidationUtils.notNull((Object)obj, (String)("unable to locate object: " + entityClass.getName() + "{id = " + selectedId + "}"));
        if (sc.getListSort() == null) {
            sc.setListSort(new SortObject[0]);
        }
        ArrayList<SortObject> filters = new ArrayList<SortObject>(Arrays.asList(sc.getListSort()));
        filters.add(SortObject.getInstance("id", SortObject.DIRECTION_DESC));
        Integer index = 0;
        int i = 0;
        while (i < filters.size()) {
            StringBuilder sb = new StringBuilder("select count(*) ");
            sb.append(sqlBody);
            int j = 0;
            while (j <= i) {
                SortObject so = (SortObject)filters.get(j);
                String so_name = this.getSortObjectName(so);
                sb.append(" and (").append(so_name);
                if (j != i) {
                    sb.append(" = ");
                } else if (SortObject.DIRECTION_ASC.equalsIgnoreCase(so.getDirection())) {
                    sb.append(" < ");
                } else {
                    sb.append(" > ");
                }
                String paramName = this.getParamName(so_name);
                if (this.isExpression(so_name)) {
                    sb.append(this.getExpresstionPropValue(obj, so_name)).append(") ");
                } else {
                    sb.append(" :").append(paramName).append(") ");
                }
                ++j;
            }
            Query q = this.getContext().getSession().createQuery(sb.toString());
            q = setParametersCallback._setParameters(sc, q);
            int j2 = 0;
            while (j2 <= i) {
                SortObject so = (SortObject)filters.get(j2);
                String name = this.getSortObjectName(so);
                if (!this.isExpression(name)) {
                    String paramName = this.getParamName(name);
                    if (name.indexOf(".") > 0) {
                        q.setParameter(paramName, this.getComplexPropValue(obj, name));
                    } else {
                        q.setParameter(paramName, this.getSimplePropValue(obj, name));
                    }
                }
                ++j2;
            }
            q.setMaxResults(1);
            List list = q.list();
            Long res = list != null && !list.isEmpty() ? (Long)list.get(0) : 0L;
            index = index + res.intValue();
            ++i;
        }
        return index;
    }

    private boolean isExpression(String name) {
        return name.contains("+") || name.contains("-") || name.contains("*") || name.contains("/");
    }

    private String getExpresstionPropValue(Object obj, String name) {
        String tmp = name.replaceAll("[()]", "");
        Object[] terms = tmp.split(ARITHMETIC);
        this.logger.debug((Object)("expression terms: " + Arrays.toString(terms)));
        Object[] objectArray = terms;
        int n = terms.length;
        int n2 = 0;
        while (n2 < n) {
            Object term = objectArray[n2];
            Object value = ((String)term).indexOf(".") > 0 ? this.getComplexPropValue(obj, (String)term) : this.getSimplePropValue(obj, (String)term);
            name = name.replaceFirst((String)term, String.valueOf(value));
            ++n2;
        }
        this.logger.debug((Object)("expression value: " + name));
        return name;
    }

    private String getParamName(String name) {
        return "sc_" + name.trim().replaceAll("[\\.()]", "_");
    }

    private String getSortObjectName(SortObject so) {
        return so.getName();
    }

    protected Object getComplexPropValue(Object obj, String name) {
        String[] props;
        String[] stringArray = props = name.split("\\.");
        int n = props.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            obj = this.getSimplePropValue(obj, str);
            ++n2;
        }
        return obj;
    }

    protected Object getSimplePropValue(Object obj, String name) {
        String methodName = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
        Object res = null;
        try {
            Method mtd = obj.getClass().getMethod(methodName, new Class[0]);
            res = mtd.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.logger.debug((Object)("object: " + obj + " property: " + name + " getter name: " + methodName + " value: " + res));
        return res;
    }

    public static String orderOfSorting(CommonSearchCriteria sc, String tablePrefix) {
        tablePrefix = tablePrefix != null ? tablePrefix.trim() : null;
        StringBuilder result = new StringBuilder(" order by ");
        if (sc.getListSort() != null && sc.getListSort().length > 0) {
            SortObject[] sortObjectArray = sc.getListSort();
            int n = sortObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                SortObject so = sortObjectArray[n2];
                if (tablePrefix != null) {
                    result.append(tablePrefix).append(".");
                }
                result.append(so.name).append(" ").append(so.direction);
                result.append(",");
                ++n2;
            }
        }
        if (tablePrefix != null) {
            result.append(tablePrefix).append(".");
        }
        result.append("id DESC ");
        return result.toString();
    }

    public static synchronized Long getIds(ServerInvocationContext sic, Long count) {
        Long BASE_ID = null;
        Transaction tr = null;
        try {
            tr = sic.getSession().beginTransaction();
            SQLQuery q = sic.getSession().createSQLQuery("select setval('hibernate_sequence', nextval('hibernate_sequence')+" + count + ")");
            List list = q.list();
            BASE_ID = list == null || list.isEmpty() ? Long.valueOf(System.nanoTime()) : Long.valueOf(((Number)list.get(0)).longValue());
        }
        finally {
            tr.commit();
        }
        return BASE_ID - count;
    }
}

