/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.db.common;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.persistence.Id;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import ru.infor.common.SysProperties;
import ru.infor.db.common.CriteriaWrapper;
import ru.infor.ws.core.MessageReceiverUtils;
import ru.infor.ws.core.ValidationUtils;
import ru.infor.ws.objects.CommonSearchCriteria;
import ru.infor.ws.objects.InvocationContext;
import ru.infor.ws.objects.SearchResultList;
import ru.infor.ws.objects.ServerInvocationContext;
import ru.infor.ws.objects.core.SortObject;
import ru.infor.ws.objects.core.entities.ChangerInfo;
import ru.infor.ws.objects.core.entities.ChangerInfoThin;
import ru.infor.ws.objects.core.entities.LazyRemoveable;
import ru.infor.ws.objects.core.entities.LowlevelEntity;
import ru.infor.ws.objects.core.entities.LowlevelEntityWithChangerInfo;
import ru.infor.ws.objects.core.entities.User;

public abstract class CommonManagerCr {
    private static final String ARITHMETIC = "[\\+\\-\\*/]";
    protected static final CommonSearchCriteria FAKE_SEARCH_CRITERIA = new CommonSearchCriteria(){};
    private ServerInvocationContext context;
    protected Logger logger = Logger.getLogger(this.getClass());

    public ServerInvocationContext getContext() {
        return this.context;
    }

    public Session getSession() {
        return this.context != null ? this.context.getSession() : null;
    }

    public User getUser() {
        return this.context != null ? this.context.getUser() : null;
    }

    protected CommonManagerCr(Session session, User user) {
        ServerInvocationContext context = new ServerInvocationContext(new InvocationContext(), user);
        context.setSession(session);
        this.context = context;
        this.validateContext(context);
    }

    protected CommonManagerCr(ServerInvocationContext context) {
        this.context = context;
        this.validateContext(context);
    }

    private void validateContext(ServerInvocationContext context) {
        ValidationUtils.notNull((Object)context.getSession(), (String)"session can't be null");
        ValidationUtils.isTrue((boolean)context.getSession().isOpen(), (String)"session was closed");
    }

    public Object save(Object obj) {
        ValidationUtils.notNull((Object)obj, (String)"saved objecgt can't be null");
        this.updateChangerInfo(obj);
        obj = this.getSession().merge(obj);
        this.getSession().flush();
        return obj;
    }

    private void updateChangerInfo(Object obj) {
        User u;
        if (!ChangerInfo.class.isAssignableFrom(obj.getClass()) && !ChangerInfoThin.class.isAssignableFrom(obj.getClass())) {
            return;
        }
        if (obj instanceof User && MessageReceiverUtils.isAdminUser((User)(u = (User)obj))) {
            return;
        }
        User currentUser = this.getContext().getUser();
        if (currentUser == null) {
            this.logger.error((Object)"[updateChangerInfo]: no User in InvocationContext", (Throwable)new Exception());
        }
        if (ChangerInfo.class.isAssignableFrom(obj.getClass())) {
            ChangerInfo info = (ChangerInfo)obj;
            if (!info.isStored()) {
                info.setCreatedBy(currentUser);
                info.setCreatedDateTime(new Date());
                info.setChangedBy(null);
                info.setChangedDateTime(null);
            } else {
                if (info.getCreatedBy() == null || info.getCreatedDateTime() == null) {
                    Method getIdMtd = null;
                    Method[] methodArray = info.getClass().getMethods();
                    int n = methodArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Method mtd = methodArray[n2];
                        if (mtd.getAnnotation(Id.class) != null) {
                            getIdMtd = mtd;
                            break;
                        }
                        ++n2;
                    }
                    if (getIdMtd != null) {
                        try {
                            Serializable id = (Serializable)getIdMtd.invoke((Object)info, new Object[0]);
                            ChangerInfo infoDB = (ChangerInfo)this.getSession().get(info.getClass(), id);
                            this.getSession().evict((Object)infoDB);
                            if (info.getCreatedBy() == null) {
                                info.setCreatedBy(infoDB.getCreatedBy());
                            }
                            info.setCreatedDateTime(infoDB.getCreatedDateTime());
                        }
                        catch (Exception exception) {}
                    }
                }
                info.setChangedBy(currentUser);
                info.setChangedDateTime(new Date());
            }
        } else if (currentUser != null) {
            ChangerInfoThin info = (ChangerInfoThin)obj;
            if (!info.isStored()) {
                info.setCreatedById(currentUser.getId());
                info.setCreatedDateTime(new Date());
                info.setChangedById(null);
                info.setChangedDateTime(null);
            } else {
                Method getIdMtd = null;
                Method[] methodArray = info.getClass().getMethods();
                int n = methodArray.length;
                int infoDB = 0;
                while (infoDB < n) {
                    Method mtd = methodArray[infoDB];
                    if (mtd.getAnnotation(Id.class) != null) {
                        getIdMtd = mtd;
                        break;
                    }
                    ++infoDB;
                }
                if (getIdMtd != null) {
                    try {
                        Serializable id = (Serializable)getIdMtd.invoke((Object)info, new Object[0]);
                        ChangerInfoThin infoDB2 = (ChangerInfoThin)this.getSession().get(info.getClass(), id);
                        this.getSession().evict((Object)infoDB2);
                        info.setCreatedDateTime(infoDB2.getCreatedDateTime());
                    }
                    catch (Exception exception) {}
                }
                info.setChangedById(currentUser.getId());
                info.setChangedDateTime(new Date());
            }
        }
    }

    public void delete(Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj can't be NULL!");
        }
        if (LazyRemoveable.class.isAssignableFrom(obj.getClass())) {
            LazyRemoveable lr = (LazyRemoveable)obj;
            lr.setIsDeleted(1);
            this.updateChangerInfo(obj);
            this.getSession().merge((Object)lr);
        } else {
            this.getSession().delete(obj);
        }
        this.getSession().flush();
    }

    public void delete(Long id) {
        Object obj = this.getSession().get(this.getEntityClass(), (Serializable)id);
        if (obj == null) {
            this.logger.warn((Object)("invalid object: " + this.getEntityClass().getName() + "{id=" + id + "}"));
            return;
        }
        if (LazyRemoveable.class.isAssignableFrom(obj.getClass())) {
            this.delete(obj);
        } else {
            this.erase(id);
        }
    }

    public Object create() throws Exception {
        return this.getEntityClass().newInstance();
    }

    public void erase(Long id) throws HibernateException {
        Object obj = this.getSession().get(this.getEntityClass(), (Serializable)id);
        if (obj == null) {
            this.logger.warn((Object)("invalid object: " + this.getEntityClass().getName() + "{id=" + id + "}"));
            return;
        }
        this.getSession().delete(obj);
        this.getSession().flush();
    }

    public Object get(Long id) {
        return this.getSession().get(this.getEntityClass(), (Serializable)id);
    }

    public List<?> lookup(String uniqueId) {
        Criteria c = this.getSession().createCriteria(this.getEntityClass());
        c.add((Criterion)Restrictions.eq((String)"uniqueKey", (Object)uniqueId));
        return c.list();
    }

    protected CriteriaWrapper getCriteriaWrapper(CommonSearchCriteria searchCriteria) {
        return this.getCriteriaWrapper(this.getEntityClass(), searchCriteria);
    }

    protected CriteriaWrapper getCriteriaWrapper(Class<?> entityClass, CommonSearchCriteria searchCriteria) {
        CriteriaWrapper c = CriteriaWrapper.getWrapper(this.getSession().createCriteria(entityClass));
        Criterion cr = this.getIsDeletedFilter(entityClass, searchCriteria);
        if (cr != null) {
            c.add(cr);
        }
        if (this.isFilterSet(searchCriteria.getIdList())) {
            c.add(Restrictions.in((String)"id", (Object[])searchCriteria.getIdList()));
        }
        if (this.isFilterSet(searchCriteria.getFieldName()) && this.isFilterSet(searchCriteria.getFieldValues())) {
            c.add(Restrictions.in((String)searchCriteria.getFieldName(), (Object[])searchCriteria.getFieldValues()));
        }
        if (LowlevelEntityWithChangerInfo.class.isAssignableFrom(entityClass)) {
            Criterion crCreate = this.getIsCreatedDateTime(searchCriteria);
            Criterion crChange = this.getIsChangedDateTime(searchCriteria);
            if (crCreate != null && crChange != null) {
                c.add((Criterion)Restrictions.or((Criterion)crCreate, (Criterion)crChange));
            } else {
                if (crCreate != null) {
                    c.add(crCreate);
                }
                if (crChange != null) {
                    c.add(crChange);
                }
            }
        }
        return c;
    }

    private Criterion getIsCreatedDateTime(CommonSearchCriteria sc) {
        if (this.isFilterSet(sc.getCreatedDateTimeFrom()) && this.isFilterSet(sc.getCreatedDateTimeTill())) {
            return Restrictions.and((Criterion)Restrictions.ge((String)"createdDateTime", (Object)sc.getCreatedDateTimeFrom()), (Criterion)Restrictions.le((String)"createdDateTime", (Object)sc.getCreatedDateTimeTill()));
        }
        if (this.isFilterSet(sc.getCreatedDateTimeFrom())) {
            return Restrictions.ge((String)"createdDateTime", (Object)sc.getCreatedDateTimeFrom());
        }
        if (this.isFilterSet(sc.getCreatedDateTimeTill())) {
            return Restrictions.le((String)"createdDateTime", (Object)sc.getCreatedDateTimeTill());
        }
        return null;
    }

    private Criterion getIsChangedDateTime(CommonSearchCriteria sc) {
        if (this.isFilterSet(sc.getChangedDateTimeFrom()) && this.isFilterSet(sc.getChangedDateTimeTill())) {
            return Restrictions.and((Criterion)Restrictions.ge((String)"changedDateTime", (Object)sc.getChangedDateTimeFrom()), (Criterion)Restrictions.le((String)"changedDateTime", (Object)sc.getChangedDateTimeTill()));
        }
        if (this.isFilterSet(sc.getChangedDateTimeFrom())) {
            return Restrictions.ge((String)"changedDateTime", (Object)sc.getChangedDateTimeFrom());
        }
        if (this.isFilterSet(sc.getChangedDateTimeTill())) {
            return Restrictions.le((String)"changedDateTime", (Object)sc.getChangedDateTimeTill());
        }
        return null;
    }

    protected Criterion getIsDeletedFilter(Class<?> entityClass, CommonSearchCriteria searchCriteria) {
        if (LowlevelEntity.class.isAssignableFrom(entityClass) && searchCriteria.getLoadDeletedItems() != 1) {
            return Restrictions.eq((String)"isDeleted", (Object)0);
        }
        return null;
    }

    protected boolean isFilterSet(Object filter) {
        if (filter == null) {
            return false;
        }
        if (filter.getClass().isArray()) {
            Object[] list = (Object[])filter;
            return list.length > 0;
        }
        if (filter instanceof String) {
            String str = (String)filter;
            return str.trim().length() > 0;
        }
        return true;
    }

    public static String convertString2DBFilter(String source) {
        String rez;
        if (source == null) {
            return "%";
        }
        if ("1".equals(SysProperties.getProperty("core-ws.use.trim", "0"))) {
            source = source.trim();
        }
        if ((rez = source).length() == 0) {
            return "%";
        }
        rez = rez.startsWith("*") ? rez.substring(1) : "*".concat(rez);
        rez = rez.endsWith("*") ? rez.substring(0, rez.length() - 1) : rez.concat("*");
        return rez.replaceAll("\\*", "%").replaceAll("\\\\", "\\\\\\\\");
    }

    public static void main(String[] args) throws Exception {
        System.out.println("hhh\\ddd".replaceAll("\\*", "%").replaceAll("\\\\", "\\\\\\\\"));
    }

    protected void appendIdListFilter(StringBuilder sb, String fieldName, Long[] list) {
        sb.append(" and (").append(fieldName).append(" in (");
        int i = 0;
        while (i < list.length) {
            sb.append(list[i]);
            if (i != list.length - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append(")) ");
    }

    protected void appendStringListFilter(StringBuilder sb, String fieldName, String[] list) {
        sb.append(" and (").append(fieldName).append(" in (");
        int i = 0;
        while (i < list.length) {
            sb.append("'").append(list[i].trim()).append("'");
            if (i != list.length - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append(")) ");
    }

    protected abstract CriteriaWrapper buildCriteria(CommonSearchCriteria var1);

    public Integer getCount(CommonSearchCriteria sc) {
        CriteriaWrapper c = this.buildCriteria(sc);
        c.setProjection(Projections.rowCount());
        List list = c.list();
        return list.isEmpty() ? 0 : ((Number)list.get(0)).intValue();
    }

    public SearchResultList getList(CommonSearchCriteria sc) {
        SearchResultList<Object> resultList = new SearchResultList<Object>();
        CriteriaWrapper c = this.buildCriteria(sc);
        c.addOrders(sc.getListSort());
        c.setFirstResult(sc.getBeginIndex() == null ? 0 : sc.getBeginIndex());
        c.setMaxResults(sc.getCount() == null ? 10 : sc.getCount());
        List list = c.list();
        if (!list.isEmpty()) {
            resultList.setObjList(list.toArray((Object[])Array.newInstance(this.getEntityClass(), list.size())));
        }
        return resultList;
    }

    private boolean checkRowLocateable(CommonSearchCriteria sc, Long selectedId) {
        CriteriaWrapper c = this.buildCriteria(sc);
        c.setProjection(Projections.rowCount());
        c.add((Criterion)Restrictions.eq((String)"id", (Object)selectedId));
        List list = c.list();
        if (list == null || list.isEmpty()) {
            return false;
        }
        return ((Number)list.get(0)).intValue() > 0;
    }

    protected abstract Class<?> getEntityClass();

    public Integer getRowIndex(CommonSearchCriteria sc, Long selectedId) {
        if (!this.checkRowLocateable(sc, selectedId)) {
            return -1;
        }
        Object obj = this.getSession().get(this.getEntityClass(), (Serializable)selectedId);
        this.logger.debug((Object)("selected item: " + obj));
        ValidationUtils.notNull((Object)obj, (String)("unable to locate object: " + this.getEntityClass().getName() + "{id = " + selectedId + "}"));
        sc.appendSorting(SortObject.getInstance("id", SortObject.DIRECTION_DESC));
        SortObject[] filters = sc.getListSort();
        Integer index = 0;
        int i = 0;
        while (i < filters.length) {
            CriteriaWrapper c = this.buildCriteria(sc);
            c.setProjection(Projections.rowCount());
            int j = 0;
            while (j <= i) {
                SortObject so = filters[j];
                String so_name = so.getName();
                c.createRequiredJoins(so_name);
                Object so_value = this.getPropValue(obj, so_name);
                if (j != i) {
                    c.add((Criterion)(so_value == null ? Restrictions.isNull((String)so_name) : Restrictions.eq((String)so_name, (Object)so_value)));
                } else if (SortObject.DIRECTION_ASC.equalsIgnoreCase(so.getDirection())) {
                    c.add((Criterion)Restrictions.lt((String)so_name, (Object)so_value));
                } else {
                    c.add((Criterion)Restrictions.gt((String)so_name, (Object)so_value));
                }
                ++j;
            }
            c.setMaxResults(1);
            List list = c.list();
            index = index + (list.isEmpty() ? 0 : ((Number)list.get(0)).intValue());
            ++i;
        }
        return index;
    }

    private boolean isExpression(String name) {
        return name.contains("+") || name.contains("-") || name.contains("*") || name.contains("/");
    }

    private String getExpresstionPropValue(Object obj, String name) {
        String tmp = name.replaceAll("[()]", "");
        Object[] terms = tmp.split(ARITHMETIC);
        this.logger.debug((Object)("expression terms: " + Arrays.toString(terms)));
        Object[] objectArray = terms;
        int n = terms.length;
        int n2 = 0;
        while (n2 < n) {
            Object term = objectArray[n2];
            Object value = ((String)term).indexOf(".") > 0 ? this.getComplexPropValue(obj, (String)term) : this.getSimplePropValue(obj, (String)term);
            name = name.replaceFirst((String)term, String.valueOf(value));
            ++n2;
        }
        this.logger.debug((Object)("expression value: " + name));
        return name;
    }

    private Object getPropValue(Object obj, String so_name) {
        if (this.isExpression(so_name)) {
            return this.getExpresstionPropValue(obj, so_name);
        }
        if (so_name.indexOf(".") > 0) {
            return this.getComplexPropValue(obj, so_name);
        }
        return this.getSimplePropValue(obj, so_name);
    }

    protected Object getComplexPropValue(Object obj, String name) {
        String[] props;
        String[] stringArray = props = name.split("\\.");
        int n = props.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if ((obj = this.getSimplePropValue(obj, str)) == null) {
                return null;
            }
            ++n2;
        }
        return obj;
    }

    protected Object getSimplePropValue(Object obj, String name) {
        String methodName = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
        Object res = null;
        try {
            Method mtd = obj.getClass().getMethod(methodName, new Class[0]);
            res = mtd.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.logger.debug((Object)("object: " + obj + " property: " + name + " getter name: " + methodName + " value: " + res));
        return res;
    }
}

