/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.db.common;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.ResultTransformer;
import ru.infor.ws.objects.core.SortObject;

public class CriteriaWrapper
implements Criteria {
    private static Logger logger = Logger.getLogger(CriteriaWrapper.class);
    private Criteria criteria;
    private Map<String, Criteria> aliases;

    private CriteriaWrapper(Criteria criteria) {
        this.criteria = criteria;
        this.aliases = new HashMap<String, Criteria>();
    }

    public static CriteriaWrapper getWrapper(Criteria criteria) {
        return criteria instanceof CriteriaWrapper ? (CriteriaWrapper)criteria : new CriteriaWrapper(criteria);
    }

    public Criteria addOrders(SortObject[] sort) {
        if (sort != null && sort.length > 0) {
            SortObject[] sortObjectArray = sort;
            int n = sort.length;
            int n2 = 0;
            while (n2 < n) {
                SortObject so = sortObjectArray[n2];
                String orderBy = so.getName();
                if (so.getName().contains(".")) {
                    orderBy = this.createRequiredJoins(so.getName());
                    int index = so.getName().lastIndexOf(".");
                    orderBy = String.valueOf(orderBy) + so.getName().substring(index);
                }
                logger.debug((Object)("orderBy: " + orderBy));
                Order order = SortObject.DIRECTION_ASC.equalsIgnoreCase(so.getDirection()) ? Order.asc((String)orderBy.trim()) : Order.desc((String)orderBy.trim());
                this.criteria.addOrder(order);
                ++n2;
            }
        }
        this.criteria.addOrder(Order.desc((String)"id"));
        return this.criteria;
    }

    public String createRequiredJoins(String propName) {
        String[] pathes = propName.trim().split("\\.");
        if (pathes == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        CriteriaWrapper cur = this;
        int i = 0;
        while (i < pathes.length - 1) {
            String name = pathes[i].trim();
            if (sb.length() > 0) {
                sb.append("_");
            }
            sb.append(name);
            cur = cur.createCriteria(name, sb.toString(), 1);
            ++i;
        }
        return sb.toString();
    }

    public Criterion buildQuickSearchFilter(String filterValue, String ... names) {
        Disjunction filter = Restrictions.disjunction();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            String f = name = stringArray[n2];
            if (name.contains(".")) {
                f = this.createRequiredJoins(name);
                int index = name.lastIndexOf(".");
                f = String.valueOf(f) + name.substring(index);
            }
            filter.add((Criterion)Restrictions.like((String)f, (Object)filterValue).ignoreCase());
            ++n2;
        }
        return filter;
    }

    public Criteria add(Criterion arg0) {
        return this.criteria.add(arg0);
    }

    public Criteria addOrder(Order arg0) {
        return this.criteria.addOrder(arg0);
    }

    @Deprecated
    public Criteria createAlias(String arg0, String arg1, int arg2) throws HibernateException {
        return CriteriaWrapper.getWrapper(this.criteria.createAlias(arg0, arg1, arg2));
    }

    @Deprecated
    public Criteria createAlias(String arg0, String arg1) throws HibernateException {
        return CriteriaWrapper.getWrapper(this.criteria.createAlias(arg0, arg1));
    }

    public Criteria createCriteria(String arg0, int arg1) throws HibernateException {
        return CriteriaWrapper.getWrapper(this.criteria.createCriteria(arg0, arg1));
    }

    public Criteria createCriteria(String arg0, String arg1, int arg2) throws HibernateException {
        if (!this.aliases.containsKey(arg1)) {
            this.aliases.put(arg1, CriteriaWrapper.getWrapper(this.criteria.createCriteria(arg0, arg1, arg2)));
        }
        return this.aliases.get(arg1);
    }

    public Criteria createCriteria(String arg0, String arg1) throws HibernateException {
        if (!this.aliases.containsKey(arg1)) {
            this.aliases.put(arg1, CriteriaWrapper.getWrapper(this.criteria.createCriteria(arg0, arg1)));
        }
        return this.aliases.get(arg1);
    }

    public Criteria createCriteria(String arg0) throws HibernateException {
        return CriteriaWrapper.getWrapper(this.criteria.createCriteria(arg0));
    }

    public String getAlias() {
        return this.criteria.getAlias();
    }

    public List list() throws HibernateException {
        long time = System.currentTimeMillis();
        List list = this.criteria.list();
        logger.debug((Object)("SQL runs " + String.valueOf(System.currentTimeMillis() - time) + "ms. Criteria: " + this.criteria.toString()));
        return list;
    }

    public String toString() {
        return this.criteria.toString();
    }

    public ScrollableResults scroll() throws HibernateException {
        return this.criteria.scroll();
    }

    public ScrollableResults scroll(ScrollMode arg0) throws HibernateException {
        return this.criteria.scroll(arg0);
    }

    public Criteria setCacheable(boolean arg0) {
        return this.criteria.setCacheable(arg0);
    }

    public Criteria setCacheMode(CacheMode arg0) {
        return this.criteria.setCacheMode(arg0);
    }

    public Criteria setCacheRegion(String arg0) {
        return this.criteria.setCacheRegion(arg0);
    }

    public Criteria setComment(String arg0) {
        return this.criteria.setComment(arg0);
    }

    public Criteria setFetchMode(String arg0, FetchMode arg1) throws HibernateException {
        return this.criteria.setFetchMode(arg0, arg1);
    }

    public Criteria setFetchSize(int arg0) {
        return this.criteria.setFetchSize(arg0);
    }

    public Criteria setFirstResult(int arg0) {
        return this.criteria.setFirstResult(arg0);
    }

    public Criteria setFlushMode(FlushMode arg0) {
        return this.criteria.setFlushMode(arg0);
    }

    public Criteria setLockMode(LockMode arg0) {
        return this.criteria.setLockMode(arg0);
    }

    public Criteria setLockMode(String arg0, LockMode arg1) {
        return this.criteria.setLockMode(arg0, arg1);
    }

    public Criteria setMaxResults(int arg0) {
        return this.criteria.setMaxResults(arg0);
    }

    public Criteria setProjection(Projection arg0) {
        return this.criteria.setProjection(arg0);
    }

    public Criteria setResultTransformer(ResultTransformer arg0) {
        return this.criteria.setResultTransformer(arg0);
    }

    public Criteria setTimeout(int arg0) {
        return this.criteria.setTimeout(arg0);
    }

    public Object uniqueResult() throws HibernateException {
        return this.criteria.uniqueResult();
    }
}

