/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.db.common;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.mapping.PersistentClass;
import ru.infor.db.common.SessionWrapper;
import ru.infor.db.core.SessionInterceptor;
import ru.infor.ws.business.ApplicationException;
import ru.infor.ws.business.core.security.EntityMetaWSO;
import ru.infor.ws.objects.InvocationContext;
import ru.infor.ws.objects.SearchResultList;
import ru.infor.ws.objects.ServerInvocationContext;
import ru.infor.ws.objects.core.EntityMetaSearchCriteria;
import ru.infor.ws.objects.core.entities.EntityFieldMeta;
import ru.infor.ws.objects.core.entities.EntityMeta;

public class HibernateUtils {
    private static SessionFactory sessionFactory;
    private static Configuration config;
    static Logger logger;

    static {
        logger = Logger.getLogger(HibernateUtils.class);
    }

    public static synchronized org.hibernate.Session getSession(SessionInterceptor interceptor) {
        Session session = interceptor == null ? HibernateUtils.getSessionFactory().openSession() : HibernateUtils.getSessionFactory().openSession((Interceptor)interceptor);
        logger.debug((Object)("session = @" + String.valueOf(session.hashCode()) + " has been opened by thread = " + Thread.currentThread().toString()));
        return new SessionWrapper((org.hibernate.Session)session, interceptor);
    }

    public static void closeSessionFactory() throws HibernateException {
        HibernateUtils.getSessionFactory().close();
    }

    private static SessionFactory getSessionFactory() {
        if (sessionFactory == null) {
            try {
                config = new AnnotationConfiguration().configure();
                sessionFactory = config.buildSessionFactory();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new ApplicationException(e.getMessage(), e);
            }
        }
        return sessionFactory;
    }

    public static List<String> getMappedEntities() {
        LinkedList<String> list = new LinkedList<String>();
        HibernateUtils.getSessionFactory();
        Iterator it = config.getClassMappings();
        while (it.hasNext()) {
            PersistentClass pc = (PersistentClass)it.next();
            String className = pc.getClassName();
            list.add(className);
        }
        return list;
    }

    public static Configuration getConfig() {
        return config;
    }

    public static void generateEntityMetaForClass(ServerInvocationContext sic, String className) throws IntrospectionException, ClassNotFoundException {
        EntityMetaWSO metaWSI = new EntityMetaWSO();
        EntityMetaSearchCriteria sc = new EntityMetaSearchCriteria();
        sc.setClassName("*" + className + "*");
        SearchResultList rs = metaWSI.getEntityMetaList((InvocationContext)sic, sc);
        EntityMeta meta = null;
        if (rs.getObjList() == null || rs.getObjList().length == 0) {
            meta = new EntityMeta();
            meta.setClassName(className);
            meta.setActive(0);
            meta.setTitle(className.substring(className.lastIndexOf(".") + 1));
        } else {
            meta = (EntityMeta)rs.getObjList()[0];
        }
        PropertyDescriptor[] props = Introspector.getBeanInfo(Class.forName(className)).getPropertyDescriptors();
        ArrayList<EntityFieldMeta> fldMetas = new ArrayList<EntityFieldMeta>(props.length);
        PropertyDescriptor[] propertyDescriptorArray = props;
        int n = props.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            if (!pd.getName().equals("class") && pd.getReadMethod() != null) {
                EntityFieldMeta fieldMeta = new EntityFieldMeta();
                fieldMeta.setName(pd.getName());
                if (pd.getWriteMethod() == null) {
                    fieldMeta.setIsReadOnly(EntityFieldMeta.READ_ONLY);
                }
                fldMetas.add(fieldMeta);
            }
            ++n2;
        }
        meta.setFieldMetas(fldMetas.toArray(new EntityFieldMeta[0]));
        meta = metaWSI.saveEntityMeta((InvocationContext)sic, meta);
    }

    public static void fillEntitiesUIList(ServerInvocationContext sic, Class<?> ... clazzs) {
        Class<?>[] classArray = clazzs;
        int n = clazzs.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            String className = clazz.getName();
            try {
                HibernateUtils.generateEntityMetaForClass(sic, className);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                logger.error((Object)("fails to save meta for UI class: name = " + className));
            }
            ++n2;
        }
    }
}

