/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.db.common;

import java.io.Serializable;
import java.sql.Connection;
import org.apache.log4j.Logger;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.ReplicationMode;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.stat.SessionStatistics;
import ru.infor.db.core.SessionInterceptor;

public class SessionWrapper
implements Session {
    private static final Logger logger = Logger.getLogger(SessionWrapper.class);
    private static final long serialVersionUID = -4936520075340290316L;
    private Session session;
    private SessionInterceptor interceptor;
    private boolean transactionBegan = false;

    public SessionWrapper(Session session, SessionInterceptor interceptor) {
        this.session = session;
        this.interceptor = interceptor;
    }

    private Session getSession() {
        if (!this.session.isOpen()) {
            logger.warn((Object)("session = @" + String.valueOf(this.session.hashCode()) + " isClosed = " + !this.session.isOpen()));
        }
        return this.session;
    }

    public Transaction beginTransaction() throws HibernateException {
        this.transactionBegan = true;
        return this.getSession().beginTransaction();
    }

    public void cancelQuery() throws HibernateException {
        this.getSession().cancelQuery();
    }

    public void clear() {
        this.getSession().clear();
    }

    public Connection close() throws HibernateException {
        logger.debug((Object)("session = @" + String.valueOf(this.session.hashCode()) + " has been closed by thread = " + Thread.currentThread().toString()));
        if (this.interceptor != null) {
            this.interceptor.closeSession();
        }
        this.getSession().flush();
        return this.getSession().close();
    }

    public Connection connection() throws HibernateException {
        return this.getSession().connection();
    }

    public boolean contains(Object arg0) {
        return this.getSession().contains(arg0);
    }

    public Criteria createCriteria(Class arg0) {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        return this.getSession().createCriteria(arg0);
    }

    public Criteria createCriteria(String arg0) {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        return this.getSession().createCriteria(arg0);
    }

    public Criteria createCriteria(Class arg0, String arg1) {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        return this.getSession().createCriteria(arg0, arg1);
    }

    public Criteria createCriteria(String arg0, String arg1) {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        return this.getSession().createCriteria(arg0, arg1);
    }

    public Query createFilter(Object arg0, String arg1) throws HibernateException {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        return this.getSession().createFilter(arg0, arg1);
    }

    public Query createQuery(String arg0) throws HibernateException {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        logger.debug((Object)("query.hql: " + arg0));
        return this.getSession().createQuery(arg0);
    }

    public SQLQuery createSQLQuery(String arg0) throws HibernateException {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        logger.debug((Object)("query.sql: " + arg0));
        return this.getSession().createSQLQuery(arg0);
    }

    public void delete(Object arg0) throws HibernateException {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        this.getSession().delete(arg0);
    }

    public void delete(String arg0, Object arg1) throws HibernateException {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        this.getSession().delete(arg0, arg1);
    }

    public void disableFilter(String arg0) {
        this.getSession().disableFilter(arg0);
    }

    public Connection disconnect() throws HibernateException {
        return this.getSession().disconnect();
    }

    public Filter enableFilter(String arg0) {
        return this.getSession().enableFilter(arg0);
    }

    public void evict(Object arg0) throws HibernateException {
        this.getSession().evict(arg0);
    }

    public void flush() throws HibernateException {
        this.getSession().flush();
    }

    public Object get(Class arg0, Serializable arg1) throws HibernateException {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        return this.getSession().get(arg0, arg1);
    }

    public Object get(String arg0, Serializable arg1) throws HibernateException {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        return this.getSession().get(arg0, arg1);
    }

    public Object get(Class arg0, Serializable arg1, LockMode arg2) throws HibernateException {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        return this.getSession().get(arg0, arg1, arg2);
    }

    public Object get(String arg0, Serializable arg1, LockMode arg2) throws HibernateException {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        return this.getSession().get(arg0, arg1, arg2);
    }

    public CacheMode getCacheMode() {
        return this.getSession().getCacheMode();
    }

    public LockMode getCurrentLockMode(Object arg0) throws HibernateException {
        return this.getSession().getCurrentLockMode(arg0);
    }

    public Filter getEnabledFilter(String arg0) {
        return this.getSession().getEnabledFilter(arg0);
    }

    public EntityMode getEntityMode() {
        return this.getSession().getEntityMode();
    }

    public String getEntityName(Object arg0) throws HibernateException {
        return this.getSession().getEntityName(arg0);
    }

    public FlushMode getFlushMode() {
        return this.getSession().getFlushMode();
    }

    public Serializable getIdentifier(Object arg0) throws HibernateException {
        return this.getSession().getIdentifier(arg0);
    }

    public Query getNamedQuery(String arg0) throws HibernateException {
        return this.getSession().getNamedQuery(arg0);
    }

    public Session getSession(EntityMode arg0) {
        return this.getSession().getSession(arg0);
    }

    public SessionFactory getSessionFactory() {
        return this.getSession().getSessionFactory();
    }

    public SessionStatistics getStatistics() {
        return this.getSession().getStatistics();
    }

    public Transaction getTransaction() {
        return this.getSession().getTransaction();
    }

    public boolean isConnected() {
        return this.getSession().isConnected();
    }

    public boolean isDirty() throws HibernateException {
        return this.getSession().isDirty();
    }

    public boolean isOpen() {
        return this.getSession().isOpen();
    }

    public Object load(Class arg0, Serializable arg1) throws HibernateException {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        return this.getSession().load(arg0, arg1);
    }

    public Object load(String arg0, Serializable arg1) throws HibernateException {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        return this.getSession().load(arg0, arg1);
    }

    public void load(Object arg0, Serializable arg1) throws HibernateException {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        this.getSession().load(arg0, arg1);
    }

    public Object load(Class arg0, Serializable arg1, LockMode arg2) throws HibernateException {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        return this.getSession().load(arg0, arg1, arg2);
    }

    public Object load(String arg0, Serializable arg1, LockMode arg2) throws HibernateException {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        return this.getSession().load(arg0, arg1, arg2);
    }

    public void lock(Object arg0, LockMode arg1) throws HibernateException {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        this.getSession().lock(arg0, arg1);
    }

    public void lock(String arg0, Object arg1, LockMode arg2) throws HibernateException {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        this.getSession().lock(arg0, arg1, arg2);
    }

    public Object merge(Object arg0) throws HibernateException {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        return this.getSession().merge(arg0);
    }

    public Object merge(String arg0, Object arg1) throws HibernateException {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        return this.getSession().merge(arg0, arg1);
    }

    public void persist(Object arg0) throws HibernateException {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        this.getSession().persist(arg0);
    }

    public void persist(String arg0, Object arg1) throws HibernateException {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        this.getSession().persist(arg0, arg1);
    }

    public void reconnect() throws HibernateException {
        this.getSession().reconnect();
    }

    public void reconnect(Connection arg0) throws HibernateException {
        this.getSession().reconnect(arg0);
    }

    public void refresh(Object arg0) throws HibernateException {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        this.getSession().refresh(arg0);
    }

    public void refresh(Object arg0, LockMode arg1) throws HibernateException {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        this.getSession().refresh(arg0, arg1);
    }

    public void replicate(Object arg0, ReplicationMode arg1) throws HibernateException {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        this.getSession().replicate(arg0, arg1);
    }

    public void replicate(String arg0, Object arg1, ReplicationMode arg2) throws HibernateException {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        this.getSession().replicate(arg0, arg1, arg2);
    }

    public Serializable save(Object arg0) throws HibernateException {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        return this.getSession().save(arg0);
    }

    public Serializable save(String arg0, Object arg1) throws HibernateException {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        return this.getSession().save(arg0, arg1);
    }

    public void saveOrUpdate(Object arg0) throws HibernateException {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        this.getSession().saveOrUpdate(arg0);
    }

    public void saveOrUpdate(String arg0, Object arg1) throws HibernateException {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        this.getSession().saveOrUpdate(arg0, arg1);
    }

    public void setCacheMode(CacheMode arg0) {
        this.getSession().setCacheMode(arg0);
    }

    public void setFlushMode(FlushMode arg0) {
        this.getSession().setFlushMode(arg0);
    }

    public void setReadOnly(Object arg0, boolean arg1) {
        this.getSession().setReadOnly(arg0, arg1);
    }

    public void update(Object arg0) throws HibernateException {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        this.getSession().update(arg0);
    }

    public void update(String arg0, Object arg1) throws HibernateException {
        if (!this.transactionBegan) {
            logger.error((Object)"No transaction started.", (Throwable)new Exception());
        }
        this.getSession().update(arg0, arg1);
    }
}

