/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.ws.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import ru.infor.ws.objects.core.SortObject;
import ru.infor.ws.proxy.interfaces.ISearchCriteria;

public abstract class CommonSearchCriteria
implements ISearchCriteria {
    public static final String DATA_FORMAT_JSON = "json";
    public static final String DATA_FORMAT_OBJECT = "object";
    public static final Integer LOAD_WITH_CURRENT_OBJECT = 1;
    private Integer beginIndex = 0;
    private Integer count = 20;
    private SortObject[] listSort;
    private String quickSearch;
    private int loadDeletedItems = 0;
    private Long[] idList;
    private String dataFormat;
    private Date createdDateTimeFrom;
    private Date createdDateTimeTill;
    private Date changedDateTimeFrom;
    private Date changedDateTimeTill;
    private String fieldName;
    private String[] fieldValues;

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String[] getFieldValues() {
        return this.fieldValues;
    }

    public void setFieldValues(String[] fieldValues) {
        this.fieldValues = fieldValues;
    }

    public Date getCreatedDateTimeFrom() {
        return this.createdDateTimeFrom;
    }

    public void setCreatedDateTimeFrom(Date createdDateTimeFrom) {
        this.createdDateTimeFrom = createdDateTimeFrom;
    }

    public Date getCreatedDateTimeTill() {
        return this.createdDateTimeTill;
    }

    public void setCreatedDateTimeTill(Date createdDateTimeTill) {
        this.createdDateTimeTill = createdDateTimeTill;
    }

    public Date getChangedDateTimeFrom() {
        return this.changedDateTimeFrom;
    }

    public void setChangedDateTimeFrom(Date changedDateTimeFrom) {
        this.changedDateTimeFrom = changedDateTimeFrom;
    }

    public Date getChangedDateTimeTill() {
        return this.changedDateTimeTill;
    }

    public void setChangedDateTimeTill(Date changedDateTimeTill) {
        this.changedDateTimeTill = changedDateTimeTill;
    }

    public int getLoadDeletedItems() {
        return this.loadDeletedItems;
    }

    public Long[] getIdList() {
        return this.idList;
    }

    public void setIdList(Long[] idList) {
        this.idList = idList;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
    }

    public void setLoadDeletedItems(int loadDeletedItems) {
        this.loadDeletedItems = loadDeletedItems;
    }

    public SortObject[] getListSort() {
        return this.listSort;
    }

    public void setListSort(SortObject[] listSort) {
        this.listSort = listSort;
    }

    public CommonSearchCriteria appendSorting(SortObject so) {
        SortObject[] current = this.listSort == null ? new SortObject[]{} : this.listSort;
        ArrayList<SortObject> list = new ArrayList<SortObject>(Arrays.asList(current));
        list.add(so);
        current = list.toArray(new SortObject[0]);
        this.listSort = current;
        return this;
    }

    @Override
    public Integer getBeginIndex() {
        return this.beginIndex;
    }

    @Override
    public void setBeginIndex(Integer beginIndex) {
        this.beginIndex = beginIndex;
    }

    @Override
    public Integer getCount() {
        return this.count;
    }

    @Override
    public void setCount(Integer count) {
        this.count = count;
    }

    public static Date beginOfDay(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new Date(calendar.getTime().getTime());
    }

    public static Date middleOfDay(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 12);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new Date(calendar.getTime().getTime());
    }

    public static Date endOfDay(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 99);
        return new Date(calendar.getTime().getTime());
    }

    public static Date firstDayOfWeek(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(7, 2);
        return CommonSearchCriteria.beginOfDay(calendar.getTime());
    }

    public static Date lastDayOfWeek(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(CommonSearchCriteria.firstDayOfWeek(date));
        calendar.add(5, 6);
        return CommonSearchCriteria.endOfDay(calendar.getTime());
    }

    public static Date firstDayOfMonth(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        return CommonSearchCriteria.beginOfDay(calendar.getTime());
    }

    public static Date lastDayOfMonth(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        return CommonSearchCriteria.endOfDay(calendar.getTime());
    }

    public static Date firstDayOfYear(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, 0);
        return CommonSearchCriteria.firstDayOfMonth(calendar.getTime());
    }

    public static Date lastDayOfYear(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, 11);
        return CommonSearchCriteria.lastDayOfMonth(calendar.getTime());
    }

    public String getQuickSearch() {
        return this.quickSearch;
    }

    public void setQuickSearch(String quickSearch) {
        this.quickSearch = quickSearch;
    }
}

