/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.ws.objects.core;

import java.io.Serializable;
import java.util.Date;
import org.apache.log4j.Logger;
import ru.infor.ws.objects.core.ReportParameterArrayOfLong;
import ru.infor.ws.objects.core.ReportParameterDate;
import ru.infor.ws.objects.core.ReportParameterLong;
import ru.infor.ws.objects.core.ReportParameterString;

public abstract class ReportParameter<T>
implements Serializable {
    private static final long serialVersionUID = -5625005419418789218L;
    protected static final Logger logger = Logger.getLogger(ReportParameter.class);
    private String name;
    private T value;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public T retrieveValue() {
        return this.value;
    }

    protected void writeValue(T value) {
        this.value = value;
    }

    protected abstract String getValueAsString_();

    protected abstract void setValueAsString_(String var1);

    public String getValueAsString() {
        return this.getValueAsString_();
    }

    public void setValueAsString(String value) {
        this.setValueAsString_(value);
    }

    public String toString() {
        return "ReportParameter {name = " + this.name + ", type = " + this.getClass().getSimpleName() + ", valueAsString = " + this.getValueAsString() + "}";
    }

    public static ReportParameter<String> fromString(String name, String str) {
        return new ReportParameterString(name, str);
    }

    public static ReportParameter<Date> fromDate(String name, Date date) {
        return new ReportParameterDate(name, date);
    }

    public static ReportParameter<Long> fromLong(String name, Long l) {
        return new ReportParameterLong(name, l);
    }

    public static ReportParameter<Long[]> fromLongArray(String name, Long[] l) {
        return new ReportParameterArrayOfLong(name, l);
    }
}

