/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.ws.objects.core;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class UIModuleParameters
extends HashMap<String, String> {
    public static final String PARAMETER_SEPARATOR = ";#;";
    public static final String VALUE_SEPARATOR = "=#=";
    private static final long serialVersionUID = -7982749011384573328L;
    private static final Logger logger = Logger.getLogger(UIModuleParameters.class);

    private UIModuleParameters() {
    }

    public Long getLong(String key, Long defaultValue) {
        String val = (String)this.get(key);
        try {
            return Long.valueOf(val);
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    public String toHibernateString() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry e : this.entrySet()) {
            sb.append((String)e.getKey()).append(VALUE_SEPARATOR).append((String)e.getValue()).append(PARAMETER_SEPARATOR);
        }
        return sb.substring(0, sb.length() - PARAMETER_SEPARATOR.length());
    }

    public static UIModuleParameters getInstance(String parameters) {
        String[] paramsList;
        UIModuleParameters res = new UIModuleParameters();
        if (parameters == null) {
            return res;
        }
        String[] stringArray = paramsList = parameters.split(PARAMETER_SEPARATOR);
        int n = paramsList.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            String[] lst = param.split(VALUE_SEPARATOR);
            if (lst.length != 2) {
                logger.warn((Object)("invalid parameter description: " + param));
            } else {
                res.put(lst[0].trim(), lst[1].trim());
            }
            ++n2;
        }
        return res;
    }

    public static void main(String[] args) {
        File file = new File("log4j.properties");
        if (file.exists()) {
            PropertyConfigurator.configure((String)file.getAbsolutePath());
        }
        UIModuleParameters parameters = UIModuleParameters.getInstance("a=123;b=dfdjskdff dsldkf dsd; c=;d;er=fgf=sdss;");
        parameters.put("ddd", "3232323");
        System.out.println(parameters.toHibernateString());
    }
}

