/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.ws.objects.core.entities;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import ru.infor.ws.objects.core.entities.LowlevelEntity;
import ru.infor.ws.objects.core.entities.User;

@Entity
public class EventLog
extends LowlevelEntity {
    private static final long serialVersionUID = -6724171831585196403L;
    private Long id;
    private Date date;
    private String userName;
    private String classInit;
    private String event;
    private String remoteHost;

    public static EventLog getInstance(Date date, User user, String classInit, String event) {
        EventLog log = new EventLog();
        log.setDate(date);
        log.setClassInit(classInit);
        log.setEvent(event);
        log.setUserName(String.valueOf(user.getLastName()) + " " + user.getFirstName());
        return log;
    }

    public static EventLog getInstance(Date date, String userName, String classInit, String event) {
        EventLog log = new EventLog();
        log.setDate(date);
        log.setClassInit(classInit);
        log.setEvent(event);
        log.setUserName(userName);
        return log;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="log_date")
    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getClassInit() {
        return this.classInit;
    }

    public void setClassInit(String classInit) {
        this.classInit = classInit;
    }

    @Column(name="log_event", length=6144)
    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public boolean equals(Object obj) {
        EventLog log;
        boolean res = super.equals(obj);
        if (res) {
            return true;
        }
        if (obj instanceof EventLog && (log = (EventLog)obj).getId() != null && this.getId() != null) {
            return log.getId().equals(this.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId() == null ? 0 : this.getId().intValue();
    }

    public String toString() {
        return "EventLog {id = " + this.id + ", date = " + this.date + ", userName = " + this.userName + ", classInit = " + this.classInit + ", event = " + this.event + "}";
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }
}

