/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.ws.objects.core.entities;

import javax.persistence.Entity;
import javax.persistence.Transient;
import ru.infor.ws.objects.core.entities.IntegrationTuningField;
import ru.infor.ws.objects.core.entities.TuningEntity;

@Entity
public class IntegrationTuning
extends TuningEntity {
    private static final long serialVersionUID = -1487295294836470578L;
    public static final Integer IMPORT_TYPE = 1;
    public static final Integer EXPORT_TYPE = 2;
    public static final Integer DOS_TYPE = 1;
    public static final Integer WIN_TYPE = 2;
    private Integer typeIntegration = 0;
    private Integer typeCode = 0;
    private String pathToFile;
    private String fileNameMask;
    private String classNameIntegration;
    private Long topId;
    private String separator;
    private IntegrationTuningField[] fields;

    @Transient
    public IntegrationTuningField[] getFields() {
        return this.fields;
    }

    public void setFields(IntegrationTuningField[] fields) {
        this.fields = fields;
    }

    public Integer getTypeIntegration() {
        return this.typeIntegration;
    }

    public void setTypeIntegration(Integer typeIntegration) {
        this.typeIntegration = typeIntegration;
    }

    public Integer getTypeCode() {
        return this.typeCode;
    }

    public void setTypeCode(Integer typeCode) {
        this.typeCode = typeCode;
    }

    public String getPathToFile() {
        return this.pathToFile;
    }

    public void setPathToFile(String pathToFile) {
        this.pathToFile = pathToFile;
    }

    public String getFileNameMask() {
        return this.fileNameMask;
    }

    public void setFileNameMask(String fileNameMask) {
        this.fileNameMask = fileNameMask;
    }

    public String getClassNameIntegration() {
        return this.classNameIntegration;
    }

    public void setClassNameIntegration(String classNameIntegration) {
        this.classNameIntegration = classNameIntegration;
    }

    public Long getTopId() {
        return this.topId;
    }

    public void setTopId(Long topId) {
        this.topId = topId;
    }

    @Transient
    public String toString() {
        return "IntegrationTuning {id = " + this.getId() + ", type = " + IntegrationTuning.typeIntegrationToString(this.getTypeIntegration()) + ", name = " + this.getName() + ", className = " + this.getClassName() + ", fileNameMask = " + this.getFileNameMask() + "}";
    }

    public static String typeIntegrationToString(Integer type) {
        if (IMPORT_TYPE.equals(type)) {
            return "\u0420\u0451\u0420\u0458\u0420\u0457\u0420\u0455\u0421\u0402\u0421\u201a";
        }
        if (EXPORT_TYPE.equals(type)) {
            return "\u0421\u040c\u0420\u0454\u0421\u0403\u0420\u0457\u0420\u0455\u0421\u0402\u0421\u201a";
        }
        return "<\u0420\u0405\u0420\u00b5\u0420\u0451\u0420\u00b7\u0420\u0406\u0420\u00b5\u0421\u0403\u0421\u201a\u0420\u0405\u0421\u2039\u0420\u2116 \u0421\u201a\u0420\u0451\u0420\u0457>";
    }

    public static String typeCodeToString(Integer type) {
        if (DOS_TYPE.equals(type)) {
            return "CP866";
        }
        if (WIN_TYPE.equals(type)) {
            return "CP1251";
        }
        return "CP866";
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }
}

