/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.ws.objects.core.entities;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Transient;
import ru.infor.ws.objects.core.entities.ChangerInfoThin;
import ru.infor.ws.objects.core.entities.LowlevelEntity;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
public class RightsOwner
extends LowlevelEntity
implements ChangerInfoThin {
    private static final long serialVersionUID = 7288834156533420218L;
    public static final Integer GROUP_TYPE = 1;
    public static final Integer USER_TYPE = 2;
    private Long id;
    private String name;
    private Integer type = 0;
    private String allowedIPs;
    private Long createdById;
    private Date createdDateTime;
    private Long changedById;
    private Date changedDateTime;

    @Override
    @Transient
    public boolean isStored() {
        return this.getId() != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof RightsOwner) {
            RightsOwner ro = (RightsOwner)obj;
            if (this.getId() != null && ro.getId() != null) {
                return this.getId().equals(ro.getId());
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getId() == null ? 0 : this.getId().intValue();
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String toString() {
        return "RightsOwner {id = " + this.id + ", name = " + this.name + ", type = " + RightsOwner.typeToString(this.type) + "}";
    }

    public static String typeToString(Integer type) {
        if (USER_TYPE.equals(type)) {
            return "User";
        }
        if (GROUP_TYPE.equals(type)) {
            return "Group";
        }
        return "Unknown";
    }

    @Column(length=2048)
    public String getAllowedIPs() {
        return this.allowedIPs;
    }

    public void setAllowedIPs(String allowedIPs) {
        this.allowedIPs = allowedIPs;
    }

    @Override
    @Column(name="createdBy_id")
    public Long getCreatedById() {
        return this.createdById;
    }

    @Override
    public void setCreatedById(Long createdById) {
        this.createdById = createdById;
    }

    @Override
    public Date getCreatedDateTime() {
        return this.createdDateTime;
    }

    @Override
    public void setCreatedDateTime(Date createdDateTime) {
        this.createdDateTime = createdDateTime;
    }

    @Override
    @Column(name="changedBy_id")
    public Long getChangedById() {
        return this.changedById;
    }

    @Override
    public void setChangedById(Long changedById) {
        this.changedById = changedById;
    }

    @Override
    public Date getChangedDateTime() {
        return this.changedDateTime;
    }

    @Override
    public void setChangedDateTime(Date changedDateTime) {
        this.changedDateTime = changedDateTime;
    }
}

