/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit;

import io.advantageous.boon.core.reflection.ClassMeta;
import io.advantageous.qbit.Factory;
import io.advantageous.qbit.spi.FactorySPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QBit {
    private final Logger logger = LoggerFactory.getLogger(QBit.class);
    private final boolean debug = this.logger.isDebugEnabled();

    public static Factory factory() {
        return new QBit().doGetFactory();
    }

    public Factory doGetFactory() {
        Factory factory = FactorySPI.getFactory();
        if (factory == null) {
            if (this.debug) {
                this.logger.debug("Factory was null");
            }
            this.registerReflectionAndJsonParser();
            this.registerNetworkStack();
            return FactorySPI.getFactory();
        }
        return factory;
    }

    private void registerReflectionAndJsonParser() {
        try {
            Class<?> boonFactory = Class.forName("io.advantageous.qbit.boon.spi.RegisterBoonWithQBit");
            ClassMeta.classMeta(boonFactory).invokeStatic("registerBoonWithQBit", new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Could not find reflection lib or JSON parser");
        }
    }

    private void registerNetworkStack() {
        try {
            try {
                Class<?> vertxFactory = Class.forName("io.advantageous.qbit.vertx.RegisterVertxWithQBit");
                ClassMeta.classMeta(vertxFactory).invokeStatic("registerVertxWithQBit", new Object[0]);
            }
            catch (Exception ex) {
                if (this.debug) {
                    System.out.println("Unable to load vertx network stack, trying Jetty" + ex);
                }
            }
        }
        catch (Exception ex) {
            FactorySPI.setHttpServerFactory((options, name, systemManager, serviceDiscovery, healthServiceAsync, a, b, c, d) -> {
                throw new IllegalStateException("Unable to load Vertx network libs");
            });
            FactorySPI.setHttpClientFactory((host, port, timeOutInMilliseconds, poolSize, autoFlush, flushRate, keepAlive, pipeLine, ssl, verifyHost, trustAll, maxWebSocketFrameSize, tryUseCompression, trustStorePath, trustStorePassword, tcpNoDelay, soLinger) -> {
                throw new IllegalStateException("Unable to load Vertx network libs");
            });
        }
    }
}

