/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.annotation;

import io.advantageous.boon.core.Str;
import io.advantageous.boon.core.Sys;
import io.advantageous.boon.core.reflection.Annotated;
import io.advantageous.boon.core.reflection.AnnotationData;
import io.advantageous.boon.core.reflection.ClassMeta;
import io.advantageous.boon.core.reflection.MethodAccess;

public class AnnotationUtils {
    public static final String EVENT_CHANNEL_ANNOTATION_NAME = Sys.sysProp((String)"io.advantageous.qbit.events.EventBusProxyCreator.eventChannelName", (Object)"EventChannel");

    public static AnnotationData getListenAnnotation(MethodAccess methodAccess) {
        AnnotationData listen = methodAccess.annotation("Listen");
        if (listen == null) {
            listen = methodAccess.annotation("OnEvent");
        }
        if (listen == null) {
            listen = methodAccess.annotation("Subscribe");
        }
        if (listen == null) {
            listen = methodAccess.annotation("Consume");
        }
        if (listen == null) {
            listen = methodAccess.annotation("Hear");
        }
        return listen;
    }

    public static String readServiceName(Object annotated) {
        ClassMeta classMeta = ClassMeta.classMeta(annotated.getClass());
        String name = AnnotationUtils.readServiceName((Annotated)classMeta);
        if (name == null || name.isEmpty()) {
            return annotated.getClass().getSimpleName();
        }
        return name;
    }

    public static String readServiceName(Annotated annotated) {
        String name = AnnotationUtils.readValue("Service", annotated);
        if (Str.isEmpty((String)name)) {
            name = AnnotationUtils.readValue("ServiceName", annotated);
        }
        if (Str.isEmpty((String)name)) {
            name = AnnotationUtils.readValue("Named", annotated);
        }
        if (Str.isEmpty((String)name)) {
            name = AnnotationUtils.readValue("Name", annotated);
        }
        return name == null ? "" : name;
    }

    private static String readValue(String name, Annotated annotated) {
        AnnotationData requestMapping = annotated.annotation(name);
        if (requestMapping != null) {
            Object value = requestMapping.getValues().get("value");
            if (value instanceof String[]) {
                String[] values = (String[])value;
                if (values.length > 0 && values[0] != null && !values[0].isEmpty()) {
                    return values[0];
                }
            } else {
                return (String)value;
            }
        }
        return null;
    }

    public static <T> String getClassEventChannelName(ClassMeta<T> classMeta, AnnotationData classAnnotation) {
        String classEventBusName;
        String string = classEventBusName = classAnnotation != null && classAnnotation.getValues().get("value") != null ? classAnnotation.getValues().get("value").toString() : null;
        if (Str.isEmpty(classEventBusName) && classAnnotation != null) {
            classEventBusName = classMeta.longName();
        }
        return classEventBusName;
    }

    public static String createChannelName(String channelPrefix, String classChannelNamePart, String methodChannelNamePart) {
        if (methodChannelNamePart == null) {
            throw new IllegalArgumentException("Each method must have an event bus channel name");
        }
        if (channelPrefix == null) {
            if (classChannelNamePart == null) {
                return methodChannelNamePart;
            }
            return Str.join((char)'.', (String[])new String[]{classChannelNamePart, methodChannelNamePart});
        }
        if (classChannelNamePart == null) {
            return Str.join((char)'.', (String[])new String[]{channelPrefix, methodChannelNamePart});
        }
        return Str.join((char)'.', (String[])new String[]{channelPrefix, classChannelNamePart, methodChannelNamePart});
    }
}

