/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.bindings;

import io.advantageous.qbit.bindings.ArgParamURIPositionBinding;
import io.advantageous.qbit.bindings.RequestParamBinding;
import java.util.ArrayList;
import java.util.List;

public class MethodBinding {
    private final boolean hasURIParams;
    private final String methodName;
    private final String method;
    private final String address;
    private final List<ArgParamURIPositionBinding> parameters = new ArrayList<ArgParamURIPositionBinding>();
    private final List<RequestParamBinding> requestParamBindings = new ArrayList<RequestParamBinding>();
    private RequestParamBinding[] requestParamBindingsMap;

    public MethodBinding(String method, String methodName, String uri) {
        int end;
        this.methodName = methodName;
        this.method = method;
        String[] split = uri.split("/");
        boolean found = false;
        int indexOfFirstParam = -1;
        int index = 0;
        for (String item : split) {
            if (item.startsWith("{") && item.endsWith("}")) {
                if (indexOfFirstParam == -1) {
                    indexOfFirstParam = index;
                }
                found = true;
                ArgParamURIPositionBinding binding = (item = item.substring(1, item.length() - 1)).matches("\\d+") ? new ArgParamURIPositionBinding(Integer.parseInt(item), index, "") : new ArgParamURIPositionBinding(-1, index, item);
                this.parameters.add(binding);
            }
            ++index;
        }
        this.address = indexOfFirstParam != -1 ? uri.substring(0, (end = uri.indexOf(123)) > -1 ? end : uri.length()) : uri;
        this.hasURIParams = found;
    }

    public String methodName() {
        return this.methodName;
    }

    public String method() {
        return this.method;
    }

    public String address() {
        return this.address;
    }

    public List<ArgParamURIPositionBinding> parameters() {
        return this.parameters;
    }

    public String toString() {
        return "MethodBinding{hasURIParams=" + this.hasURIParams + ", methodName='" + this.methodName + '\'' + ", method='" + this.methodName + '\'' + ", address='" + this.address + '\'' + ", parameters=" + this.parameters + '}';
    }

    public void addRequestParamBinding(int length, int index, String pathVarName, boolean required, String defaultValue) {
        if (this.requestParamBindingsMap == null) {
            this.requestParamBindingsMap = new RequestParamBinding[length];
        }
        RequestParamBinding paramBinding = new RequestParamBinding(pathVarName, index, required, defaultValue);
        this.requestParamBindings.add(paramBinding);
        this.requestParamBindingsMap[index] = paramBinding;
    }

    public RequestParamBinding requestParamBinding(int index) {
        return this.requestParamBindingsMap[index];
    }

    public boolean hasRequestParamBindings() {
        return this.requestParamBindings.size() > 0;
    }
}

