/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.boon;

import io.advantageous.qbit.Factory;
import io.advantageous.qbit.boon.events.impl.BoonEventBusProxyCreator;
import io.advantageous.qbit.boon.service.impl.BoonServiceMethodCallHandler;
import io.advantageous.qbit.boon.service.impl.BoonServiceProxyFactory;
import io.advantageous.qbit.boon.spi.BoonJsonMapper;
import io.advantageous.qbit.boon.spi.BoonProtocolEncoder;
import io.advantageous.qbit.boon.spi.BoonProtocolParser;
import io.advantageous.qbit.client.Client;
import io.advantageous.qbit.client.ServiceProxyFactory;
import io.advantageous.qbit.concurrent.PeriodicScheduler;
import io.advantageous.qbit.events.EventBusProxyCreator;
import io.advantageous.qbit.events.EventManager;
import io.advantageous.qbit.events.EventManagerBuilder;
import io.advantageous.qbit.http.HttpTransport;
import io.advantageous.qbit.http.client.HttpClient;
import io.advantageous.qbit.json.JsonMapper;
import io.advantageous.qbit.message.MethodCall;
import io.advantageous.qbit.message.MethodCallBuilder;
import io.advantageous.qbit.message.Request;
import io.advantageous.qbit.queue.QueueBuilder;
import io.advantageous.qbit.sender.Sender;
import io.advantageous.qbit.sender.SenderEndPoint;
import io.advantageous.qbit.server.ServiceEndpointServer;
import io.advantageous.qbit.server.ServiceEndpointServerImpl;
import io.advantageous.qbit.service.BeforeMethodCall;
import io.advantageous.qbit.service.ServiceBuilder;
import io.advantageous.qbit.service.ServiceBundle;
import io.advantageous.qbit.service.ServiceMethodHandler;
import io.advantageous.qbit.service.ServiceQueue;
import io.advantageous.qbit.service.discovery.ServiceDiscovery;
import io.advantageous.qbit.service.health.HealthServiceAsync;
import io.advantageous.qbit.service.impl.CallbackManager;
import io.advantageous.qbit.service.impl.ServiceBundleImpl;
import io.advantageous.qbit.service.stats.StatsCollector;
import io.advantageous.qbit.spi.FactorySPI;
import io.advantageous.qbit.spi.ProtocolEncoder;
import io.advantageous.qbit.spi.ProtocolParser;
import io.advantageous.qbit.system.QBitSystemManager;
import io.advantageous.qbit.transforms.Transformer;
import io.advantageous.qbit.util.MultiMap;
import io.advantageous.qbit.util.Timer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoonQBitFactory
implements Factory {
    private final Logger logger = LoggerFactory.getLogger(BoonQBitFactory.class);
    private final AtomicReference<ServiceQueue> systemEventManager = new AtomicReference();
    private final ThreadLocal<EventManager> eventManagerThreadLocal = new ThreadLocal();
    private final ProtocolParser defaultProtocol = new BoonProtocolParser();
    private final ServiceProxyFactory serviceProxyFactory = new BoonServiceProxyFactory(this);
    private final ServiceProxyFactory remoteServiceProxyFactory = new BoonServiceProxyFactory(this);
    private final ThreadLocal<List<ProtocolParser>> protocolParserListRef = new ThreadLocal<List<ProtocolParser>>(){

        @Override
        protected List<ProtocolParser> initialValue() {
            ArrayList<ProtocolParser> list = new ArrayList<ProtocolParser>();
            list.add(BoonQBitFactory.this.createProtocolParser());
            return list;
        }
    };
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(4, r -> {
        Thread thread = new Thread(r);
        thread.setDaemon(true);
        thread.setName("PeriodicTasks");
        return thread;
    });

    @Override
    public PeriodicScheduler periodicScheduler() {
        return (runnable, interval, timeUnit) -> this.scheduledExecutorService.scheduleAtFixedRate(runnable, interval, interval, timeUnit);
    }

    @Override
    public PeriodicScheduler createPeriodicScheduler(int poolSize) {
        final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(poolSize, r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("PeriodicTasks");
            return thread;
        });
        return new PeriodicScheduler(){

            @Override
            public ScheduledFuture repeat(Runnable runnable, int interval, TimeUnit timeUnit) {
                return scheduledExecutorService.scheduleAtFixedRate(runnable, interval, interval, timeUnit);
            }

            @Override
            public void start() {
            }

            @Override
            public void stop() {
                scheduledExecutorService.shutdown();
            }
        };
    }

    @Override
    public EventManager systemEventManager() {
        EventManager proxy;
        EventManager eventManager = this.eventManagerThreadLocal.get();
        if (eventManager != null) {
            return eventManager;
        }
        if (this.systemEventManager.get() == null) {
            ServiceQueue serviceQueue = ServiceBuilder.serviceBuilder().setInvokeDynamic(false).setServiceObject(EventManagerBuilder.eventManagerBuilder().setName("QBIT_SYSTEM").build()).build().startServiceQueue();
            this.systemEventManager.set(serviceQueue);
            proxy = serviceQueue.createProxyWithAutoFlush(EventManager.class, 100, TimeUnit.MILLISECONDS);
        } else {
            proxy = this.systemEventManager.get().createProxyWithAutoFlush(EventManager.class, 100, TimeUnit.MILLISECONDS);
        }
        this.eventManagerThreadLocal.set(proxy);
        return proxy;
    }

    @Override
    public void shutdownSystemEventBus() {
        ServiceQueue serviceQueue = this.systemEventManager.get();
        if (serviceQueue != null) {
            serviceQueue.stop();
        }
    }

    @Override
    public EventManager eventManagerProxy() {
        return this.eventManagerThreadLocal.get();
    }

    @Override
    public void clearEventManagerProxy() {
        this.eventManagerThreadLocal.set(null);
    }

    @Override
    public <T> T createLocalProxy(Class<T> serviceInterface, String serviceName, ServiceBundle serviceBundle) {
        return this.serviceProxyFactory.createProxy(serviceInterface, serviceName, serviceBundle);
    }

    @Override
    public <T> T createRemoteProxyWithReturnAddress(Class<T> serviceInterface, String address, String serviceName, String host, int port, AtomicBoolean connected, String returnAddressArg, Sender<String> sender, BeforeMethodCall beforeMethodCall, int requestBatchSize) {
        return this.remoteServiceProxyFactory.createProxyWithReturnAddress(serviceInterface, serviceName, host, port, connected, returnAddressArg, new SenderEndPoint(this.createEncoder(), address, sender, beforeMethodCall, requestBatchSize));
    }

    @Override
    public MethodCall<Object> createMethodCallFromHttpRequest(Request<Object> request, Object args) {
        MethodCallBuilder methodCallBuilder = new MethodCallBuilder();
        methodCallBuilder.setOriginatingRequest(request);
        methodCallBuilder.setBody(args);
        methodCallBuilder.setHeaders(request.headers());
        methodCallBuilder.setParams(request.params());
        methodCallBuilder.setAddress(request.address());
        methodCallBuilder.overridesFromParams();
        return methodCallBuilder.build();
    }

    @Override
    public JsonMapper createJsonMapper() {
        return new BoonJsonMapper();
    }

    @Override
    public ServiceEndpointServer createServiceServer(HttpTransport httpServer, ProtocolEncoder encoder, ProtocolParser protocolParser, ServiceBundle serviceBundle, JsonMapper jsonMapper, int timeOutInSeconds, int numberOfOutstandingRequests, int batchSize, int flushInterval, QBitSystemManager systemManager, String endpointName, ServiceDiscovery serviceDiscovery, int port, int ttlSeconds, HealthServiceAsync healthServiceAsync) {
        return new ServiceEndpointServerImpl(httpServer, encoder, protocolParser, serviceBundle, jsonMapper, timeOutInSeconds, numberOfOutstandingRequests, batchSize, flushInterval, systemManager, endpointName, serviceDiscovery, port, ttlSeconds, healthServiceAsync);
    }

    @Override
    public Client createClient(String uri, HttpClient httpClient, int requestBatchSize) {
        return FactorySPI.getClientFactory().create(uri, httpClient, requestBatchSize);
    }

    @Override
    public ProtocolParser createProtocolParser() {
        return new BoonProtocolParser();
    }

    @Override
    public MethodCall<Object> createMethodCallToBeParsedFromBody(String address, String returnAddress, String objectName, String methodName, Object body, MultiMap<String, String> params) {
        MethodCall<Object> parsedMethodCall = null;
        if (body != null) {
            ProtocolParser parser = this.selectProtocolParser(body, params);
            parsedMethodCall = parser != null ? parser.parseMethodCall(body) : this.defaultProtocol.parseMethodCall(body);
        }
        if (parsedMethodCall != null) {
            return parsedMethodCall;
        }
        MethodCallBuilder methodCallBuilder = new MethodCallBuilder();
        methodCallBuilder.setName(methodName);
        methodCallBuilder.setBody(body);
        methodCallBuilder.setObjectName(objectName);
        methodCallBuilder.setAddress(address);
        methodCallBuilder.setReturnAddress(returnAddress);
        if (params != null) {
            methodCallBuilder.setParams(params);
        }
        methodCallBuilder.overridesFromParams();
        return methodCallBuilder.build();
    }

    @Override
    public MethodCall<Object> createMethodCallByAddress(String address, String returnAddress, Object args, MultiMap<String, String> params) {
        return this.createMethodCallToBeParsedFromBody(address, returnAddress, "", "", args, params);
    }

    @Override
    public MethodCall<Object> createMethodCallByNames(String methodName, String objectName, String returnAddress, Object args, MultiMap<String, String> params) {
        return this.createMethodCallToBeParsedFromBody("", returnAddress, objectName, methodName, args, params);
    }

    private ProtocolParser selectProtocolParser(Object args, MultiMap<String, String> params) {
        for (ProtocolParser parser : this.protocolParserListRef.get()) {
            if (!parser.supports(args, params)) continue;
            return parser;
        }
        return null;
    }

    @Override
    public ServiceBundle createServiceBundle(String address, QueueBuilder requestQueueBuilder, QueueBuilder responseQueueBuilder, QueueBuilder webResponseQueueBuilder, Factory factory, boolean asyncCalls, BeforeMethodCall beforeMethodCall, BeforeMethodCall beforeMethodCallAfterTransform, Transformer<Request, Object> argTransformer, boolean invokeDynamic, QBitSystemManager systemManager, HealthServiceAsync healthService, StatsCollector statsCollector, Timer timer, int statsFlushRateSeconds, int checkTimingEveryXCalls, CallbackManager callbackManager, EventManager eventManager) {
        return new ServiceBundleImpl(address, requestQueueBuilder, responseQueueBuilder, webResponseQueueBuilder, factory, asyncCalls, beforeMethodCall, beforeMethodCallAfterTransform, argTransformer, invokeDynamic, systemManager, healthService, statsCollector, timer, statsFlushRateSeconds, checkTimingEveryXCalls, callbackManager, eventManager);
    }

    @Override
    public ServiceMethodHandler createServiceMethodHandler(boolean invokeDynamic) {
        return new BoonServiceMethodCallHandler(invokeDynamic);
    }

    @Override
    public ProtocolEncoder createEncoder() {
        return new BoonProtocolEncoder();
    }

    @Override
    public EventBusProxyCreator eventBusProxyCreator() {
        return new BoonEventBusProxyCreator();
    }
}

