/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.boon.client;

import io.advantageous.boon.core.Conversions;
import io.advantageous.boon.core.Exceptions;
import io.advantageous.boon.core.Str;
import io.advantageous.boon.core.StringScanner;
import io.advantageous.boon.core.Sys;
import io.advantageous.boon.core.reflection.ClassMeta;
import io.advantageous.boon.core.reflection.MapObjectConversion;
import io.advantageous.boon.core.reflection.MethodAccess;
import io.advantageous.boon.primitive.Arry;
import io.advantageous.qbit.GlobalConstants;
import io.advantageous.qbit.QBit;
import io.advantageous.qbit.client.Client;
import io.advantageous.qbit.client.ClientProxy;
import io.advantageous.qbit.http.client.HttpClient;
import io.advantageous.qbit.http.websocket.WebSocket;
import io.advantageous.qbit.message.Message;
import io.advantageous.qbit.message.MethodCall;
import io.advantageous.qbit.message.Response;
import io.advantageous.qbit.message.impl.MethodCallImpl;
import io.advantageous.qbit.reactive.Callback;
import io.advantageous.qbit.sender.Sender;
import io.advantageous.qbit.service.BeforeMethodCall;
import java.lang.ref.WeakReference;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoonClient
implements Client {
    private final String uri;
    private final HttpClient httpServerProxy;
    private final int requestBatchSize;
    private final boolean debug = GlobalConstants.DEBUG;
    Object context = Sys.contextToHold();
    private final Map<HandlerKey, Callback<Object>> handlers = new ConcurrentHashMap<HandlerKey, Callback<Object>>();
    private final Logger logger = LoggerFactory.getLogger(BoonClient.class);
    private final List<ClientProxy> clientProxies = new CopyOnWriteArrayList<ClientProxy>();
    private WebSocket webSocket;
    private final AtomicBoolean connected = new AtomicBoolean();

    public BoonClient(String uri, HttpClient httpClient, int requestBatchSize) {
        this.httpServerProxy = httpClient;
        this.uri = uri;
        this.requestBatchSize = requestBatchSize;
    }

    @Override
    public void stop() {
        this.flush();
        if (this.httpServerProxy != null) {
            try {
                this.httpServerProxy.stop();
            }
            catch (Exception ex) {
                this.logger.warn("Problem closing httpServerProxy ", (Throwable)ex);
            }
        }
    }

    @Override
    public boolean connected() {
        return this.connected.get();
    }

    private void handleWebSocketReplyMessage(String webSocketText) {
        List<Message<Object>> messages = QBit.factory().createProtocolParser().parse("", webSocketText);
        for (Message<Object> message : messages) {
            Response response;
            String[] split;
            HandlerKey key;
            Callback<Object> handler;
            if (!(message instanceof Response) || (handler = this.handlers.get(key = (split = StringScanner.split((String)(response = (Response)message).returnAddress(), (char)'\u001e')).length == 2 ? new HandlerKey(split[1], response.id()) : new HandlerKey(split[0], response.id()))) == null) continue;
            this.handleAsyncCallback(response, handler);
            this.handlers.remove(key);
        }
    }

    private void handleAsyncCallback(Response<Object> response, Callback<Object> handler) {
        if (response.wasErrors()) {
            handler.onError(new Exception(response.body().toString()));
        } else {
            handler.accept(response.body());
        }
    }

    @Override
    public void flush() {
        for (ClientProxy clientProxy : this.clientProxies) {
            clientProxy.clientProxyFlush();
        }
        this.httpServerProxy.flush();
    }

    /*
     * Unable to fully structure code
     */
    private void send(String serviceName, String message) {
        block9: {
            if (this.webSocket == null) {
                webSocketURI = serviceName.startsWith(this.uri) != false ? serviceName : Str.add((String[])new String[]{this.uri, "/", serviceName});
                this.webSocket = this.httpServerProxy.createWebSocket(webSocketURI);
                this.wireWebSocket(serviceName, message);
                try {
                    this.webSocket.openAndWait();
                    this.connected.set(true);
                }
                catch (Exception ex) {
                    this.connected.set(false);
                    if (!this.debug) ** GOTO lbl22
                    throw new IllegalStateException(ex);
                }
            } else {
                try {
                    if (this.webSocket.isClosed() && this.connected()) {
                        this.webSocket.openAndWait();
                        this.connected.set(true);
                    }
                }
                catch (Exception ex) {
                    this.connected.set(false);
                    if (!this.debug) break block9;
                    throw ex;
                }
            }
        }
        if (!this.webSocket.isClosed()) {
            this.webSocket.sendText(message);
        } else {
            this.connected.set(false);
        }
    }

    private void wireWebSocket(String serviceName, String message) {
        this.webSocket.setErrorConsumer(error -> this.logger.error(Str.sputs((Object[])new Object[]{this.getClass().getName(), "::Exception calling WebSocket from client proxy", "\nService Name", serviceName, "\nMessage", message}), (Throwable)error));
        this.webSocket.setTextMessageConsumer(messageFromServer -> this.handleWebSocketReplyMessage((String)messageFromServer));
    }

    @Override
    public <T> T createProxy(Class<T> serviceInterface, String serviceName) {
        return this.createProxy(serviceInterface, serviceName, Str.join((char)'-', (String[])new String[]{this.uri, serviceName, UUID.randomUUID().toString()}));
    }

    public <T> T createProxy(Class<T> serviceInterface, final String serviceName, String returnAddressArg) {
        if (!serviceInterface.isInterface()) {
            Exceptions.die((String)"QBitClient:: The service interface must be an interface");
        }
        BeforeMethodCall beforeMethodCall = call -> {
            Object[] list;
            Object body = call.body();
            if (body instanceof Object[] && (list = (Object[])body).length > 0) {
                Object o = list[0];
                if (o instanceof Callback) {
                    this.handlers.put(new HandlerKey(call.returnAddress(), call.id()), this.createHandler(serviceInterface, call, (Callback)o));
                    list = list.length - 1 == 0 ? new Object[]{} : Arry.slc((Object[])list, (int)1);
                }
                if (call instanceof MethodCallImpl) {
                    MethodCallImpl impl = (MethodCallImpl)call;
                    impl.setBody(list);
                }
            }
            return true;
        };
        Sender<String> sender = new Sender<String>(){

            @Override
            public void send(String returnAddress, String buffer) {
                BoonClient.this.send(serviceName, buffer);
            }

            @Override
            public void stop() {
                BoonClient.this.stop();
            }
        };
        T proxy = QBit.factory().createRemoteProxyWithReturnAddress(serviceInterface, this.uri, serviceName, this.httpServerProxy.getHost(), this.httpServerProxy.getPort(), this.connected, returnAddressArg, sender, beforeMethodCall, this.requestBatchSize);
        if (proxy instanceof ClientProxy) {
            this.clientProxies.add((ClientProxy)proxy);
        }
        return proxy;
    }

    private <T> Callback createHandler(Class<T> serviceInterface, MethodCall call, final Callback handler) {
        ClassMeta clsMeta = ClassMeta.classMeta(serviceInterface);
        MethodAccess method = clsMeta.method(call.name());
        Class returnType = null;
        Class compType = null;
        if (method.parameterTypes().length > 0) {
            Type type;
            Type[] genericParameterTypes = method.getGenericParameterTypes();
            ParameterizedType parameterizedType = genericParameterTypes.length > 0 ? (ParameterizedType)genericParameterTypes[0] : null;
            Type type2 = (parameterizedType != null ? parameterizedType.getActualTypeArguments().length : 0) > 0 ? (parameterizedType != null ? parameterizedType.getActualTypeArguments() : new Type[]{})[0] : (type = null);
            if (type instanceof ParameterizedType) {
                returnType = (Class)((ParameterizedType)type).getRawType();
                Type type1 = ((ParameterizedType)type).getActualTypeArguments()[0];
                if (type1 instanceof Class) {
                    compType = (Class)type1;
                }
            } else if (type instanceof Class) {
                returnType = (Class)type;
            }
        }
        final Class actualReturnType = returnType;
        final Class componentClass = compType;
        return new Callback<Object>(){

            @Override
            public void accept(Object event) {
                if (actualReturnType != null) {
                    if (componentClass != null && actualReturnType == List.class) {
                        try {
                            event = MapObjectConversion.convertListOfMapsToObjects((Class)componentClass, (List)((List)event));
                        }
                        catch (Exception ex) {
                            if (event instanceof CharSequence) {
                                String errorMessage = event.toString();
                                if (errorMessage.startsWith("java.lang.IllegalState")) {
                                    handler.onError(new IllegalStateException(errorMessage));
                                    return;
                                }
                                handler.onError(new IllegalStateException("Conversion error"));
                                return;
                            }
                            handler.onError(new IllegalStateException("Conversion error"));
                            return;
                        }
                    } else {
                        event = Conversions.coerce((Class)actualReturnType, (Object)event);
                    }
                    handler.accept(event);
                }
            }

            @Override
            public void onError(Throwable error) {
                handler.onError(error);
            }

            @Override
            public void onTimeout() {
                handler.onTimeout();
            }
        };
    }

    @Override
    public void start() {
        WeakReference<BoonClient> boonClientWeakReference = new WeakReference<BoonClient>(this);
        this.httpServerProxy.periodicFlushCallback(aVoid -> {
            BoonClient boonClient = (BoonClient)boonClientWeakReference.get();
            if (boonClient != null) {
                boonClient.flush();
            }
        });
        this.httpServerProxy.startClient();
        this.connected.set(true);
    }

    private class HandlerKey {
        final String returnAddress;
        final long messageId;

        private HandlerKey(String returnAddress, long messageId) {
            this.returnAddress = returnAddress;
            this.messageId = messageId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HandlerKey that = (HandlerKey)o;
            return this.messageId == that.messageId && !(this.returnAddress == null ? that.returnAddress != null : !this.returnAddress.equals(that.returnAddress));
        }

        public int hashCode() {
            int result = this.returnAddress != null ? this.returnAddress.hashCode() : 0;
            result = 31 * result + (int)(this.messageId ^ this.messageId >>> 32);
            return result;
        }
    }
}

