/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.boon.events.impl;

import io.advantageous.boon.core.Sets;
import io.advantageous.boon.core.Str;
import io.advantageous.boon.core.Sys;
import io.advantageous.boon.core.reflection.AnnotationData;
import io.advantageous.boon.core.reflection.ClassMeta;
import io.advantageous.qbit.annotation.AnnotationUtils;
import io.advantageous.qbit.client.ClientProxy;
import io.advantageous.qbit.events.EventBusProxyCreator;
import io.advantageous.qbit.events.EventManager;
import io.advantageous.qbit.service.ServiceProxyUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class BoonEventBusProxyCreator
implements EventBusProxyCreator {
    Object context = Sys.contextToHold();
    private static final String flushMethodNames = Sys.sysProp((String)"io.advantageous.qbit.events.EventBusProxyCreator.flushMethodNames", (Object)"clientProxyFlush,flushEvents");
    private final Set<String> flushMethodNameSet = Sets.set((Object[])Str.split((String)flushMethodNames, (char)','));

    @Override
    public <T> T createProxy(EventManager eventManager, Class<T> eventBusProxyInterface) {
        return this.createProxyWithChannelPrefix(eventManager, eventBusProxyInterface, null);
    }

    @Override
    public <T> T createProxyWithChannelPrefix(EventManager eventManager, Class<T> eventBusProxyInterface, String channelPrefix) {
        if (!eventBusProxyInterface.isInterface()) {
            throw new IllegalArgumentException("Must be an interface for eventBusProxyInterface argument");
        }
        Map<String, String> methodToChannelMap = this.createMethodToChannelMap(channelPrefix, eventBusProxyInterface);
        InvocationHandler invocationHandler = (proxy, method, args) -> {
            if (this.flushMethodNameSet.contains(method.getName())) {
                ServiceProxyUtils.flushServiceProxy(eventManager);
                return null;
            }
            String channelName = (String)methodToChannelMap.get(method.toString());
            eventManager.sendArguments(channelName, args);
            return null;
        };
        Object o = Proxy.newProxyInstance(eventBusProxyInterface.getClassLoader(), new Class[]{eventBusProxyInterface, ClientProxy.class}, invocationHandler);
        return (T)o;
    }

    private <T> Map<String, String> createMethodToChannelMap(String channelPrefix, Class<T> eventBusProxyInterface) {
        ConcurrentHashMap<String, String> methodToChannelMap = new ConcurrentHashMap<String, String>(20);
        ClassMeta classMeta = ClassMeta.classMeta(eventBusProxyInterface);
        AnnotationData classAnnotation = classMeta.annotation(AnnotationUtils.EVENT_CHANNEL_ANNOTATION_NAME);
        String classEventBusName = AnnotationUtils.getClassEventChannelName(classMeta, classAnnotation);
        classMeta.methods().forEach(methodAccess -> {
            String methodEventBusName;
            AnnotationData methodAnnotation = methodAccess.annotation(AnnotationUtils.EVENT_CHANNEL_ANNOTATION_NAME);
            String string3 = methodEventBusName = methodAnnotation != null && methodAnnotation.getValues().get("value") != null ? methodAnnotation.getValues().get("value").toString() : null;
            if (Str.isEmpty(methodEventBusName)) {
                methodEventBusName = methodAccess.name();
            }
            String channelName = AnnotationUtils.createChannelName(channelPrefix, classEventBusName, methodEventBusName);
            methodToChannelMap.put(methodAccess.method().toString(), channelName);
        });
        return methodToChannelMap;
    }
}

