/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.boon.events.impl;

import io.advantageous.boon.core.Str;
import io.advantageous.boon.core.Sys;
import io.advantageous.boon.core.reflection.AnnotationData;
import io.advantageous.boon.core.reflection.BeanUtils;
import io.advantageous.boon.core.reflection.ClassMeta;
import io.advantageous.boon.core.reflection.MethodAccess;
import io.advantageous.qbit.GlobalConstants;
import io.advantageous.qbit.annotation.AnnotationUtils;
import io.advantageous.qbit.annotation.QueueCallback;
import io.advantageous.qbit.annotation.QueueCallbackType;
import io.advantageous.qbit.events.EventBus;
import io.advantageous.qbit.events.EventConsumer;
import io.advantageous.qbit.events.EventListener;
import io.advantageous.qbit.events.EventManager;
import io.advantageous.qbit.events.EventSubscriber;
import io.advantageous.qbit.events.impl.EventBusImpl;
import io.advantageous.qbit.events.spi.EventConnector;
import io.advantageous.qbit.events.spi.EventTransferObject;
import io.advantageous.qbit.message.Event;
import io.advantageous.qbit.queue.SendQueue;
import io.advantageous.qbit.service.ServiceContext;
import io.advantageous.qbit.service.ServiceQueue;
import io.advantageous.qbit.service.stats.StatsCollector;
import io.advantageous.qbit.util.Timer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoonEventManager
implements EventManager {
    private final Logger logger = LoggerFactory.getLogger(BoonEventManager.class);
    private final EventBus eventBus;
    private final Map<String, List<Object>> eventMap = new ConcurrentHashMap<String, List<Object>>();
    private final List<SendQueue<Event<Object>>> queuesToFlush = new ArrayList<SendQueue<Event<Object>>>(100);
    private final HashSet<ServiceQueue> services = new HashSet();
    private final boolean debug = GlobalConstants.DEBUG || this.logger.isDebugEnabled();
    private final String name;
    private final StatsCollector stats;
    private int messageCountSinceLastFlush = 0;
    private long flushCount = 0L;
    private long lastFlushTime = 0L;
    private long now;
    private final String eventCountStatsKey;
    Object context = Sys.contextToHold();

    public BoonEventManager(String name, EventConnector eventConnector, StatsCollector statsCollector) {
        this.logger.info("Event manager created {} {} {}", new Object[]{name, eventConnector, statsCollector});
        this.name = name;
        this.eventBus = new EventBusImpl(name, eventConnector, statsCollector);
        this.stats = statsCollector;
        this.eventCountStatsKey = "EventManager." + name.replace(" ", ".");
    }

    private void sendMessages() {
        ++this.flushCount;
        this.lastFlushTime = this.now;
        this.stats.recordCount(this.eventCountStatsKey, this.messageCountSinceLastFlush);
        this.messageCountSinceLastFlush = 0;
        if (this.debug) {
            this.logger.debug("EventManager {} flushCount {}", (Object)this.name, (Object)this.flushCount);
        }
        Set<Map.Entry<String, List<Object>>> entries = this.eventMap.entrySet();
        for (Map.Entry<String, List<Object>> entry : entries) {
            String channelName = entry.getKey();
            List<Object> events = entry.getValue();
            for (Object event : events) {
                this.eventBus.send(channelName, event);
            }
            events.clear();
        }
        for (SendQueue sendQueue : this.queuesToFlush) {
            sendQueue.flushSends();
        }
    }

    @QueueCallback(value={QueueCallbackType.IDLE})
    private void queueIdle() {
        this.now = Timer.timer().now();
        if (this.messageCountSinceLastFlush > 0) {
            this.sendMessages();
            return;
        }
        this.eventBus.flush();
    }

    @QueueCallback(value={QueueCallbackType.LIMIT})
    private void queueLimit() {
        if (this.messageCountSinceLastFlush > 100000) {
            this.now = Timer.timer().now();
            this.logger.debug("EventManager {}: Sending all messages because we have more than 100K", (Object)this.name);
            this.sendMessages();
            return;
        }
        this.now = Timer.timer().now();
        long duration = this.now - this.lastFlushTime;
        if (duration > 50L && this.messageCountSinceLastFlush > 0) {
            if (this.debug) {
                this.logger.debug("EventManager {}: Sending all messages because 50 MS elapsed and we have more than 0", (Object)this.name);
            }
            this.sendMessages();
        }
        this.eventBus.flush();
    }

    @QueueCallback(value={QueueCallbackType.EMPTY})
    private void queueEmpty() {
        if (this.messageCountSinceLastFlush > 100) {
            this.now = Timer.timer().now();
            this.sendMessages();
            return;
        }
        this.now = Timer.timer().now();
        long duration = this.now - this.lastFlushTime;
        if (duration > 20L && this.messageCountSinceLastFlush > 0) {
            this.sendMessages();
        }
        this.eventBus.flush();
    }

    @Override
    public void joinService(ServiceQueue serviceQueue) {
        if (this.services.contains(serviceQueue)) {
            this.logger.info("EventManager{}::joinService: Service queue is already a member of this event manager {}", (Object)this.name, (Object)serviceQueue.name());
            return;
        }
        this.services.add(serviceQueue);
        this.logger.info("EventManager{}::joinService::  {} joined {}", new Object[]{this.name, serviceQueue.name(), this.name});
        this.doListen(serviceQueue.service(), serviceQueue);
    }

    @Override
    public void leave() {
        ServiceQueue serviceQueue = ServiceContext.serviceContext().currentService();
        if (serviceQueue == null) {
            throw new IllegalStateException(String.format("EventManager %s:: Must be called from inside of a Service", this.name));
        }
        this.stopListening(serviceQueue.service());
        this.services.remove(serviceQueue);
    }

    @Override
    public void listen(Object listener) {
        this.doListen(listener, null);
    }

    private void doListen(Object listener, ServiceQueue serviceQueue) {
        Class<?>[] interfacesFromListener;
        if (this.debug) {
            this.logger.debug("EventManager {}  registering listener {} with serviceQueue {}", new Object[]{this.name, listener, serviceQueue});
        }
        ClassMeta listenerClassMeta = ClassMeta.classMeta(listener.getClass());
        Iterable listenerMethods = listenerClassMeta.methods();
        for (MethodAccess methodAccess : listenerMethods) {
            AnnotationData listenAnnotationData = AnnotationUtils.getListenAnnotation(methodAccess);
            if (listenAnnotationData == null) continue;
            this.extractEventListenerFromMethod(listener, methodAccess, listenAnnotationData, serviceQueue);
        }
        for (Class<?> interfaceClass : interfacesFromListener = listenerClassMeta.cls().getInterfaces()) {
            ClassMeta metaFromListenerInterface = ClassMeta.classMeta(interfaceClass);
            AnnotationData eventChannelAnnotation = metaFromListenerInterface.annotation(AnnotationUtils.EVENT_CHANNEL_ANNOTATION_NAME);
            if (eventChannelAnnotation == null) continue;
            Iterable interfaceMethods = metaFromListenerInterface.methods();
            String classEventBusName = AnnotationUtils.getClassEventChannelName(metaFromListenerInterface, eventChannelAnnotation);
            for (MethodAccess methodAccess : interfaceMethods) {
                String methodEventBusName;
                AnnotationData methodAnnotation = methodAccess.annotation(AnnotationUtils.EVENT_CHANNEL_ANNOTATION_NAME);
                String string = methodEventBusName = methodAnnotation != null && methodAnnotation.getValues().get("value") != null ? methodAnnotation.getValues().get("value").toString() : null;
                if (Str.isEmpty(methodEventBusName)) {
                    methodEventBusName = methodAccess.name();
                }
                String channelName = AnnotationUtils.createChannelName(null, classEventBusName, methodEventBusName);
                if (serviceQueue == null) {
                    this.extractListenerForRegularObject(listener, methodAccess, channelName, false);
                    continue;
                }
                this.extractListenerForService(serviceQueue, channelName, false);
            }
        }
    }

    private void extractEventListenerFromMethod(Object listener, MethodAccess methodAccess, AnnotationData listen, ServiceQueue serviceQueue) {
        this.logger.info("EventManager {} ::extractEventListenerFromMethod  :: {} is listening with method {} using annotation data {} ", new Object[]{this.name, serviceQueue, methodAccess.name(), listen.getValues()});
        String channel = listen.getValues().get("value").toString();
        boolean consume = (Boolean)listen.getValues().get("consume");
        if (serviceQueue == null) {
            this.extractListenerForRegularObject(listener, methodAccess, channel, consume);
        } else {
            this.extractListenerForService(serviceQueue, channel, consume);
        }
    }

    private void extractListenerForService(ServiceQueue serviceQueue, String channel, boolean consume) {
        this.logger.info("EventManager {}:: {} is listening on channel {} and is consuming? {}", new Object[]{this.name, serviceQueue.name(), channel, consume});
        SendQueue<Event<Object>> events = serviceQueue.events();
        if (consume) {
            this.consume(channel, events);
        } else {
            this.subscribe(channel, events);
        }
    }

    private void extractListenerForRegularObject(final Object listener, final MethodAccess methodAccess, String channel, boolean consume) {
        this.logger.info("EventManager {}:: {} is listening with method {} on channel {} and is consuming? {}", new Object[]{this.name, listener.getClass().getSimpleName(), methodAccess.name(), channel, consume});
        if (consume) {
            this.register(channel, new EventConsumer<Object>(){

                @Override
                public void listen(Event<Object> event) {
                    BoonEventManager.this.invokeEventMethod(event, methodAccess, listener);
                }
            });
        } else {
            this.register(channel, new EventSubscriber<Object>(){

                @Override
                public void listen(Event<Object> event) {
                    BoonEventManager.this.invokeEventMethod(event, methodAccess, listener);
                }
            });
        }
    }

    private void invokeEventMethod(Event<Object> event, MethodAccess methodAccess, Object listener) {
        if (event.body() instanceof Object[]) {
            methodAccess.invokeDynamic(listener, (Object[])event.body());
        } else if (event.body() instanceof List) {
            List body = (List)event.body();
            methodAccess.invokeDynamic(listener, body.toArray(new Object[body.size()]));
        } else {
            methodAccess.invokeDynamic(listener, new Object[]{event.body()});
        }
    }

    @Override
    public void stopListening(Object listener) {
        ClassMeta classMeta = ClassMeta.classMeta(listener.getClass());
        Iterable methods = classMeta.methods();
        for (MethodAccess methodAccess : methods) {
            AnnotationData listen = AnnotationUtils.getListenAnnotation(methodAccess);
            if (listen == null) continue;
            this.stopListeningToMethodEventListeners(listener, methodAccess, listen);
        }
    }

    private void stopListeningToMethodEventListeners(Object listener, MethodAccess methodAccess, AnnotationData listen) {
    }

    @Override
    public <T> void register(String channelName, EventListener<T> listener) {
        this.eventBus.register(channelName, listener);
    }

    @Override
    public <T> void unregister(String channelName, EventListener<T> listener) {
        this.eventBus.unregister(channelName, listener);
    }

    @Override
    public void subscribe(String channelName, final SendQueue<Event<Object>> sendQueue) {
        this.logger.info("EventManager {}::subscribe() channel name {} sendQueue {}", new Object[]{this.name, channelName, sendQueue.name()});
        this.queuesToFlush.add(sendQueue);
        this.eventBus.register(channelName, new EventSubscriber<Object>(){

            @Override
            public void listen(Event<Object> event) {
                sendQueue.send(event);
            }
        });
    }

    @Override
    public void consume(String channelName, final SendQueue<Event<Object>> sendQueue) {
        this.logger.info("EventManager {}::consume() channel name {} sendQueue {}", new Object[]{this.name, channelName, sendQueue.name()});
        this.queuesToFlush.add(sendQueue);
        this.eventBus.register(channelName, new EventConsumer<Object>(){

            @Override
            public void listen(Event<Object> event) {
                sendQueue.send(event);
            }
        });
    }

    @Override
    public <T> void send(String channel, T event) {
        ++this.messageCountSinceLastFlush;
        this.events(channel).add(event);
    }

    @Override
    @SafeVarargs
    public final <T> void sendArray(String channel, T ... event) {
        this.send(channel, event);
    }

    @Override
    @SafeVarargs
    public final <T> void sendArguments(String channel, T ... event) {
        this.send(channel, event);
    }

    private List<Object> events(String channel) {
        List<Object> events = this.eventMap.get(channel);
        if (events == null) {
            events = new ArrayList<Object>(100);
            this.eventMap.put(channel, events);
        }
        return events;
    }

    @Override
    public <T> void sendCopy(String channel, T event) {
        Object copy = BeanUtils.copy(event);
        this.send(channel, copy);
    }

    @Override
    public void forwardEvent(EventTransferObject<Object> event) {
        ++this.messageCountSinceLastFlush;
        this.eventBus.forwardEvent(event);
    }

    public String toString() {
        return this.name + " " + super.toString();
    }
}

