/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.boon.service.impl;

import io.advantageous.boon.core.Conversions;
import io.advantageous.boon.core.Exceptions;
import io.advantageous.boon.core.IO;
import io.advantageous.boon.core.Lists;
import io.advantageous.boon.core.Pair;
import io.advantageous.boon.core.Str;
import io.advantageous.boon.core.StringScanner;
import io.advantageous.boon.core.Sys;
import io.advantageous.boon.core.TypeType;
import io.advantageous.boon.core.reflection.Annotated;
import io.advantageous.boon.core.reflection.AnnotationData;
import io.advantageous.boon.core.reflection.ClassMeta;
import io.advantageous.boon.core.reflection.MethodAccess;
import io.advantageous.boon.primitive.Arry;
import io.advantageous.qbit.annotation.AnnotationUtils;
import io.advantageous.qbit.annotation.RequestMethod;
import io.advantageous.qbit.bindings.ArgParamURIPositionBinding;
import io.advantageous.qbit.bindings.MethodBinding;
import io.advantageous.qbit.bindings.RequestParamBinding;
import io.advantageous.qbit.boon.service.impl.QueueCallbackHandlerFactory;
import io.advantageous.qbit.http.request.HttpRequest;
import io.advantageous.qbit.message.Event;
import io.advantageous.qbit.message.MethodCall;
import io.advantageous.qbit.message.Request;
import io.advantageous.qbit.message.Response;
import io.advantageous.qbit.message.impl.ResponseImpl;
import io.advantageous.qbit.queue.QueueCallBackHandler;
import io.advantageous.qbit.queue.SendQueue;
import io.advantageous.qbit.reactive.Callback;
import io.advantageous.qbit.service.ServiceMethodHandler;
import io.advantageous.qbit.service.impl.ServiceConstants;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;

public class BoonServiceMethodCallHandler
implements ServiceMethodHandler {
    private final boolean invokeDynamic;
    private ClassMeta<Class<?>> classMeta;
    private Object service;
    private QueueCallBackHandler queueCallBackHandler;
    private String address = "";
    private String name = "";
    private final TreeSet<String> addresses = new TreeSet();
    private final Map<String, Map<String, Pair<MethodBinding, MethodAccess>>> methodMap = new LinkedHashMap<String, Map<String, Pair<MethodBinding, MethodAccess>>>();
    private SendQueue<Response<Object>> responseSendQueue;
    Object context = Sys.contextToHold();
    private final Map<String, MethodAccess> eventMap = new ConcurrentHashMap<String, MethodAccess>();

    public BoonServiceMethodCallHandler(boolean invokeDynamic) {
        this.invokeDynamic = invokeDynamic;
    }

    @Override
    public Response<Object> receiveMethodCall(MethodCall<Object> methodCall) {
        try {
            if (methodCall.name() != null && !methodCall.name().isEmpty()) {
                return this.invokeByName(methodCall);
            }
            return this.invokeByAddress(methodCall);
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof InvocationTargetException) {
                InvocationTargetException tex = (InvocationTargetException)ex.getCause();
                return new ResponseImpl<Object>(methodCall, tex.getTargetException());
            }
            return new ResponseImpl<Object>(methodCall, ex);
        }
    }

    private Response<Object> invokeByAddress(MethodCall<Object> methodCall) {
        String address = methodCall.address();
        Map<String, Pair<MethodBinding, MethodAccess>> mappings = this.methodMap.get(address);
        Request<Object> request = methodCall.originatingRequest();
        Pair<MethodBinding, MethodAccess> binding = null;
        if (mappings != null && request instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)request;
            String method = httpRequest.getMethod();
            binding = mappings.get(method);
        }
        if (mappings != null && mappings.size() == 1 && binding == null) {
            binding = mappings.values().iterator().next();
        }
        if (binding != null) {
            return this.invokeByAddressWithSimpleBinding(methodCall, binding);
        }
        return this.invokeByAddressWithComplexBinding(methodCall);
    }

    private Response<Object> invokeByAddressWithComplexBinding(MethodCall<Object> methodCall) {
        List annotationDataForParams;
        String mAddress = this.addresses.lower(methodCall.address());
        Map<String, Pair<MethodBinding, MethodAccess>> mappings = this.methodMap.get(mAddress);
        if (!methodCall.address().startsWith(mAddress)) {
            throw new IllegalArgumentException("Method not found: " + methodCall);
        }
        Request<Object> request = methodCall.originatingRequest();
        Pair<MethodBinding, MethodAccess> binding = null;
        if (request instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)request;
            String method = httpRequest.getMethod();
            binding = mappings.get(method);
        } else if (mappings != null && mappings.size() == 1) {
            binding = mappings.values().iterator().next();
        }
        String[] split = StringScanner.split((String)methodCall.address(), (char)'/');
        MethodBinding methodBinding = binding != null ? (MethodBinding)binding.getFirst() : null;
        MethodAccess methodAccess = binding != null ? (MethodAccess)binding.getSecond() : null;
        List<ArgParamURIPositionBinding> parameters = methodBinding != null ? methodBinding.parameters() : null;
        Class[] parameterTypes = methodAccess != null ? methodAccess.parameterTypes() : new Class[]{};
        List paramEnumTypes = methodAccess != null ? methodAccess.paramTypeEnumList() : null;
        List<Object> args = this.prepareArgumentList(methodCall, methodAccess != null ? methodAccess.parameterTypes() : new Class[]{});
        List list = annotationDataForParams = methodAccess != null ? methodAccess.annotationDataForParams() : null;
        if (parameters != null) {
            for (ArgParamURIPositionBinding param : parameters) {
                int uriPosition = param.getUriPosition();
                int methodParamPosition = param.getMethodParamPosition();
                String paramName = param.getMethodParamName();
                if (uriPosition != -1) {
                    if (uriPosition > split.length) {
                        Exceptions.die((Object[])new Object[]{"Parameter position is more than param length of method", methodAccess});
                        continue;
                    }
                    String paramAtPos = split[uriPosition];
                    TypeType typeType = paramEnumTypes == null ? null : (TypeType)paramEnumTypes.get(methodParamPosition);
                    Object arg = Conversions.coerce((TypeType)typeType, (Class)parameterTypes[methodParamPosition], (Object)paramAtPos);
                    args.set(methodParamPosition, arg);
                    continue;
                }
                if (Str.isEmpty((String)paramName)) {
                    Exceptions.die((String)"Parameter name not supplied in URI path var");
                }
                for (int index = 0; index < parameterTypes.length; ++index) {
                    List paramsAnnotationData = annotationDataForParams != null ? (List)annotationDataForParams.get(index) : null;
                    String name = "";
                    if (paramsAnnotationData != null) {
                        AnnotationData paramAnnotation;
                        Iterator iterator = paramsAnnotationData.iterator();
                        while (iterator.hasNext() && (!(paramAnnotation = (AnnotationData)iterator.next()).getName().equalsIgnoreCase("name") && !paramAnnotation.getName().equalsIgnoreCase("PathVariable") || Str.isEmpty((String)(name = (String)paramAnnotation.getValues().get("value"))))) {
                        }
                    }
                    if (!paramName.equals(name)) continue;
                    assert (paramEnumTypes != null);
                    Object arg = Conversions.coerce((TypeType)((TypeType)paramEnumTypes.get(index)), (Class)parameterTypes[index], (Object)split[index]);
                    args.set(index, arg);
                }
            }
        }
        Object returnValue = methodAccess != null ? methodAccess.invokeDynamicObject(this.service, args) : null;
        return this.response(methodAccess, methodCall, returnValue);
    }

    private Response<Object> invokeByAddressWithSimpleBinding(MethodCall<Object> methodCall, Pair<MethodBinding, MethodAccess> pair) {
        MethodBinding binding = (MethodBinding)pair.getFirst();
        MethodAccess method = (MethodAccess)pair.getSecond();
        if (binding.hasRequestParamBindings()) {
            Object body = this.bodyFromRequestParams(method, methodCall, binding);
            Object returnValue = method.invokeDynamicObject(this.service, body);
            return this.response(method, methodCall, returnValue);
        }
        return this.mapArgsAsyncHandlersAndInvoke(methodCall, method);
    }

    private Response<Object> mapArgsAsyncHandlersAndInvoke(MethodCall<Object> methodCall, MethodAccess method) {
        Object returnValue;
        Object body;
        if (method.parameterTypes().length == 0) {
            Object returnValue2 = method.invokeDynamicObject(this.service, null);
            return this.response(method, methodCall, returnValue2);
        }
        if (method.parameterTypes().length == 1 && ((body = methodCall.body()) == null || body instanceof String && Str.isEmpty(body)) && method.parameterTypes()[0] != Callback.class) {
            body = methodCall.params();
            Object returnValue3 = method.invokeDynamicObject(this.service, body);
            return this.response(method, methodCall, returnValue3);
        }
        boolean hasHandlers = this.hasHandlers(methodCall);
        boolean bl = hasHandlers = this.hasHandlers(method) || hasHandlers;
        if (hasHandlers) {
            Object body2 = methodCall.body();
            List<Object> argsList = this.prepareArgumentList(methodCall, method.parameterTypes());
            if (body2 instanceof List || body2 instanceof Object[]) {
                this.extractHandlersFromArgumentList(method, body2, argsList);
            } else if (argsList.size() == 1 && !(argsList.get(0) instanceof Callback)) {
                argsList.set(0, body2);
            }
            returnValue = this.invokeDynamic ? method.invokeDynamicObject(this.service, argsList) : method.invoke(this.service, argsList.toArray(new Object[argsList.size()]));
        } else if (this.invokeDynamic) {
            if (methodCall.body() instanceof List) {
                List argsList = (List)methodCall.body();
                returnValue = method.invokeDynamic(this.service, argsList.toArray(new Object[argsList.size()]));
            } else if (methodCall.body() instanceof Object[]) {
                Object[] argsList = (Object[])methodCall.body();
                returnValue = method.invokeDynamic(this.service, argsList);
            } else {
                returnValue = method.invokeDynamic(this.service, new Object[]{methodCall.body()});
            }
        } else if (methodCall.body() instanceof List) {
            List argsList = (List)methodCall.body();
            returnValue = method.invoke(this.service, argsList.toArray(new Object[argsList.size()]));
        } else if (methodCall.body() instanceof Object[]) {
            Object[] argsList = (Object[])methodCall.body();
            returnValue = method.invoke(this.service, argsList);
        } else {
            returnValue = method.invoke(this.service, new Object[]{methodCall.body()});
        }
        return this.response(method, methodCall, returnValue);
    }

    private boolean hasHandlers(MethodAccess method) {
        for (Class paramType : method.parameterTypes()) {
            if (paramType != Callback.class) continue;
            return true;
        }
        return false;
    }

    private boolean hasHandlers(MethodCall<Object> methodCall) {
        if (methodCall.body() instanceof List) {
            List body = (List)methodCall.body();
            for (Object item : body) {
                if (!(item instanceof Callback)) continue;
                return true;
            }
            return false;
        }
        if (methodCall.body() instanceof Object[]) {
            Object[] body;
            for (Object item : body = (Object[])methodCall.body()) {
                if (!(item instanceof Callback)) continue;
                return true;
            }
            return false;
        }
        return methodCall.body() instanceof Callback;
    }

    private void extractHandlersFromArgumentList(MethodAccess method, Object body, List<Object> argsList) {
        if (body instanceof List) {
            List list = (List)body;
            this.extractHandlersFromArgumentListBodyIsList(method, argsList, list);
        } else if (body instanceof Object[]) {
            this.extractHandlersFromArgumentListArrayCase(method, (Object[])body, argsList);
        }
    }

    private void extractHandlersFromArgumentListArrayCase(MethodAccess method, Object[] array, List<Object> argsList) {
        if (array.length - 1 == method.parameterTypes().length && array[0] instanceof Callback) {
            array = Arry.slc((Object[])array, (int)1);
        }
        int index = 0;
        int arrayIndex = 0;
        while (index < argsList.size()) {
            Object o = argsList.get(index);
            if (!(o instanceof Callback)) {
                if (arrayIndex >= array.length) break;
                argsList.set(index, array[arrayIndex]);
            }
            ++index;
            ++arrayIndex;
        }
    }

    private void extractHandlersFromArgumentListBodyIsList(MethodAccess method, List<Object> argsList, List<Object> list) {
        if (list.size() - 1 == method.parameterTypes().length && list.get(0) instanceof Callback) {
            list = Lists.slc(list, (int)1);
        }
        Iterator<Object> iterator = list.iterator();
        for (int index = 0; index < argsList.size(); ++index) {
            Object o = argsList.get(index);
            if (o instanceof Callback) continue;
            if (!iterator.hasNext()) break;
            argsList.set(index, iterator.next());
        }
    }

    private Response<Object> response(MethodAccess methodAccess, MethodCall<Object> methodCall, Object returnValue) {
        if (methodAccess.returnType() == Void.TYPE || methodAccess.returnType() == Void.class) {
            return ServiceConstants.VOID;
        }
        return ResponseImpl.response(methodCall.id(), methodCall.timestamp(), methodCall.name(), methodCall.returnAddress(), returnValue, methodCall);
    }

    private Object bodyFromRequestParams(MethodAccess method, MethodCall<Object> methodCall, MethodBinding binding) {
        Class[] parameterTypes = method.parameterTypes();
        List<Object> argsList = this.prepareArgumentList(methodCall, parameterTypes);
        boolean methodBodyUsed = false;
        for (int index = 0; index < parameterTypes.length; ++index) {
            RequestParamBinding paramBinding = binding.requestParamBinding(index);
            if (paramBinding == null) {
                Object[] bList;
                if (methodBodyUsed) {
                    Exceptions.die((Object[])new Object[]{"Method body was already used for methodCall\n", methodCall, "\nFor method binding\n", binding, "\nFor method\n", method});
                }
                methodBodyUsed = true;
                if (methodCall.body() instanceof List) {
                    bList = (Object[])methodCall.body();
                    if (bList.size() != 1) continue;
                    argsList.set(index, bList.get(0));
                    continue;
                }
                if (methodCall.body() instanceof Object[]) {
                    bList = (Object[])methodCall.body();
                    if (bList.length != 1) continue;
                    argsList.set(index, bList[0]);
                    continue;
                }
                argsList.set(index, methodCall.body());
                continue;
            }
            if (paramBinding.isRequired() && !methodCall.params().containsKey(paramBinding.getName())) {
                Exceptions.die((Object[])new Object[]{"Method call missing required parameter", "\nParam Name", paramBinding.getName(), "\nMethod Call", methodCall, "\nFor method binding\n", binding, "\nFor method\n", method});
            }
            String name = paramBinding.getName();
            Object objectItem = methodCall.params().getSingleObject(name);
            if (objectItem == null || objectItem.equals("")) {
                objectItem = paramBinding.getDefaultValue();
            }
            objectItem = Conversions.coerce((Class)parameterTypes[index], (Object)objectItem);
            argsList.set(index, objectItem);
        }
        return argsList;
    }

    private List<Object> prepareArgumentList(MethodCall<Object> methodCall, Class<?>[] parameterTypes) {
        ArrayList<Object> argsList = new ArrayList<Object>(parameterTypes.length);
        for (Class<?> parameterType : parameterTypes) {
            if (parameterType == Callback.class) {
                argsList.add(this.createCallBackHandler(methodCall));
                continue;
            }
            argsList.add(null);
        }
        return argsList;
    }

    private Callback<Object> createCallBackHandler(MethodCall<Object> methodCall) {
        return new BoonCallBackWrapper(this.responseSendQueue, methodCall);
    }

    private Response<Object> invokeByName(MethodCall<Object> methodCall) {
        MethodAccess method = this.classMeta.method(methodCall.name());
        if (method != null) {
            return this.mapArgsAsyncHandlersAndInvoke(methodCall, method);
        }
        if (methodCall.name().equals("toString")) {
            IO.puts((Object[])new Object[]{"Method Call toString was called", methodCall.objectName(), methodCall.name(), methodCall.address()});
            return ResponseImpl.response(methodCall.id(), methodCall.timestamp(), methodCall.address(), methodCall.returnAddress(), Str.sputs((Object[])new Object[]{"Method Call toString was called", methodCall.objectName(), methodCall.name(), methodCall.address()}), methodCall, false);
        }
        return ResponseImpl.response(methodCall.id(), methodCall.timestamp(), methodCall.address(), methodCall.returnAddress(), new Exception("Unable to find method"), methodCall, true);
    }

    @Override
    public void init(Object service, String rootAddress, String serviceAddress, SendQueue<Response<Object>> responseSendQueue) {
        Class<?>[] interfaces;
        this.responseSendQueue = responseSendQueue;
        this.service = service;
        this.classMeta = ClassMeta.classMeta(service.getClass());
        this.addresses.add(Str.add((String[])new String[]{rootAddress, "/", this.classMeta.longName()}));
        this.addresses.add(Str.add((String[])new String[]{rootAddress, "/", this.classMeta.longName().toLowerCase()}));
        if (Str.isEmpty((String)serviceAddress)) {
            serviceAddress = this.readAddressFromAnnotation((Annotated)this.classMeta);
        }
        if (Str.isEmpty((String)serviceAddress)) {
            serviceAddress = Str.camelCaseLower((String)this.classMeta.name());
        }
        this.name = this.readNameFromAnnotation((Annotated)this.classMeta);
        if (Str.isEmpty((String)this.name)) {
            this.name = Str.uncapitalize((String)this.classMeta.name());
        }
        if (serviceAddress.endsWith("/")) {
            serviceAddress = Str.slc((String)serviceAddress, (int)0, (int)-1);
        }
        if (!Str.isEmpty((String)rootAddress)) {
            if (rootAddress.endsWith("/")) {
                rootAddress = Str.slc((String)rootAddress, (int)0, (int)-1);
            }
            this.address = serviceAddress.startsWith("/") ? Str.add((String)rootAddress, (String)serviceAddress) : Str.add((String[])new String[]{rootAddress, "/", serviceAddress});
        } else {
            this.address = serviceAddress;
        }
        Iterable methods = this.classMeta.methods();
        for (MethodAccess methodAccess2 : methods) {
            AnnotationData listen = AnnotationUtils.getListenAnnotation(methodAccess2);
            if (listen == null) continue;
            String channel = listen.getValues().get("value").toString();
            this.eventMap.put(channel, methodAccess2);
        }
        for (Class<?> interfaceClass : interfaces = this.classMeta.cls().getInterfaces()) {
            ClassMeta interfaceMeta;
            AnnotationData channelAnnotation;
            if (interfaceClass.getName().equals("groovy.lang.GroovyObject") || (channelAnnotation = (interfaceMeta = ClassMeta.classMeta(interfaceClass)).annotation(AnnotationUtils.EVENT_CHANNEL_ANNOTATION_NAME)) == null) continue;
            String classEventBusName = AnnotationUtils.getClassEventChannelName(interfaceMeta, channelAnnotation);
            interfaceMeta.methods().forEach(methodAccess -> {
                String methodEventBusName;
                AnnotationData methodAnnotation = methodAccess.annotation(AnnotationUtils.EVENT_CHANNEL_ANNOTATION_NAME);
                String string2 = methodEventBusName = methodAnnotation != null && methodAnnotation.getValues().get("value") != null ? methodAnnotation.getValues().get("value").toString() : null;
                if (Str.isEmpty(methodEventBusName)) {
                    methodEventBusName = methodAccess.name();
                }
                String channelName = AnnotationUtils.createChannelName(null, classEventBusName, methodEventBusName);
                this.eventMap.put(channelName, (MethodAccess)methodAccess);
            });
        }
        this.readMethodMetaData();
        this.initQueueHandlerMethods();
    }

    private void initQueueHandlerMethods() {
        this.queueCallBackHandler = QueueCallbackHandlerFactory.createQueueCallbackHandler(this.service);
    }

    @Override
    public void init() {
        this.queueCallBackHandler.queueInit();
    }

    @Override
    public void startBatch() {
        this.queueCallBackHandler.queueStartBatch();
    }

    private void readMethodMetaData() {
        Iterable methods = this.classMeta.methods();
        for (MethodAccess methodAccess : methods) {
            if (!methodAccess.isPublic()) continue;
            this.registerMethod(methodAccess);
        }
        this.addresses.addAll(this.methodMap.keySet());
    }

    private void registerMethod(MethodAccess methodAccess) {
        if (!methodAccess.hasAnnotation("RequestMapping") || !methodAccess.hasAnnotation("ServiceMethod")) {
            String methodAddress = this.readAddressFromAnnotation((Annotated)methodAccess);
            String httpMethod = this.readHttpMethod((Annotated)methodAccess);
            if (methodAddress != null && !methodAddress.isEmpty()) {
                this.doRegisterMethodUnderURI(httpMethod, methodAccess, methodAddress);
            }
        }
        this.doRegisterMethodUnderURI("GET", methodAccess, methodAccess.name());
        this.doRegisterMethodUnderURI("GET", methodAccess, methodAccess.name().toLowerCase());
        this.doRegisterMethodUnderURI("GET", methodAccess, methodAccess.name().toUpperCase());
    }

    private void doRegisterMethodUnderURI(String httpMethod, MethodAccess methodAccess, String methodAddress) {
        if (methodAddress.startsWith("/")) {
            methodAddress = Str.slc((String)methodAddress, (int)1);
        }
        MethodBinding methodBinding = new MethodBinding(httpMethod, methodAccess.name(), Str.join((char)'/', (String[])new String[]{this.address, methodAddress}));
        List annotationDataForParams = methodAccess.annotationDataForParams();
        int index = 0;
        for (List annotationDataListForParam : annotationDataForParams) {
            for (AnnotationData annotationData : annotationDataListForParam) {
                String name;
                if (annotationData.getName().equalsIgnoreCase("RequestParam")) {
                    name = (String)annotationData.getValues().get("value");
                    boolean required = (Boolean)annotationData.getValues().get("required");
                    String defaultValue = (String)annotationData.getValues().get("defaultValue");
                    methodBinding.addRequestParamBinding(methodAccess.parameterTypes().length, index, name, required, defaultValue);
                    continue;
                }
                if (!annotationData.getName().equalsIgnoreCase("Name")) continue;
                name = (String)annotationData.getValues().get("value");
                methodBinding.addRequestParamBinding(methodAccess.parameterTypes().length, index, name, false, null);
            }
            ++index;
        }
        Map<String, Pair<MethodBinding, MethodAccess>> mappings = this.methodMap.get(methodBinding.address());
        if (mappings == null) {
            mappings = new HashMap<String, Pair<MethodBinding, MethodAccess>>(4);
            this.methodMap.put(methodBinding.address(), mappings);
        }
        mappings.put(methodBinding.method(), (Pair<MethodBinding, MethodAccess>)new Pair((Object)methodBinding, (Object)methodAccess));
    }

    public TreeSet<String> addresses() {
        return this.addresses;
    }

    @Override
    public void queueInit() {
        this.queueCallBackHandler.queueInit();
    }

    @Override
    public void handleEvent(Event<Object> event) {
        MethodAccess methodAccess = this.eventMap.get(event.channel());
        if (this.invokeDynamic) {
            Object body = event.body();
            if (body instanceof List) {
                List list = (List)body;
                methodAccess.invokeDynamic(this.service, list.toArray(new Object[list.size()]));
            } else if (body instanceof Object[]) {
                Object[] array = (Object[])body;
                methodAccess.invokeDynamic(this.service, array);
            } else {
                methodAccess.invokeDynamicObject(this.service, body);
            }
        } else {
            Object body = event.body();
            if (body instanceof List) {
                List list = (List)body;
                methodAccess.invoke(this.service, list.toArray(new Object[list.size()]));
            } else if (body instanceof Object[]) {
                Object[] array = (Object[])body;
                methodAccess.invoke(this.service, array);
            } else {
                methodAccess.invoke(this.service, new Object[]{body});
            }
        }
    }

    private String readAddressFromAnnotation(Annotated annotated) {
        String address = this.getAddress("RequestMapping", annotated);
        if (Str.isEmpty((String)address)) {
            address = this.getAddress("Name", annotated);
        }
        if (Str.isEmpty((String)address)) {
            address = this.getAddress("Service", annotated);
        }
        if (Str.isEmpty((String)address)) {
            address = this.getAddress("ServiceMethod", annotated);
        }
        return address == null ? "" : address;
    }

    private String readHttpMethod(Annotated annotated) {
        String method = this.getHttpMethod("RequestMapping", annotated);
        return method == null || method.isEmpty() ? "GET" : method;
    }

    private String readNameFromAnnotation(Annotated annotated) {
        String name = this.getAddress("Named", annotated);
        if (Str.isEmpty((String)name)) {
            name = this.getAddress("Name", annotated);
        }
        if (Str.isEmpty((String)name)) {
            name = this.getAddress("Service", annotated);
        }
        if (Str.isEmpty((String)name)) {
            name = this.getAddress("ServiceName", annotated);
        }
        return name == null ? "" : name;
    }

    private String getHttpMethod(String name, Annotated annotated) {
        AnnotationData requestMapping = annotated.annotation(name);
        if (requestMapping != null) {
            Object[] values;
            Object value = requestMapping.getValues().get("method");
            if (value instanceof String[] && (values = (String[])value).length > 0 && values[0] != null && !values[0].isEmpty()) {
                return values[0];
            }
            if (value instanceof RequestMethod[]) {
                values = (RequestMethod[])value;
                if (values.length > 0 && values[0] != null) {
                    return ((Enum)((Object)values[0])).toString();
                }
            } else {
                return value.toString();
            }
        }
        return null;
    }

    private String getAddress(String name, Annotated annotated) {
        AnnotationData requestMapping = annotated.annotation(name);
        if (requestMapping != null) {
            Object value = requestMapping.getValues().get("value");
            if (value instanceof String[]) {
                String[] values = (String[])value;
                if (values.length > 0 && values[0] != null && !values[0].isEmpty()) {
                    return values[0];
                }
            } else {
                return (String)value;
            }
        }
        return null;
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void receive(MethodCall<Object> item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void empty() {
        this.queueCallBackHandler.queueEmpty();
    }

    @Override
    public void limit() {
        this.queueCallBackHandler.queueLimit();
    }

    @Override
    public void shutdown() {
        this.queueCallBackHandler.queueShutdown();
    }

    @Override
    public void idle() {
        this.queueCallBackHandler.queueIdle();
    }

    public Map<String, Map<String, Pair<MethodBinding, MethodAccess>>> methodMap() {
        return this.methodMap;
    }

    static class BoonCallBackWrapper
    implements Callback<Object> {
        final SendQueue<Response<Object>> responseSendQueue;
        final MethodCall<Object> methodCall;

        BoonCallBackWrapper(SendQueue<Response<Object>> responseSendQueue, MethodCall<Object> methodCall) {
            this.responseSendQueue = responseSendQueue;
            this.methodCall = methodCall;
        }

        @Override
        public void accept(Object result) {
            this.responseSendQueue.send(ResponseImpl.response(this.methodCall, result));
        }

        @Override
        public void onError(Throwable error) {
            this.responseSendQueue.send(ResponseImpl.error(this.methodCall, error));
        }

        @Override
        public void onTimeout() {
            this.responseSendQueue.send(ResponseImpl.error(this.methodCall, new TimeoutException("Method call " + this.methodCall.name() + " timed out ")));
        }
    }
}

