/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.boon.service.impl;

import io.advantageous.boon.core.Str;
import io.advantageous.boon.core.Sys;
import io.advantageous.boon.primitive.CharBuf;
import io.advantageous.qbit.Factory;
import io.advantageous.qbit.client.ClientProxy;
import io.advantageous.qbit.client.RemoteTCPClientProxy;
import io.advantageous.qbit.client.ServiceProxyFactory;
import io.advantageous.qbit.message.MethodCall;
import io.advantageous.qbit.message.MethodCallBuilder;
import io.advantageous.qbit.service.EndPoint;
import io.advantageous.qbit.util.Timer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class BoonServiceProxyFactory
implements ServiceProxyFactory {
    private static AtomicLong generatedMessageId = new AtomicLong();
    private final Factory factory;
    Object context = Sys.contextToHold();

    public BoonServiceProxyFactory(Factory factory) {
        this.factory = factory;
    }

    @Override
    public <T> T createProxyWithReturnAddress(Class<T> serviceInterface, final String serviceName, final String host, final int port, final AtomicBoolean connected, String returnAddressArg, final EndPoint endPoint) {
        String objectAddress;
        String string = objectAddress = endPoint != null ? Str.add((String[])new String[]{endPoint.address(), "/", serviceName}) : "";
        if (Str.isEmpty((String)returnAddressArg)) {
            returnAddressArg = Str.add((String)objectAddress, (String)("/" + UUID.randomUUID()));
        }
        final String returnAddress = returnAddressArg;
        final ThreadLocal<CharBuf> addressCreatorBufRef = new ThreadLocal<CharBuf>(){

            @Override
            protected CharBuf initialValue() {
                return CharBuf.createCharBuf((int)255);
            }
        };
        InvocationHandler invocationHandler = new InvocationHandler(){
            long timestamp = Timer.timer().now();
            int times = 10;

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                switch (method.getName()) {
                    case "port": {
                        return port;
                    }
                    case "host": {
                        return host;
                    }
                    case "silentClose": {
                        try {
                            assert (endPoint != null);
                            endPoint.stop();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    case "flush": 
                    case "clientProxyFlush": {
                        assert (endPoint != null);
                        endPoint.flush();
                        return null;
                    }
                    case "toString": {
                        return port == 0 ? Str.sputs((Object[])new Object[]{"{Local Proxy", serviceName, "}"}) : Str.sputs((Object[])new Object[]{"{Remote Proxy", serviceName, host, port, "}"});
                    }
                    case "equals": {
                        return proxy == args[0];
                    }
                    case "hashCode": {
                        return proxy.hashCode();
                    }
                    case "connected": {
                        return connected.get();
                    }
                }
                long messageId = generatedMessageId.incrementAndGet();
                --this.times;
                if (this.times == 0) {
                    this.timestamp = Timer.timer().now();
                    this.times = 10;
                } else {
                    ++this.timestamp;
                }
                CharBuf addressBuf = (CharBuf)addressCreatorBufRef.get();
                addressBuf.recycle();
                addressBuf.add(objectAddress).add("/").add(method.getName());
                String address = addressBuf.toString();
                MethodCall<Object> call = MethodCallBuilder.methodCallBuilder().setId(messageId).setAddress(address).setObjectName(serviceName).setReturnAddress(returnAddress).setName(method.getName()).setTimestamp(this.timestamp).setBody(args).build();
                assert (endPoint != null);
                endPoint.call(call);
                return null;
            }
        };
        if (port == 0) {
            return (T)Proxy.newProxyInstance(serviceInterface.getClassLoader(), new Class[]{serviceInterface, ClientProxy.class}, invocationHandler);
        }
        return (T)Proxy.newProxyInstance(serviceInterface.getClassLoader(), new Class[]{serviceInterface, RemoteTCPClientProxy.class}, invocationHandler);
    }

    @Override
    public <T> T createProxy(Class<T> serviceInterface, String serviceName, EndPoint endPoint) {
        return this.createProxyWithReturnAddress(serviceInterface, serviceName, "local", 0, new AtomicBoolean(true), "", endPoint);
    }
}

