/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.boon.service.impl;

import io.advantageous.boon.core.reflection.ClassMeta;
import io.advantageous.boon.core.reflection.MethodAccess;
import io.advantageous.qbit.boon.service.impl.queuecallbacks.AnnotationDrivenQueueCallbackHandler;
import io.advantageous.qbit.queue.QueueCallBackHandler;

public class QueueCallbackHandlerFactory {
    public static final String QUEUE_CALLBACK_ANNOTATION_NAME = "QueueCallback";

    static QueueCallBackHandler createQueueCallbackHandler(Object service) {
        if (service instanceof QueueCallBackHandler) {
            return (QueueCallBackHandler)service;
        }
        if (QueueCallbackHandlerFactory.hasQueueCallbackAnnotations(service)) {
            return new AnnotationDrivenQueueCallbackHandler(service);
        }
        return new QueueCallBackHandler(){

            @Override
            public void queueLimit() {
            }

            @Override
            public void queueEmpty() {
            }
        };
    }

    private static boolean hasQueueCallbackAnnotations(Object service) {
        ClassMeta classMeta = ClassMeta.classMeta(service.getClass());
        Iterable methods = classMeta.methods();
        for (MethodAccess methodAccess : methods) {
            if (!methodAccess.hasAnnotation(QUEUE_CALLBACK_ANNOTATION_NAME)) continue;
            return true;
        }
        return false;
    }
}

