/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.boon.service.impl.queuecallbacks;

import io.advantageous.boon.core.reflection.AnnotationData;
import io.advantageous.boon.core.reflection.ClassMeta;
import io.advantageous.boon.core.reflection.MethodAccess;
import io.advantageous.qbit.annotation.QueueCallbackType;
import io.advantageous.qbit.queue.QueueCallBackHandler;

public class AnnotationDrivenQueueCallbackHandler
implements QueueCallBackHandler {
    public static final String QUEUE_CALLBACK_ANNOTATION_NAME = "QueueCallback";
    private final Object service;
    private MethodAccess queueStartBatch;
    private MethodAccess queueInit;
    private MethodAccess queueEmpty;
    private MethodAccess queueLimit;
    private MethodAccess queueShutdown;
    private MethodAccess queueIdle;

    public AnnotationDrivenQueueCallbackHandler(Object service) {
        ClassMeta classMeta = ClassMeta.classMeta(service.getClass());
        this.service = service;
        Iterable methods = classMeta.methods();
        for (MethodAccess methodAccess : methods) {
            if (!methodAccess.hasAnnotation(QUEUE_CALLBACK_ANNOTATION_NAME)) continue;
            this.processAnnotationForMethod(methodAccess);
        }
    }

    private void processAnnotationForMethod(MethodAccess methodAccess) {
        Object[] values;
        AnnotationData annotation = methodAccess.annotation(QUEUE_CALLBACK_ANNOTATION_NAME);
        block25: for (Object value : values = (Object[])annotation.getValues().get("value")) {
            QueueCallbackType queueCallbackType = QueueCallbackType.valueOf(value.toString());
            block0 : switch (queueCallbackType) {
                case IDLE: {
                    this.queueIdle = methodAccess;
                    continue block25;
                }
                case SHUTDOWN: {
                    this.queueShutdown = methodAccess;
                    continue block25;
                }
                case LIMIT: {
                    this.queueLimit = methodAccess;
                    continue block25;
                }
                case INIT: {
                    this.queueLimit = methodAccess;
                    continue block25;
                }
                case START_BATCH: {
                    this.queueStartBatch = methodAccess;
                    continue block25;
                }
                case EMPTY: {
                    this.queueEmpty = methodAccess;
                    continue block25;
                }
                case DYNAMIC: {
                    switch (methodAccess.name()) {
                        case "queueIdle": {
                            this.queueIdle = methodAccess;
                            break block0;
                        }
                        case "queueShutdown": {
                            this.queueShutdown = methodAccess;
                            break block0;
                        }
                        case "queueLimit": {
                            this.queueLimit = methodAccess;
                            break block0;
                        }
                        case "queueInit": {
                            this.queueInit = methodAccess;
                            break block0;
                        }
                        case "queueStartBatch": {
                            this.queueIdle = methodAccess;
                            break block0;
                        }
                        case "queueEmpty": {
                            this.queueEmpty = methodAccess;
                        }
                    }
                }
            }
        }
    }

    @Override
    public void queueLimit() {
        if (this.queueLimit != null) {
            this.queueLimit.invoke(this.service, new Object[0]);
        }
    }

    @Override
    public void queueEmpty() {
        if (this.queueEmpty != null) {
            this.queueEmpty.invoke(this.service, new Object[0]);
        }
    }

    @Override
    public void queueInit() {
        if (this.queueInit != null) {
            this.queueInit.invoke(this.service, new Object[0]);
        }
    }

    @Override
    public void queueIdle() {
        if (this.queueIdle != null) {
            this.queueIdle.invoke(this.service, new Object[0]);
        }
    }

    @Override
    public void queueShutdown() {
        if (this.queueShutdown != null) {
            this.queueShutdown.invoke(this.service, new Object[0]);
        }
    }

    @Override
    public void queueStartBatch() {
        if (this.queueStartBatch != null) {
            this.queueStartBatch.invoke(this.service, new Object[0]);
        }
    }
}

