/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.boon.service.impl.queuecallbacks;

import io.advantageous.boon.core.reflection.ClassMeta;
import io.advantageous.boon.core.reflection.MethodAccess;
import io.advantageous.qbit.queue.QueueCallBackHandler;

public class DynamicQueueCallbackHandler
implements QueueCallBackHandler {
    private final Object service;
    private final MethodAccess queueStartBatch;
    private final MethodAccess queueInit;
    private final MethodAccess queueEmpty;
    private final MethodAccess queueLimit;
    private final MethodAccess queueShutdown;
    private final MethodAccess queueIdle;

    public DynamicQueueCallbackHandler(Object service) {
        this.service = service;
        ClassMeta classMeta = ClassMeta.classMeta(service.getClass());
        this.queueLimit = classMeta.method("queueLimit");
        this.queueEmpty = classMeta.method("queueEmpty");
        this.queueShutdown = classMeta.method("queueShutdown");
        this.queueIdle = classMeta.method("queueIdle");
        this.queueInit = classMeta.method("queueInit");
        this.queueStartBatch = classMeta.method("queueStartBatch");
    }

    @Override
    public void queueLimit() {
        if (this.queueLimit != null) {
            this.queueLimit.invoke(this.service, new Object[0]);
        }
    }

    @Override
    public void queueEmpty() {
        if (this.queueEmpty != null) {
            this.queueEmpty.invoke(this.service, new Object[0]);
        }
    }

    @Override
    public void queueInit() {
        if (this.queueInit != null) {
            this.queueInit.invoke(this.service, new Object[0]);
        }
    }

    @Override
    public void queueIdle() {
        if (this.queueIdle != null) {
            this.queueIdle.invoke(this.service, new Object[0]);
        }
    }

    @Override
    public void queueShutdown() {
        if (this.queueShutdown != null) {
            this.queueShutdown.invoke(this.service, new Object[0]);
        }
    }

    @Override
    public void queueStartBatch() {
        if (this.queueStartBatch != null) {
            this.queueStartBatch.invoke(this.service, new Object[0]);
        }
    }
}

