/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.boon.spi;

import io.advantageous.boon.core.Conversions;
import io.advantageous.boon.core.Sets;
import io.advantageous.boon.core.Value;
import io.advantageous.boon.core.reflection.Mapper;
import io.advantageous.boon.core.reflection.MapperComplex;
import io.advantageous.boon.core.reflection.fields.FieldAccessMode;
import io.advantageous.boon.core.value.ValueContainer;
import io.advantageous.boon.core.value.ValueMap;
import io.advantageous.boon.json.JsonParserAndMapper;
import io.advantageous.boon.json.JsonParserFactory;
import io.advantageous.boon.json.JsonSerializer;
import io.advantageous.boon.json.JsonSerializerFactory;
import io.advantageous.qbit.json.JsonMapper;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;

public class BoonJsonMapper
implements JsonMapper {
    private final ThreadLocal<JsonParserAndMapper> parser = new ThreadLocal<JsonParserAndMapper>(){

        @Override
        protected JsonParserAndMapper initialValue() {
            return new JsonParserFactory().setIgnoreSet(Sets.set((Object[])new String[]{"metaClass"})).createFastObjectMapperParser();
        }
    };
    private final ThreadLocal<JsonSerializer> serializer = new ThreadLocal<JsonSerializer>(){

        @Override
        protected JsonSerializer initialValue() {
            return new JsonSerializerFactory().setUseAnnotations(true).addFilter((parent, fieldAccess) -> !fieldAccess.name().equals("metaClass")).create();
        }
    };
    private final ThreadLocal<Mapper> mapper = new ThreadLocal<Mapper>(){

        @Override
        protected Mapper initialValue() {
            return new MapperComplex(false, FieldAccessMode.PROPERTY_THEN_FIELD, true, false, Collections.emptySet(), null, true, true);
        }
    };

    @Override
    public Object fromJson(String json) {
        return this.parser.get().parse(json);
    }

    @Override
    public <T> T fromJson(String json, Class<T> cls) {
        return (T)this.parser.get().parse(cls, json);
    }

    @Override
    public <T> List<T> fromJsonArray(String json, Class<T> componentClass) {
        return this.parser.get().parseList(componentClass, json);
    }

    @Override
    public String toJson(Object object) {
        return this.serializer.get().serialize(object).toString();
    }

    @Override
    public <K, V> Map<K, V> fromJsonMap(String json, Class<K> componentClassKey, Class<V> componentClassValue) {
        Map map = (Map)this.parser.get().parse(json);
        Mapper mapper = this.mapper.get();
        TreeMap results = new TreeMap();
        map.entrySet().forEach(entry -> {
            Object value = entry.getValue() instanceof ValueContainer ? ((ValueContainer)entry.getValue()).toValue() : entry.getValue();
            Object key = entry.getKey() instanceof ValueContainer ? ((ValueContainer)entry.getKey()).toValue() : entry.getKey();
            Object convertedKey = key instanceof Map ? mapper.fromMap((Map)key, componentClassKey) : Conversions.coerce((Class)componentClassKey, key);
            Object convertedValue = value instanceof Map ? (componentClassValue != Object.class ? mapper.fromMap((Map)value, componentClassValue) : (value instanceof ValueMap ? this.convertToMap((ValueMap)value) : value)) : (componentClassValue != Object.class ? Conversions.coerce((Class)componentClassValue, value) : (value instanceof Value ? ((Value)value).toValue() : value));
            results.put(convertedKey, convertedValue);
        });
        return results;
    }

    private <V> V convertToMap(ValueMap valueMap) {
        final LinkedHashMap map = new LinkedHashMap(valueMap.size());
        valueMap.entrySet().forEach(new Consumer<Map.Entry<String, Object>>(){

            @Override
            public void accept(Map.Entry<String, Object> entry) {
                Object value = entry.getValue();
                if (value instanceof ValueContainer) {
                    ValueContainer valueContainer = (ValueContainer)entry.getValue();
                    value = valueContainer.toValue();
                }
                if (value instanceof Value) {
                    map.put(entry.getKey(), ((Value)entry.getValue()).toValue());
                } else if (value instanceof ValueMap) {
                    map.put(entry.getKey(), BoonJsonMapper.this.convertToMap((ValueMap)value));
                } else {
                    map.put(entry.getKey(), value);
                }
            }
        });
        return (V)map;
    }
}

