/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.boon.spi;

import io.advantageous.boon.json.JsonSerializer;
import io.advantageous.boon.json.JsonSerializerFactory;
import io.advantageous.boon.primitive.CharBuf;
import io.advantageous.qbit.message.Message;
import io.advantageous.qbit.message.MethodCall;
import io.advantageous.qbit.message.Response;
import io.advantageous.qbit.spi.ProtocolEncoder;
import io.advantageous.qbit.util.MultiMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class BoonProtocolEncoder
implements ProtocolEncoder {
    private final ThreadLocal<JsonSerializer> jsonSerializer = new ThreadLocal<JsonSerializer>(){

        @Override
        protected JsonSerializer initialValue() {
            return new JsonSerializerFactory().addFilter((parent, fieldAccess) -> !fieldAccess.name().equals("metaClass")).create();
        }
    };
    private final ThreadLocal<CharBuf> bufRef = new ThreadLocal<CharBuf>(){

        @Override
        protected CharBuf initialValue() {
            return CharBuf.createCharBuf((int)1000);
        }
    };

    @Override
    public String encodeAsString(Response<Object> response) {
        CharBuf buf = CharBuf.createCharBuf();
        this.encodeAsString(buf, response, true);
        return buf.toString();
    }

    @Override
    public String encodeAsString(MethodCall<Object> methodCall) {
        CharBuf buf = CharBuf.createCharBuf();
        this.encodeAsString(buf, methodCall, true);
        return buf.toString();
    }

    @Override
    public String encodeAsString(Collection<Message<Object>> messages) {
        CharBuf buf = this.bufRef.get();
        buf.recycle();
        buf.addChar(28);
        buf.addChar(103);
        int index = 0;
        for (Message<Object> message : messages) {
            boolean encodeAddress;
            boolean bl = encodeAddress = index == 0;
            if (message instanceof MethodCall) {
                this.encodeAsString(buf, (MethodCall)message, encodeAddress);
            } else if (message instanceof Response) {
                this.encodeAsString(buf, (Response)message, encodeAddress);
            }
            buf.addChar(31);
            ++index;
        }
        return buf.toString();
    }

    private void encodeAsString(CharBuf buf, MethodCall<Object> methodCall, boolean encodeAddress) {
        buf.addChar(28);
        buf.addChar(109);
        buf.addChar(29);
        buf.add(methodCall.id());
        buf.addChar(29);
        buf.add(methodCall.address());
        buf.addChar(29);
        buf.add(methodCall.returnAddress());
        buf.addChar(29);
        this.encodeHeadersAndParams(buf, methodCall.headers());
        buf.addChar(29);
        this.encodeHeadersAndParams(buf, methodCall.params());
        buf.addChar(29);
        buf.add(methodCall.objectName());
        buf.addChar(29);
        buf.add(methodCall.name());
        buf.addChar(29);
        buf.add(methodCall.timestamp());
        buf.addChar(29);
        Object body = methodCall.body();
        JsonSerializer serializer = this.jsonSerializer.get();
        if (body instanceof Iterable) {
            Iterable iter = (Iterable)body;
            for (Object bodyPart : iter) {
                serializer.serialize(buf, bodyPart);
                buf.addChar(30);
            }
        } else if (body instanceof Object[]) {
            Object[] args = (Object[])body;
            for (int index = 0; index < args.length; ++index) {
                Object bodyPart = args[index];
                serializer.serialize(buf, bodyPart);
                buf.addChar(30);
            }
        } else if (body != null) {
            serializer.serialize(buf, body);
        }
    }

    private void encodeAsString(CharBuf buf, Response<Object> response, boolean encodeAddress) {
        buf.addChar(28);
        buf.addChar(114);
        buf.addChar(29);
        buf.add(response.id());
        buf.addChar(29);
        buf.add(response.address());
        buf.addChar(29);
        buf.add(response.returnAddress());
        buf.addChar(29);
        buf.addChar(29);
        buf.addChar(29);
        buf.addChar(29);
        buf.addChar(29);
        buf.add(response.timestamp());
        buf.addChar(29);
        buf.add(response.wasErrors() ? 1 : 0);
        buf.addChar(29);
        Object body = response.body();
        JsonSerializer serializer = this.jsonSerializer.get();
        if (body != null) {
            serializer.serialize(buf, body);
        } else {
            buf.addNull();
        }
    }

    private void encodeHeadersAndParams(CharBuf buf, MultiMap<String, String> headerOrParams) {
        if (headerOrParams == null) {
            return;
        }
        Map<String, Collection<String>> map = headerOrParams.baseMap();
        Set<Map.Entry<String, Collection<String>>> entries = map.entrySet();
        for (Map.Entry<String, Collection<String>> entry : entries) {
            Collection<String> values = entry.getValue();
            if (values.size() == 0) continue;
            buf.add(entry.getKey());
            buf.addChar(26);
            for (String value : values) {
                buf.add(value);
                buf.addChar(21);
            }
            buf.addChar(25);
        }
    }
}

