/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.boon.spi;

import io.advantageous.boon.core.Exceptions;
import io.advantageous.boon.core.Lists;
import io.advantageous.boon.core.Str;
import io.advantageous.boon.core.reflection.FastStringUtils;
import io.advantageous.boon.json.JsonParserAndMapper;
import io.advantageous.boon.json.JsonParserFactory;
import io.advantageous.boon.primitive.CharScanner;
import io.advantageous.boon.primitive.Chr;
import io.advantageous.qbit.message.Message;
import io.advantageous.qbit.message.MethodCall;
import io.advantageous.qbit.message.MethodCallBuilder;
import io.advantageous.qbit.message.Response;
import io.advantageous.qbit.message.impl.ResponseImpl;
import io.advantageous.qbit.spi.ProtocolParser;
import io.advantageous.qbit.util.MultiMap;
import io.advantageous.qbit.util.MultiMapImpl;
import java.util.ArrayList;
import java.util.List;

public class BoonProtocolParser
implements ProtocolParser {
    private final JsonParserAndMapper jsonParser = new JsonParserFactory().create();

    private Message<Object> parseMessageFromString(String addressPrefix, String args) {
        if (args.isEmpty()) {
            return null;
        }
        char[] chars = FastStringUtils.toCharArray((String)args);
        return this.parseMessageFromChars(addressPrefix, chars, null);
    }

    @Override
    public boolean supports(Object args, MultiMap<String, String> params) {
        if (!(args instanceof String)) {
            return false;
        }
        String stringArgs = (String)args;
        return stringArgs.length() > 2 && stringArgs.charAt(0) == '\u001c' && (stringArgs.charAt(1) == 'm' || stringArgs.charAt(1) == 'g' || stringArgs.charAt(1) == 'r');
    }

    @Override
    public MethodCall<Object> parseMethodCall(Object body) {
        return this.parseMethodCallUsingAddressPrefix("", body);
    }

    @Override
    public MethodCall<Object> parseMethodCallUsingAddressPrefix(String addressPrefix, Object body) {
        if (body != null && body instanceof String) {
            return (MethodCall)this.parseMessageFromString(addressPrefix, (String)body);
        }
        return null;
    }

    @Override
    public List<Message<Object>> parse(String address, Object body) {
        if (!(body instanceof String)) {
            Exceptions.die((String)"Body must be a string at this point");
            return null;
        }
        String args = (String)body;
        if (args.isEmpty()) {
            return null;
        }
        char[] chars = FastStringUtils.toCharArray((String)args);
        if (chars.length > 2 && chars[0] == '\u001c') {
            char versionMarker = chars[1];
            if (versionMarker == 'm') {
                return Lists.list((Object[])new Message[]{this.handleFastBodySubmissionVersion1Chars("", chars, null)});
            }
            if (versionMarker == 'r') {
                return Lists.list((Object[])new Message[]{this.parseResponseFromChars("", chars, null)});
            }
            if (versionMarker == 'g') {
                String returnAddress = null;
                char[][] messageBuffers = CharScanner.splitFrom((char[])chars, (char)'\u001f', (int)2);
                ArrayList<Message<Object>> messages = new ArrayList<Message<Object>>(messageBuffers.length);
                int index = 0;
                for (char[] methodCall : messageBuffers) {
                    Message<Object> m = this.parseMessageFromChars(address, methodCall, returnAddress);
                    if (index == 0) {
                        if (m instanceof MethodCall) {
                            MethodCall call = (MethodCall)m;
                            returnAddress = call.returnAddress();
                        } else if (m instanceof Response) {
                            Response response = (Response)m;
                            returnAddress = response.returnAddress();
                        }
                    }
                    messages.add(m);
                    ++index;
                }
                return messages;
            }
            Exceptions.die((Object[])new Object[]{"Unsupported method call", args});
            return null;
        }
        return null;
    }

    @Override
    public List<MethodCall<Object>> parseMethods(Object body) {
        return this.parse("", body);
    }

    @Override
    public List<MethodCall<Object>> parseMethodCallListUsingAddressPrefix(String addressPrefix, Object body) {
        return this.parse("", body);
    }

    @Override
    public Response<Object> parseResponse(Object body) {
        char[] args;
        if (body instanceof String && (args = FastStringUtils.toCharArray((String)((String)body))).length > 2 && args[0] == '\u001c') {
            char versionMarker = args[1];
            if (versionMarker == 'r') {
                return this.parseResponseFromChars("", args, null);
            }
            return null;
        }
        return null;
    }

    private Response<Object> parseResponseFromChars(String addressPrefix, char[] args, String parentReturnAddress) {
        char[] wasErrorsStr;
        char[][] chars = CharScanner.splitFromStartWithLimit((char[])args, (char)'\u001d', (int)0, (int)10);
        String messageId = FastStringUtils.noCopyStringFromChars((char[])chars[1]);
        long id = 0L;
        if (!Str.isEmpty((String)messageId)) {
            id = Long.parseLong(messageId);
        }
        String address = FastStringUtils.noCopyStringFromChars((char[])chars[2]);
        String returnAddress = FastStringUtils.noCopyStringFromChars((char[])chars[3]);
        String stime = FastStringUtils.noCopyStringFromChars((char[])chars[8]);
        long timestamp = 0L;
        if (!Str.isEmpty((String)stime)) {
            timestamp = Long.parseLong(stime);
        }
        boolean wasErrors = (wasErrorsStr = chars[9]) != null && wasErrorsStr.length == 1 && wasErrorsStr[0] == '1';
        char[] messageBodyChars = chars[10];
        Object messageBody = !Chr.isEmpty((char[])messageBodyChars) ? this.jsonParser.parse(messageBodyChars) : null;
        return new ResponseImpl<Object>(id, timestamp, address, returnAddress, null, messageBody, null, wasErrors);
    }

    private Message<Object> parseMessageFromChars(String addressPrefix, char[] chars, String returnAddress) {
        if (chars.length > 2 && chars[0] == '\u001c') {
            char versionMarker = chars[1];
            if (versionMarker == 'm') {
                return this.handleFastBodySubmissionVersion1Chars(addressPrefix, chars, returnAddress);
            }
            if (versionMarker == 'r') {
                return this.parseResponseFromChars(addressPrefix, chars, returnAddress);
            }
            Exceptions.die((Object[])new Object[]{"Unsupported method call", new String(chars)});
            return null;
        }
        return null;
    }

    private MethodCall<Object> handleFastBodySubmissionVersion1Chars(String addressPrefix, char[] args, String parentReturnAddress) {
        char[] charArgs;
        char[][] chars = CharScanner.splitFromStartWithLimit((char[])args, (char)'\u001d', (int)0, (int)9);
        long id = 0L;
        if (!Chr.isEmpty((char[])chars[1])) {
            id = CharScanner.parseLong((char[])chars[1]);
        }
        String address = FastStringUtils.noCopyStringFromChars((char[])chars[2]);
        String returnAddress = FastStringUtils.noCopyStringFromChars((char[])chars[3]);
        if (!Str.isEmpty((String)addressPrefix)) {
            returnAddress = Str.add((String[])new String[]{addressPrefix, "\u001e", returnAddress});
        }
        String headerBlock = FastStringUtils.noCopyStringFromChars((char[])chars[4]);
        MultiMap<String, String> headers = this.parseHeaders(headerBlock);
        String paramBlock = FastStringUtils.noCopyStringFromChars((char[])chars[5]);
        MultiMap<String, String> params = this.parseHeaders(paramBlock);
        String methodName = FastStringUtils.noCopyStringFromChars((char[])chars[7]);
        String objectName = FastStringUtils.noCopyStringFromChars((char[])chars[6]);
        long timestamp = 0L;
        if (!Chr.isEmpty((char[])chars[8])) {
            timestamp = CharScanner.parseLong((char[])chars[8]);
        }
        char[] body = chars[9];
        char[][] argumentList = CharScanner.split((char[])body, (char)'\u001e');
        Object[] argList = new Object[argumentList.length];
        for (int index = 0; index < argumentList.length && (charArgs = argumentList[index]).length != 0; ++index) {
            Object arg;
            argList[index] = arg = this.jsonParser.parse(charArgs);
        }
        return new MethodCallBuilder().setId(id).setAddress(address).setReturnAddress(returnAddress).setHeaders(headers).setObjectName(objectName).setName(methodName).setTimestamp(timestamp).setBody(argList).setParams(params).build();
    }

    public MultiMap<String, String> parseHeaders(String header) {
        char[][] split;
        if (Str.isEmpty((String)header)) {
            return null;
        }
        MultiMapImpl<String, String> params = new MultiMapImpl<String, String>();
        for (char[] entry : split = CharScanner.split((char[])FastStringUtils.toCharArray((String)header), (char)'\u0019')) {
            char[][] kvSplit = CharScanner.split((char[])entry, (char)'\u001a');
            if (kvSplit.length <= 1) continue;
            char[] ckey = kvSplit[0];
            char[] valuesAsOne = kvSplit[1];
            char[][] values = CharScanner.split((char[])valuesAsOne, (char)'\u0015');
            String key = new String(ckey);
            for (char[] value : values) {
                params.add(key, new String(value));
            }
        }
        return params;
    }
}

