/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.client;

import io.advantageous.qbit.Factory;
import io.advantageous.qbit.QBit;
import io.advantageous.qbit.client.Client;
import io.advantageous.qbit.config.PropertyResolver;
import io.advantageous.qbit.http.client.HttpClientBuilder;
import io.advantageous.qbit.service.discovery.EndpointDefinition;
import io.advantageous.qbit.service.discovery.ServiceDiscovery;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class ClientBuilder {
    public static final String QBIT_CLIENT_BUILDER = "qbit.client.builder.";
    private int protocolBatchSize = 10;
    private String uri;
    private HttpClientBuilder httpClientBuilder;
    private ServiceDiscovery serviceDiscovery;
    private Factory factory;
    private String serviceName;

    public Factory getFactory() {
        if (this.factory == null) {
            this.factory = QBit.factory();
        }
        return this.factory;
    }

    public ClientBuilder setFactory(Factory factory) {
        this.factory = factory;
        return this;
    }

    public ClientBuilder(PropertyResolver propertyResolver) {
        HttpClientBuilder httpClientBuilder = this.getHttpClientBuilder();
        httpClientBuilder.setAutoFlush(propertyResolver.getBooleanProperty("autoFlush", true));
        httpClientBuilder.setHost(propertyResolver.getStringProperty("host", "localhost"));
        httpClientBuilder.setPort(propertyResolver.getIntegerProperty("port", 8080));
        httpClientBuilder.setPoolSize(propertyResolver.getIntegerProperty("poolSize", 1));
        httpClientBuilder.setKeepAlive(propertyResolver.getBooleanProperty("keepAlive", true));
        httpClientBuilder.setPipeline(propertyResolver.getBooleanProperty("pipeline", true));
        httpClientBuilder.setTimeOutInMilliseconds(propertyResolver.getIntegerProperty("timeOutInMilliseconds", 3000));
        this.protocolBatchSize = propertyResolver.getIntegerProperty("protocolBatchSize", this.protocolBatchSize);
        httpClientBuilder.setTimeOutInMilliseconds(propertyResolver.getIntegerProperty("flushInterval", 500));
        this.uri = propertyResolver.getStringProperty("uri", "/services");
        httpClientBuilder.setTimeOutInMilliseconds(propertyResolver.getIntegerProperty("timeoutSeconds", 30) * 1000);
    }

    public ClientBuilder() {
        this(PropertyResolver.createSystemPropertyResolver(QBIT_CLIENT_BUILDER));
    }

    public ClientBuilder(Properties properties) {
        this(PropertyResolver.createPropertiesPropertyResolver(QBIT_CLIENT_BUILDER, properties));
    }

    public static ClientBuilder clientBuilder() {
        return new ClientBuilder();
    }

    public int getTimeOutInMilliseconds() {
        return this.getHttpClientBuilder().getTimeOutInMilliseconds();
    }

    public ClientBuilder setTimeOutInMilliseconds(int timeOutInMilliseconds) {
        this.getHttpClientBuilder().setTimeOutInMilliseconds(timeOutInMilliseconds);
        return this;
    }

    public int getPoolSize() {
        return this.getHttpClientBuilder().getPoolSize();
    }

    public ClientBuilder setPoolSize(int poolSize) {
        this.getHttpClientBuilder().setPoolSize(poolSize);
        return this;
    }

    public boolean isKeepAlive() {
        return this.getHttpClientBuilder().isKeepAlive();
    }

    public ClientBuilder setKeepAlive(boolean keepAlive) {
        this.getHttpClientBuilder().setKeepAlive(keepAlive);
        return this;
    }

    public boolean isPipeline() {
        return this.getHttpClientBuilder().isPipeline();
    }

    public ClientBuilder setPipeline(boolean pipeline) {
        this.getHttpClientBuilder().setPipeline(pipeline);
        return this;
    }

    public String getUri() {
        return this.uri;
    }

    public ClientBuilder setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public int getTimeoutSeconds() {
        int timeOutInMilliseconds = this.getHttpClientBuilder().getTimeOutInMilliseconds();
        if (timeOutInMilliseconds > 0) {
            return timeOutInMilliseconds / 1000;
        }
        return 0;
    }

    public ClientBuilder setTimeoutSeconds(int timeoutSeconds) {
        this.getHttpClientBuilder().setTimeOutInMilliseconds(timeoutSeconds * 1000);
        return this;
    }

    public String getHost() {
        return this.getHttpClientBuilder().getHost();
    }

    public ClientBuilder setHost(String host) {
        this.getHttpClientBuilder().setHost(host);
        return this;
    }

    public ClientBuilder setHostAndPort(InetSocketAddress inetSocketAddress) {
        this.setHost(inetSocketAddress.getHostName());
        this.setPort(inetSocketAddress.getPort());
        return this;
    }

    public ClientBuilder setHostAndPort(URI uri) {
        this.setHost(uri.getHost());
        this.setPort(uri.getPort());
        return this;
    }

    public ClientBuilder setHostAndPort(URL url) {
        this.setHost(url.getHost());
        this.setPort(url.getPort());
        return this;
    }

    public int getPort() {
        return this.getHttpClientBuilder().getPort();
    }

    public ClientBuilder setPort(int port) {
        this.getHttpClientBuilder().setPort(port);
        return this;
    }

    public boolean isAutoFlush() {
        return this.getHttpClientBuilder().isAutoFlush();
    }

    public ClientBuilder setAutoFlush(boolean autoFlush) {
        this.getHttpClientBuilder().setAutoFlush(autoFlush);
        return this;
    }

    public int getFlushInterval() {
        return this.getHttpClientBuilder().getFlushInterval();
    }

    public ClientBuilder setFlushInterval(int flushInterval) {
        this.getHttpClientBuilder().setFlushInterval(flushInterval);
        return this;
    }

    public int getProtocolBatchSize() {
        return this.protocolBatchSize;
    }

    public ClientBuilder setProtocolBatchSize(int protocolBatchSize) {
        this.protocolBatchSize = protocolBatchSize;
        return this;
    }

    public HttpClientBuilder getHttpClientBuilder() {
        if (this.httpClientBuilder == null) {
            this.httpClientBuilder = HttpClientBuilder.httpClientBuilder();
        }
        return this.httpClientBuilder;
    }

    public void setHttpClientBuilder(HttpClientBuilder httpClientBuilder) {
        this.httpClientBuilder = httpClientBuilder;
    }

    public ClientBuilder setServiceDiscovery(ServiceDiscovery serviceDiscovery, String serviceName) {
        this.serviceDiscovery = serviceDiscovery;
        this.setServiceName(serviceName);
        return this;
    }

    public ServiceDiscovery getServiceDiscovery() {
        return this.serviceDiscovery;
    }

    public ClientBuilder setServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Client build() {
        HttpClientBuilder httpClientBuilder = this.getHttpClientBuilder();
        ServiceDiscovery serviceDiscovery = this.getServiceDiscovery();
        if (serviceDiscovery != null && this.getServiceName() != null) {
            List<EndpointDefinition> endpointDefinitions = serviceDiscovery.loadServices(this.getServiceName());
            if (endpointDefinitions == null || endpointDefinitions.size() == 0) {
                endpointDefinitions = serviceDiscovery.loadServicesNow(this.getServiceName());
            }
            if (endpointDefinitions != null && endpointDefinitions.size() > 0) {
                endpointDefinitions = new ArrayList<EndpointDefinition>(endpointDefinitions);
                Collections.shuffle(endpointDefinitions);
                EndpointDefinition endpointDefinition = endpointDefinitions.get(0);
                httpClientBuilder.setPort(endpointDefinition.getPort()).setHost(endpointDefinition.getHost());
            }
        }
        Client client = this.getFactory().createClient(this.getUri(), httpClientBuilder.build(), this.getProtocolBatchSize());
        return client;
    }
}

