/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.concurrent;

import io.advantageous.qbit.concurrent.ExecutorContext;
import io.advantageous.qbit.concurrent.ScheduledThreadContext;
import java.util.concurrent.TimeUnit;

public class ScheduledExecutorBuilder {
    private int initialDelay = 50;
    private int period = 50;
    private TimeUnit unit = TimeUnit.MILLISECONDS;
    private String threadName;
    private String description;
    private Runnable runnable;
    private int priority = 5;
    private boolean daemon;

    public static ScheduledExecutorBuilder scheduledExecutorBuilder() {
        return new ScheduledExecutorBuilder();
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public ScheduledExecutorBuilder setDaemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public ScheduledExecutorBuilder setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    public ScheduledExecutorBuilder setRunnable(Runnable runnable) {
        this.runnable = runnable;
        return this;
    }

    public int getInitialDelay() {
        return this.initialDelay;
    }

    public ScheduledExecutorBuilder setInitialDelay(int initialDelay) {
        this.initialDelay = initialDelay;
        return this;
    }

    public int getPeriod() {
        return this.period;
    }

    public ScheduledExecutorBuilder setPeriod(int period) {
        this.period = period;
        return this;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public ScheduledExecutorBuilder setUnit(TimeUnit unit) {
        this.unit = unit;
        return this;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public ScheduledExecutorBuilder setThreadName(String threadName) {
        this.threadName = threadName;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public ScheduledExecutorBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public ExecutorContext build() {
        return new ScheduledThreadContext(this.getRunnable(), this.getInitialDelay(), this.getPeriod(), this.getUnit(), this.getThreadName(), this.getDescription(), this.priority, this.daemon);
    }
}

