/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.concurrent;

import io.advantageous.qbit.GlobalConstants;
import io.advantageous.qbit.concurrent.ExecutorContext;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledThreadContext
implements ExecutorContext {
    private final Logger logger = LoggerFactory.getLogger(ScheduledThreadContext.class);
    private final boolean debug = GlobalConstants.DEBUG || this.logger.isDebugEnabled();
    private final int priority;
    private final boolean daemon;
    private final Runnable runnable;
    private final int initialDelay;
    private final int period;
    private final TimeUnit unit;
    private final String threadName;
    private final String description;
    private ScheduledExecutorService monitor;
    private ScheduledFuture<?> future;

    public ScheduledThreadContext(Runnable runnable, int initialDelay, int period, TimeUnit unit, String threadName, String description, int priority, boolean daemon) {
        this.initialDelay = initialDelay;
        this.period = period;
        this.unit = unit;
        this.runnable = runnable;
        this.threadName = threadName;
        this.description = description;
        this.priority = priority;
        this.daemon = daemon;
    }

    @Override
    public void start() {
        if (this.debug) {
            this.logger.debug("Started:" + this.description);
        }
        if (this.monitor != null) {
            throw new IllegalStateException(this.description + " Must be stopped before it can be started");
        }
        this.monitor = Executors.newScheduledThreadPool(1, runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName(this.threadName);
            thread.setPriority(this.priority);
            thread.setDaemon(this.daemon);
            return thread;
        });
        this.future = this.monitor.scheduleAtFixedRate(() -> {
            try {
                this.runnable.run();
            }
            catch (Exception ex) {
                this.logger.error("Problem running: " + this.description, (Throwable)ex);
            }
        }, this.initialDelay, this.period, this.unit);
    }

    @Override
    public void stop() {
        if (this.debug) {
            this.logger.debug("Stopped: " + this.description);
        }
        try {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
        }
        catch (Exception ex) {
            this.logger.error("Problem stopping: " + this.description + "- Can't cancel timer", (Throwable)ex);
        }
        try {
            if (this.monitor != null) {
                this.monitor.shutdown();
                this.monitor = null;
            }
        }
        catch (Exception ex) {
            this.logger.error("Problem stopping: " + this.description + "- Can't shutdown monitor", (Throwable)ex);
        }
        this.future = null;
        this.monitor = null;
    }
}

