/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.config;

import io.advantageous.boon.core.Conversions;
import java.util.Properties;

public interface PropertyResolver {
    public static PropertyResolver createPropertiesPropertyResolver(String prefix, Properties properties) {
        return propertyName -> properties.getProperty(prefix + propertyName);
    }

    public static PropertyResolver createSystemPropertyResolver(String prefix) {
        return PropertyResolver.createPropertiesPropertyResolver(prefix, System.getProperties());
    }

    public Object getProperty(String var1);

    default public Integer getIntegerProperty(String propertyName) {
        Object property = this.getProperty(propertyName);
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof Enum) {
            return ((Enum)property).ordinal();
        }
        if (property instanceof CharSequence) {
            return Integer.valueOf(property.toString());
        }
        if (property == null) {
            return null;
        }
        throw new IllegalStateException("Unexpected type " + property.getClass().getName());
    }

    default public Integer getIntegerProperty(String propertyName, int defaultValue) {
        Integer value = this.getIntegerProperty(propertyName);
        return value == null ? defaultValue : value;
    }

    default public Boolean getBooleanProperty(String propertyName) {
        Object property = this.getProperty(propertyName);
        if (property instanceof Boolean) {
            return (Boolean)property;
        }
        if (property instanceof CharSequence) {
            return Boolean.valueOf(property.toString());
        }
        if (property == null) {
            return null;
        }
        throw new IllegalStateException("Unexpected type " + property.getClass().getName());
    }

    default public Boolean getBooleanProperty(String propertyName, boolean defaultValue) {
        Boolean value = this.getBooleanProperty(propertyName);
        return value == null ? defaultValue : value;
    }

    default public Long getLongProperty(String propertyName) {
        Object property = this.getProperty(propertyName);
        if (property instanceof Number) {
            return ((Number)property).longValue();
        }
        if (property instanceof Enum) {
            return ((Enum)property).ordinal();
        }
        if (property instanceof CharSequence) {
            return Long.valueOf(property.toString());
        }
        if (property == null) {
            return null;
        }
        throw new IllegalStateException("Unexpected type " + property.getClass().getName());
    }

    default public Long getLongProperty(String propertyName, long defaultValue) {
        Long value = this.getLongProperty(propertyName);
        return value == null ? defaultValue : value;
    }

    default public Double getDoubleProperty(String propertyName) {
        Object property = this.getProperty(propertyName);
        if (property instanceof Number) {
            return ((Number)property).doubleValue();
        }
        if (property instanceof CharSequence) {
            return Double.valueOf(property.toString());
        }
        if (property == null) {
            return null;
        }
        throw new IllegalStateException("Unexpected type " + property.getClass().getName());
    }

    default public Double getDoubleProperty(String propertyName, double defaultValue) {
        Double value = this.getDoubleProperty(propertyName);
        return value == null ? defaultValue : value;
    }

    default public Float getFloatProperty(String propertyName) {
        Object property = this.getProperty(propertyName);
        if (property instanceof Number) {
            return Float.valueOf(((Number)property).floatValue());
        }
        if (property instanceof CharSequence) {
            return Float.valueOf(property.toString());
        }
        if (property == null) {
            return null;
        }
        throw new IllegalStateException("Unexpected type " + property.getClass().getName());
    }

    default public Float getFloatProperty(String propertyName, float defaultValue) {
        Float value = this.getFloatProperty(propertyName);
        return Float.valueOf(value == null ? defaultValue : value.floatValue());
    }

    default public String getStringProperty(String propertyName) {
        Object property = this.getProperty(propertyName);
        if (property != null) {
            return property.toString();
        }
        return null;
    }

    default public String getStringProperty(String propertyName, String defaultValue) {
        String value = this.getStringProperty(propertyName);
        return value == null ? defaultValue : value;
    }

    default public <T> T getGenericProperty(String propertyName, Class<T> type) {
        Object value = this.getProperty(propertyName);
        if (value != null) {
            return (T)Conversions.coerce(type, (Object)value);
        }
        return null;
    }

    default public <T> T getGenericPropertyWithDefault(String propertyName, T defaultValue) {
        Object value = this.getGenericProperty(propertyName, defaultValue.getClass());
        return (T)(value == null ? defaultValue : value);
    }
}

