/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.qbit.events;

import io.advantageous.qbit.events.EventManager;
import io.advantageous.qbit.queue.Queue;
import io.advantageous.qbit.queue.ReceiveQueue;
import io.advantageous.qbit.service.Startable;
import io.advantageous.qbit.service.Stoppable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBusQueueAdapter<T>
implements Startable,
Stoppable {
    private final Queue<T> queue;
    private final EventManager eventManager;
    private final String channel;
    private final Lock lock = new ReentrantLock();
    private final Logger logger = LoggerFactory.getLogger(EventBusQueueAdapter.class);
    private final boolean debug = this.logger.isDebugEnabled();

    public EventBusQueueAdapter(Queue<T> queue, EventManager eventManager, String channel) {
        this.queue = queue;
        this.eventManager = eventManager;
        this.channel = channel;
    }

    public void process() {
        ReceiveQueue<T> receiveQueue = this.queue.receiveQueue();
        T item = receiveQueue.poll();
        while (item != null) {
            this.sendToEventManager(item);
            item = receiveQueue.poll();
        }
    }

    private void sendToEventManager(T item) {
        if (this.debug) {
            this.logger.debug("EventBusQueueAdapter::sendToEventManager({})", item);
        }
        try {
            if (this.lock.tryLock()) {
                this.eventManager.sendArguments(this.channel, item);
            } else {
                this.lock.lock();
                this.eventManager.sendArguments(this.channel, item);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void start() {
        this.queue.startListener(this::sendToEventManager);
    }

    @Override
    public void stop() {
        this.queue.stop();
    }
}

